/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.feature.misc;

import com.chan1.client.config.InsightConfig;
import com.chan1.client.feature.misc.CropGrowthDetector;
import com.chan1.client.util.render.TooltipBackgroundRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public final class CropGrowthRenderer {
    private static final int LIGHT_FULL_BRIGHT = 0xF000F0;
    private static final float MIN_READABLE_SCALE = 0.65f;
    private static final float OPTIMAL_SCALE = 0.85f;
    private static final int TEXT_COLOR = -1;
    private static final int FULLY_GROWN_COLOR = -11141291;

    public static void renderBillboards(class_4587 poseStack, class_4597 bufferSource, class_4184 camera, float partialTick) {
        if (!InsightConfig.isCropGrowthEnabled()) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null || minecraft.field_1687 == null || minecraft.field_1755 != null) {
            return;
        }
        CropGrowthDetector.CropInfo cropInfo = CropGrowthDetector.getTargetedCropInfo();
        if (cropInfo == null) {
            return;
        }
        class_243 billboardPos = CropGrowthDetector.getCropBillboardPosition(cropInfo.pos());
        class_243 cameraPos = camera.method_19326();
        class_243 toCrop = billboardPos.method_1020(cameraPos);
        double distance = toCrop.method_1033();
        class_243 cameraLookVec = new class_243(camera.method_19335());
        if (toCrop.method_1029().method_1026(cameraLookVec) < -0.2) {
            return;
        }
        if (distance > InsightConfig.getMaxRenderDistance()) {
            return;
        }
        if (bufferSource instanceof class_4597.class_4598) {
            class_4597.class_4598 source = (class_4597.class_4598)bufferSource;
            source.method_22993();
        }
        CropGrowthRenderer.renderCropTooltip(poseStack, billboardPos, distance, cameraPos, camera, minecraft.field_1772, cropInfo);
    }

    private static void renderCropTooltip(class_4587 poseStack, class_243 billboardPos, double distance, class_243 cameraPos, class_4184 camera, class_327 font, CropGrowthDetector.CropInfo cropInfo) {
        int textColor;
        String statusText;
        class_310 minecraft = class_310.method_1551();
        if (cropInfo.isFullyGrown()) {
            statusText = cropInfo.cropName() + " - Ready!";
            textColor = -11141291;
        } else {
            int percent = (int)cropInfo.getGrowthPercent();
            statusText = cropInfo.cropName() + " - " + percent + "%";
            textColor = -1;
        }
        int textWidth = font.method_1727(statusText);
        float progressBarWidth = Math.max(textWidth, 40);
        float progressBarHeight = 4.0f;
        float tooltipWidth = Math.max((float)textWidth, progressBarWidth) + 12.0f;
        Objects.requireNonNull(font);
        float tooltipHeight = 9.0f + progressBarHeight + 10.0f;
        poseStack.method_22903();
        poseStack.method_22904(billboardPos.field_1352 - cameraPos.field_1352, billboardPos.field_1351 - cameraPos.field_1351, billboardPos.field_1350 - cameraPos.field_1350);
        Quaternionf cameraRotation = camera.method_23767();
        poseStack.method_22907(cameraRotation);
        float baseScale = InsightConfig.getBillboardScale();
        float distanceScale = CropGrowthRenderer.calculateDistanceScale(distance);
        float scale = baseScale * distanceScale;
        poseStack.method_22905(-scale, -scale, scale);
        float halfWidth = tooltipWidth / 2.0f;
        float halfHeight = tooltipHeight / 2.0f;
        Matrix4f matrix = poseStack.method_23760().method_23761();
        float left = -halfWidth - 3.0f;
        float top = -halfHeight - 3.0f;
        float right = halfWidth + 3.0f;
        float bottom = halfHeight + 3.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        TooltipBackgroundRenderer.renderNoStateChange(matrix, left, top, right, bottom, 1.0f);
        class_4597.class_4598 immediateSource = minecraft.method_22940().method_23000();
        float textX = (float)(-textWidth) / 2.0f;
        float textY = -halfHeight + 4.0f;
        font.method_27521(statusText, textX, textY, textColor, false, matrix, (class_4597)immediateSource, class_327.class_6415.field_33994, 0, 0xF000F0);
        immediateSource.method_22993();
        if (!cropInfo.isFullyGrown()) {
            float barX = -progressBarWidth / 2.0f;
            Objects.requireNonNull(font);
            float barY = textY + 9.0f + 3.0f;
            float progress = cropInfo.getGrowthPercent() / 100.0f;
            CropGrowthRenderer.renderProgressBar(matrix, barX, barY, progressBarWidth, progressBarHeight, progress);
        }
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }

    private static void renderProgressBar(Matrix4f matrix, float x, float y, float width, float height, float progress) {
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        class_287 builder = tesselator.method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        float bgR = 0.2f;
        float bgG = 0.2f;
        float bgB = 0.2f;
        float bgA = 1.0f;
        builder.method_22918(matrix, x, y + height, 0.0f).method_22915(bgR, bgG, bgB, bgA).method_1344();
        builder.method_22918(matrix, x + width, y + height, 0.0f).method_22915(bgR, bgG, bgB, bgA).method_1344();
        builder.method_22918(matrix, x + width, y, 0.0f).method_22915(bgR, bgG, bgB, bgA).method_1344();
        builder.method_22918(matrix, x, y, 0.0f).method_22915(bgR, bgG, bgB, bgA).method_1344();
        class_286.method_43433((class_287.class_7433)builder.method_1326());
        if (progress > 0.0f) {
            float fillWidth = width * Math.min(1.0f, progress);
            builder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            float fillR = 0.27f;
            float fillG = 0.67f;
            float fillB = 0.27f;
            float fillA = 1.0f;
            builder.method_22918(matrix, x, y + height, 0.0f).method_22915(fillR, fillG, fillB, fillA).method_1344();
            builder.method_22918(matrix, x + fillWidth, y + height, 0.0f).method_22915(fillR, fillG, fillB, fillA).method_1344();
            builder.method_22918(matrix, x + fillWidth, y, 0.0f).method_22915(fillR, fillG, fillB, fillA).method_1344();
            builder.method_22918(matrix, x, y, 0.0f).method_22915(fillR, fillG, fillB, fillA).method_1344();
            class_286.method_43433((class_287.class_7433)builder.method_1326());
        }
    }

    private static float calculateDistanceScale(double distance) {
        float maxDist = (float)InsightConfig.getMaxRenderDistance();
        if (distance <= 1.5) {
            float t = (float)(distance / 1.5);
            return 0.65f + t * 0.20000005f * 0.5f;
        }
        if (distance <= 4.0) {
            float t = (float)((distance - 1.5) / 2.5);
            float startScale = 0.75f;
            return startScale + t * (0.85f - startScale);
        }
        float t = (float)((distance - 4.0) / ((double)maxDist - 4.0));
        t = Math.min(1.0f, Math.max(0.0f, t));
        return 0.85f + t * 0.25f;
    }
}

