/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.feature.targethud;

import com.chan1.client.config.InsightConfig;
import com.chan1.client.feature.targethud.TargetEntityDetector;
import com.chan1.client.feature.targethud.TargetHudPositioner;
import com.chan1.client.util.render.AnimationHelper;
import com.chan1.client.util.render.TooltipBackgroundRenderer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashSet;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import net.minecraft.class_757;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public final class TargetHudBillboardRenderer {
    private static final int LIGHT_FULL_BRIGHT = 0xF000F0;
    private static final float MIN_READABLE_SCALE = 0.65f;
    private static final float OPTIMAL_SCALE = 0.85f;
    private static final int HEALTH_BAR_BG_COLOR = -15066598;
    private static final int HEALTH_BAR_BORDER_COLOR = -16777216;
    private static final int HEALTH_COLOR_FULL = -11141291;
    private static final int HEALTH_COLOR_HALF = -171;
    private static final int HEALTH_COLOR_LOW = -43691;
    private static final AnimationHelper animationHelper = new AnimationHelper();

    private TargetHudBillboardRenderer() {
    }

    public static void renderBillboards(class_4587 poseStack, class_4597 bufferSource, class_4184 camera, float partialTick) {
        if (!InsightConfig.isTargetHudEnabled()) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null || minecraft.field_1687 == null || minecraft.field_1755 != null) {
            return;
        }
        class_1309 target = TargetEntityDetector.getHoveredEntity();
        HashSet<Integer> currentEntityIds = new HashSet<Integer>();
        if (target != null) {
            currentEntityIds.add(target.method_5628());
        } else {
            TargetHudPositioner.clear();
        }
        animationHelper.cleanupStaleAnimations(currentEntityIds);
        if (target == null) {
            return;
        }
        class_243 cameraPos = camera.method_19326();
        class_243 entityPos = TargetHudBillboardRenderer.getInterpolatedPosition(target, partialTick);
        class_243 toEntity = entityPos.method_1020(cameraPos);
        double distance = toEntity.method_1033();
        class_243 cameraLookVec = new class_243(camera.method_19335());
        if (toEntity.method_1029().method_1026(cameraLookVec) < -0.2) {
            return;
        }
        if (distance > InsightConfig.getMaxRenderDistance()) {
            return;
        }
        if (bufferSource instanceof class_4597.class_4598) {
            class_4597.class_4598 source = (class_4597.class_4598)bufferSource;
            source.method_22993();
        }
        float animScale = 1.0f;
        if (InsightConfig.isAnimationsEnabled()) {
            animationHelper.getOrCreateAppearAnimation(target.method_5628());
            AnimationHelper.AnimationState state = animationHelper.getAnimationState(target.method_5628());
            if (state != null) {
                animScale = AnimationHelper.calculateScale(state, InsightConfig.getAnimationDurationMs());
            }
        }
        if (animScale > 0.001f) {
            TargetHudBillboardRenderer.renderTargetHud(poseStack, bufferSource, target, entityPos, distance, cameraPos, camera, minecraft.field_1772, animScale);
        }
    }

    private static void renderTargetHud(class_4587 poseStack, class_4597 bufferSource, class_1309 entity, class_243 entityPos, double distance, class_243 cameraPos, class_4184 camera, class_327 font, float animScale) {
        class_310 minecraft = class_310.method_1551();
        float alpha = 1.0f;
        class_2561 entityName = entity.method_5476();
        float health = entity.method_6032();
        float maxHealth = entity.method_6063();
        float healthPercent = Math.min(1.0f, health / maxHealth);
        String healthText = String.format("%.1f / %.1f", Float.valueOf(health), Float.valueOf(maxHealth));
        int nameWidth = font.method_27525((class_5348)entityName);
        int healthTextWidth = font.method_1727(healthText);
        int healthBarWidth = Math.max(nameWidth, healthTextWidth) + 10;
        healthBarWidth = Math.max(healthBarWidth, 60);
        int tooltipWidth = healthBarWidth + 12;
        int healthBarHeight = 6;
        int tooltipHeight = 12 + healthBarHeight + 2 + 10 + 4;
        class_243 billboardPos = TargetHudPositioner.calculateBillboardPosition(entity, entityPos, camera, InsightConfig.getTooltipYOffset(), InsightConfig.isTargetHudSmartPositioning());
        poseStack.method_22903();
        poseStack.method_22904(billboardPos.field_1352 - cameraPos.field_1352, billboardPos.field_1351 - cameraPos.field_1351, billboardPos.field_1350 - cameraPos.field_1350);
        Quaternionf cameraRotation = camera.method_23767();
        poseStack.method_22907(cameraRotation);
        float baseScale = InsightConfig.getBillboardScale();
        float distanceScale = TargetHudBillboardRenderer.calculateDistanceScale(distance);
        float scale = baseScale * distanceScale * animScale;
        poseStack.method_22905(-scale, -scale, scale);
        float halfWidth = (float)tooltipWidth / 2.0f;
        float halfHeight = (float)tooltipHeight / 2.0f;
        Matrix4f matrix = poseStack.method_23760().method_23761();
        float left = -halfWidth - 3.0f;
        float top = -halfHeight - 3.0f;
        float right = halfWidth + 3.0f;
        float bottom = halfHeight + 3.0f;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        TooltipBackgroundRenderer.renderNoStateChange(matrix, left, top, right, bottom, alpha);
        class_4597.class_4598 immediateSource = minecraft.method_22940().method_23000();
        int textAlpha = (int)(255.0f * alpha);
        float nameX = (float)(-nameWidth) / 2.0f;
        float nameY = -halfHeight + 4.0f;
        font.method_30882(entityName, nameX, nameY, textAlpha << 24 | 0xFFFFFF, false, matrix, (class_4597)immediateSource, class_327.class_6415.field_33994, 0, 0xF000F0);
        immediateSource.method_22993();
        float barLeft = (float)(-healthBarWidth) / 2.0f;
        float barTop = nameY + 12.0f;
        float barRight = (float)healthBarWidth / 2.0f;
        float barBottom = barTop + (float)healthBarHeight;
        TargetHudBillboardRenderer.renderHealthBar(matrix, barLeft, barTop, barRight, barBottom, healthPercent, alpha);
        immediateSource = minecraft.method_22940().method_23000();
        float healthTextX = (float)(-healthTextWidth) / 2.0f;
        float healthTextY = barBottom + 3.0f;
        int healthColor = TargetHudBillboardRenderer.getHealthColor(healthPercent);
        font.method_27521(healthText, healthTextX, healthTextY, textAlpha << 24 | healthColor & 0xFFFFFF, false, matrix, (class_4597)immediateSource, class_327.class_6415.field_33994, 0, 0xF000F0);
        immediateSource.method_22993();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        poseStack.method_22909();
    }

    private static void renderHealthBar(Matrix4f matrix, float left, float top, float right, float bottom, float healthPercent, float alpha) {
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        float z = 0.0f;
        TargetHudBillboardRenderer.addQuad(buffer, matrix, left - 1.0f, top - 1.0f, right + 1.0f, top, z, -16777216, alpha);
        TargetHudBillboardRenderer.addQuad(buffer, matrix, left - 1.0f, bottom, right + 1.0f, bottom + 1.0f, z, -16777216, alpha);
        TargetHudBillboardRenderer.addQuad(buffer, matrix, left - 1.0f, top, left, bottom, z, -16777216, alpha);
        TargetHudBillboardRenderer.addQuad(buffer, matrix, right, top, right + 1.0f, bottom, z, -16777216, alpha);
        TargetHudBillboardRenderer.addQuad(buffer, matrix, left, top, right, bottom, z, -15066598, alpha);
        float fillWidth = (right - left) * healthPercent;
        int healthColor = TargetHudBillboardRenderer.getHealthColor(healthPercent);
        TargetHudBillboardRenderer.addQuad(buffer, matrix, left, top, left + fillWidth, bottom, z, healthColor, alpha);
        tesselator.method_1350();
    }

    private static void addQuad(class_287 buffer, Matrix4f matrix, float x1, float y1, float x2, float y2, float z, int color, float alpha) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f * alpha;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        buffer.method_22918(matrix, x1, y1, z).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, x1, y2, z).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, x2, y2, z).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, x2, y1, z).method_22915(r, g, b, a).method_1344();
    }

    private static int getHealthColor(float healthPercent) {
        if (healthPercent > 0.5f) {
            float t = (healthPercent - 0.5f) * 2.0f;
            return TargetHudBillboardRenderer.interpolateColor(-171, -11141291, t);
        }
        float t = healthPercent * 2.0f;
        return TargetHudBillboardRenderer.interpolateColor(-43691, -171, t);
    }

    private static int interpolateColor(int color1, int color2, float t) {
        int a1 = color1 >> 24 & 0xFF;
        int r1 = color1 >> 16 & 0xFF;
        int g1 = color1 >> 8 & 0xFF;
        int b1 = color1 & 0xFF;
        int a2 = color2 >> 24 & 0xFF;
        int r2 = color2 >> 16 & 0xFF;
        int g2 = color2 >> 8 & 0xFF;
        int b2 = color2 & 0xFF;
        int a = (int)((float)a1 + (float)(a2 - a1) * t);
        int r = (int)((float)r1 + (float)(r2 - r1) * t);
        int g = (int)((float)g1 + (float)(g2 - g1) * t);
        int b = (int)((float)b1 + (float)(b2 - b1) * t);
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static class_243 getInterpolatedPosition(class_1309 entity, float partialTick) {
        double x = entity.field_6014 + (entity.method_23317() - entity.field_6014) * (double)partialTick;
        double y = entity.field_6036 + (entity.method_23318() - entity.field_6036) * (double)partialTick;
        double z = entity.field_5969 + (entity.method_23321() - entity.field_5969) * (double)partialTick;
        return new class_243(x, y, z);
    }

    private static float calculateDistanceScale(double distance) {
        float maxDist = (float)InsightConfig.getMaxRenderDistance();
        if (distance <= 1.5) {
            float t = (float)(distance / 1.5);
            return 0.65f + t * 0.20000005f * 0.5f;
        }
        if (distance <= 4.0) {
            float t = (float)((distance - 1.5) / 2.5);
            float startScale = 0.75f;
            return startScale + t * (0.85f - startScale);
        }
        float t = (float)((distance - 4.0) / ((double)maxDist - 4.0));
        t = Math.min(1.0f, Math.max(0.0f, t));
        return 0.85f + t * 0.25f;
    }

    public static void clearAnimations() {
        animationHelper.clear();
        TargetHudPositioner.clear();
    }
}

