/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.feature.targethud;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_4184;

public final class TargetHudPositioner {
    private static final float POSITION_LERP_SPEED = 0.035f;
    private static final double HUD_OFFSET_DISTANCE = 0.85;
    private static final Map<Integer, class_243> currentPositions = new HashMap<Integer, class_243>();

    private TargetHudPositioner() {
    }

    public static class_243 calculateBillboardPosition(class_1309 entity, class_243 entityPos, class_4184 camera, double yOffset, boolean smartEnabled) {
        float height = entity.method_17682();
        class_243 fallback = entityPos.method_1031(0.0, (double)height + yOffset, 0.0);
        if (!smartEnabled) {
            return fallback;
        }
        int entityId = entity.method_5628();
        class_243 targetPosition = TargetHudPositioner.calculateOptimalPosition(entity, entityPos, camera, yOffset);
        class_243 currentPosition = currentPositions.get(entityId);
        if (currentPosition == null) {
            currentPosition = targetPosition;
        }
        class_243 newPosition = TargetHudPositioner.lerpVec3(currentPosition, targetPosition, 0.035f);
        currentPositions.put(entityId, newPosition);
        return newPosition;
    }

    private static class_243 calculateOptimalPosition(class_1309 entity, class_243 entityPos, class_4184 camera, double yOffset) {
        double minOffset;
        double currentHorizOffset;
        double baseY;
        double baseZ;
        double baseX;
        class_243 cameraPos = camera.method_19326();
        float height = entity.method_17682();
        float halfWidth = entity.method_17681() / 2.0f;
        class_243 entityCenter = entityPos.method_1031(0.0, (double)height * 0.5, 0.0);
        double entityTopY = entityPos.field_1351 + (double)height + yOffset;
        class_243 lookDir = new class_243(camera.method_19335());
        class_243 upDir = new class_243(camera.method_19336());
        class_243 rightDir = lookDir.method_1036(upDir).method_1029();
        class_243 toEntity = entityCenter.method_1020(cameraPos);
        double dist = toEntity.method_1033();
        if (dist < 0.1) {
            return entityPos.method_1031(0.0, (double)height + yOffset, 0.0);
        }
        class_243 toCamera = toEntity.method_1029().method_1021(-1.0);
        class_243 crosshairPoint = cameraPos.method_1019(lookDir.method_1021(dist));
        class_243 entityToCrosshair = crosshairPoint.method_1020(entityCenter);
        double crosshairDist = entityToCrosshair.method_1033();
        double cameraPitch = Math.toRadians(camera.method_19329());
        double topAboveCamera = entityTopY - cameraPos.field_1351;
        double deadZone = (double)halfWidth + 1.2;
        boolean crosshairOnEntity = crosshairDist < deadZone;
        boolean lookingDownAtEntity = cameraPos.field_1351 > entityCenter.field_1351 && cameraPitch > 0.25;
        double topPositionBadness = 0.0;
        if (topAboveCamera > 0.4) {
            topPositionBadness = Math.min(1.0, (topAboveCamera - 0.4) / 2.0);
        }
        if ((double)height > 1.8) {
            topPositionBadness = Math.max(topPositionBadness, Math.min(1.0, ((double)height - 1.8) / 1.8));
        }
        if (cameraPitch > 0.2) {
            double downBadness = Math.min(1.0, (cameraPitch - 0.2) / 0.6);
            topPositionBadness = Math.max(topPositionBadness, downBadness * 0.6);
        }
        double offsetDist = 0.85 + (double)halfWidth + 0.25;
        if (crosshairOnEntity || lookingDownAtEntity && cameraPitch > 0.4) {
            double sideDir = 1.0;
            double dotRight = entityToCrosshair.field_1352 * rightDir.field_1352 + entityToCrosshair.field_1350 * rightDir.field_1350;
            if (Math.abs(dotRight) > 0.3) {
                sideDir = Math.signum(dotRight);
            }
            double sideStrength = 0.7;
            if (lookingDownAtEntity && cameraPitch > 0.4) {
                sideStrength = 0.75 + 0.15 * Math.min(1.0, (cameraPitch - 0.4) / 0.4);
            }
            baseX = rightDir.field_1352 * sideDir * offsetDist * sideStrength;
            baseZ = rightDir.field_1350 * sideDir * offsetDist * sideStrength;
            double blend = TargetHudPositioner.easeOutCubic(topPositionBadness);
            double topY = (double)height + yOffset;
            double sideY = (double)height * 0.5;
            baseY = topY + (sideY - topY) * Math.max(blend, lookingDownAtEntity ? 0.4 : 0.0);
        } else {
            class_243 towardsCrosshair = entityToCrosshair.method_1029();
            double horizShiftX = towardsCrosshair.field_1352;
            double horizShiftZ = towardsCrosshair.field_1350;
            double horizLen = Math.sqrt(horizShiftX * horizShiftX + horizShiftZ * horizShiftZ);
            if (horizLen > 0.01) {
                horizShiftX /= horizLen;
                horizShiftZ /= horizLen;
            } else {
                horizShiftX = rightDir.field_1352;
                horizShiftZ = rightDir.field_1350;
            }
            double effectiveOffset = Math.max(0.0, crosshairDist - deadZone);
            double horizStrength = Math.min(1.0, effectiveOffset / 3.5);
            horizStrength = TargetHudPositioner.easeOutQuad(horizStrength) * 0.6;
            baseX = horizShiftX * offsetDist * (0.5 + 0.3 * horizStrength);
            baseZ = horizShiftZ * offsetDist * (0.5 + 0.3 * horizStrength);
            double blend = TargetHudPositioner.easeOutCubic(topPositionBadness);
            double topY = (double)height + yOffset;
            double sideY = (double)height * 0.55;
            baseY = topY + (sideY - topY) * blend;
        }
        double camerawardBias = 0.15;
        baseX += toCamera.field_1352 * camerawardBias;
        baseZ += toCamera.field_1350 * camerawardBias;
        if (dist < 2.0) {
            double closeFactor = Math.min(1.0, (2.0 - dist) / 1.5);
            closeFactor = TargetHudPositioner.easeOutQuad(closeFactor);
            baseX *= 1.0 + 0.25 * closeFactor;
            baseZ *= 1.0 + 0.25 * closeFactor;
        }
        if ((currentHorizOffset = Math.sqrt(baseX * baseX + baseZ * baseZ)) < (minOffset = (double)halfWidth + 0.4) && currentHorizOffset > 0.01) {
            double scale = minOffset / currentHorizOffset;
            baseX *= scale;
            baseZ *= scale;
        }
        return entityPos.method_1031(baseX, baseY, baseZ);
    }

    private static double easeOutQuad(double t) {
        return 1.0 - (1.0 - t) * (1.0 - t);
    }

    private static double easeOutCubic(double t) {
        return 1.0 - Math.pow(1.0 - t, 3.0);
    }

    private static class_243 lerpVec3(class_243 from, class_243 to, float t) {
        return new class_243(from.field_1352 + (to.field_1352 - from.field_1352) * (double)t, from.field_1351 + (to.field_1351 - from.field_1351) * (double)t, from.field_1350 + (to.field_1350 - from.field_1350) * (double)t);
    }

    public static void clear() {
        currentPositions.clear();
    }
}

