/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.util;

import net.minecraft.class_638;

public final class MinecraftTimeHelper {
    public static final long DAY_LENGTH = 24000L;
    public static final long NIGHT_START = 12542L;
    public static final long NIGHT_END = 23460L;

    private MinecraftTimeHelper() {
    }

    public static boolean isNightTime(class_638 level) {
        if (level == null) {
            return false;
        }
        long dayTime = level.method_8532() % 24000L;
        return dayTime >= 12542L || dayTime < 0L;
    }

    public static long getTicksUntilNight(class_638 level) {
        if (level == null) {
            return 0L;
        }
        long dayTime = level.method_8532() % 24000L;
        if (dayTime >= 12542L) {
            return 0L;
        }
        return 12542L - dayTime;
    }

    public static String formatTimeUntilNight(class_638 level) {
        long ticksUntilNight = MinecraftTimeHelper.getTicksUntilNight(level);
        if (ticksUntilNight <= 0L) {
            return null;
        }
        long totalSeconds = ticksUntilNight / 20L;
        long minutes = totalSeconds / 60L;
        long seconds = totalSeconds % 60L;
        return String.format("(%d:%02d) minutes until night", minutes, seconds);
    }
}

