/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.util.detection;

import com.chan1.client.config.InsightConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_746;

public final class CrosshairDetector {
    private static long lastCacheFrame = -1L;
    private static class_239 cachedVanillaHit = null;
    private static class_3965 cachedBlockTarget = null;
    private static boolean blockSearchDone = false;
    private static class_243 cachedEyePos = null;
    private static class_243 cachedLookVec = null;
    private static double cachedRange = 0.0;

    private CrosshairDetector() {
    }

    public static <T extends class_1297> T getTargetedEntity(Class<T> entityClass) {
        class_1297 entity;
        CrosshairDetector.refreshCacheIfNeeded();
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return null;
        }
        if (cachedVanillaHit != null && cachedVanillaHit.method_17783() == class_239.class_240.field_1331 && entityClass.isInstance(entity = ((class_3966)cachedVanillaHit).method_17782())) {
            return (T)entity;
        }
        return CrosshairDetector.findEntityManual(mc, entityClass, null);
    }

    public static <T extends class_1297> T getTargetedEntity(Class<T> entityClass, Predicate<T> validator) {
        class_1297 typed;
        class_1297 entity;
        CrosshairDetector.refreshCacheIfNeeded();
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return null;
        }
        if (cachedVanillaHit != null && cachedVanillaHit.method_17783() == class_239.class_240.field_1331 && entityClass.isInstance(entity = ((class_3966)cachedVanillaHit).method_17782()) && validator.test(typed = entity)) {
            return (T)typed;
        }
        return CrosshairDetector.findEntityManual(mc, entityClass, validator);
    }

    public static class_3965 getTargetedBlockHit() {
        class_3965 blockHit;
        double distance;
        CrosshairDetector.refreshCacheIfNeeded();
        if (blockSearchDone) {
            return cachedBlockTarget;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null) {
            blockSearchDone = true;
            return null;
        }
        if (cachedVanillaHit != null && cachedVanillaHit.method_17783() == class_239.class_240.field_1332 && (distance = cachedEyePos.method_1022(class_243.method_24953((class_2382)(blockHit = (class_3965)cachedVanillaHit).method_17777()))) <= cachedRange) {
            cachedBlockTarget = blockHit;
            blockSearchDone = true;
            return cachedBlockTarget;
        }
        cachedBlockTarget = CrosshairDetector.findBlockManual(mc);
        blockSearchDone = true;
        return cachedBlockTarget;
    }

    public static <T extends class_2248> BlockTarget<T> getTargetedBlockInfo(Class<T> blockClass) {
        class_3965 hit = CrosshairDetector.getTargetedBlockHit();
        if (hit == null || hit.method_17783() != class_239.class_240.field_1332) {
            return null;
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null) {
            return null;
        }
        class_2338 pos = hit.method_17777();
        class_2680 state = mc.field_1687.method_8320(pos);
        if (blockClass.isInstance(state.method_26204())) {
            class_2248 block = state.method_26204();
            return new BlockTarget<class_2248>(pos, state, block, hit);
        }
        return null;
    }

    public static <T extends class_1297> List<T> getNearbyEntities(Class<T> entityClass, double range, Predicate<T> validator) {
        CrosshairDetector.refreshCacheIfNeeded();
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null) {
            return List.of();
        }
        class_746 player = mc.field_1724;
        class_243 playerPos = player.method_19538();
        class_243 eyePos = cachedEyePos;
        class_243 lookVec = cachedLookVec;
        double rangeSq = range * range;
        class_238 searchBox = new class_238(playerPos.field_1352 - range, playerPos.field_1351 - range, playerPos.field_1350 - range, playerPos.field_1352 + range, playerPos.field_1351 + range, playerPos.field_1350 + range);
        List candidates = mc.field_1687.method_8390(entityClass, searchBox, validator != null ? validator : e -> true);
        ArrayList<class_1297> filtered = new ArrayList<class_1297>();
        for (class_1297 entity : candidates) {
            class_243 toEntity;
            double viewDot;
            class_243 entityPos = entity.method_19538();
            double distSq = entityPos.method_1025(playerPos);
            if (distSq > rangeSq || (viewDot = (toEntity = entityPos.method_1020(eyePos).method_1029()).method_1026(lookVec)) < -0.3) continue;
            filtered.add(entity);
        }
        filtered.sort((a, b) -> {
            boolean bInFront;
            class_243 toA = a.method_19538().method_1020(eyePos).method_1029();
            class_243 toB = b.method_19538().method_1020(eyePos).method_1029();
            double viewScoreA = toA.method_1026(lookVec);
            double viewScoreB = toB.method_1026(lookVec);
            boolean aInFront = viewScoreA > 0.7;
            boolean bl = bInFront = viewScoreB > 0.7;
            if (aInFront && !bInFront) {
                return -1;
            }
            if (bInFront && !aInFront) {
                return 1;
            }
            double distA = a.method_5707(playerPos);
            double distB = b.method_5707(playerPos);
            return Double.compare(distA, distB);
        });
        return filtered;
    }

    private static <T extends class_1297> T findEntityManual(class_310 mc, Class<T> typeFilter, Predicate<T> validator) {
        class_746 player = mc.field_1724;
        class_243 eyePos = cachedEyePos;
        class_243 lookVec = cachedLookVec;
        double maxRange = cachedRange;
        class_243 endPos = eyePos.method_1019(lookVec.method_1021(maxRange));
        class_238 searchBox = new class_238(eyePos, endPos).method_1014(2.0);
        double closestDistSq = Double.MAX_VALUE;
        class_1297 closest = null;
        Class<Object> searchClass = typeFilter != null ? typeFilter : class_1297.class;
        for (class_1297 entity : mc.field_1687.method_18467(searchClass, searchBox)) {
            double distSq;
            float entityRadius;
            double tolerance;
            double maxDeviationSq;
            class_243 pointOnRay;
            double deviationSq;
            if (entity == player) continue;
            class_1297 typedEntity = entity;
            if (validator != null && !validator.test(typedEntity)) continue;
            class_238 entityBox = entity.method_5829();
            Optional intersection = entityBox.method_992(eyePos, endPos);
            if (intersection.isPresent()) {
                double distSq2 = eyePos.method_1025((class_243)intersection.get());
                if (!(distSq2 < closestDistSq)) continue;
                closestDistSq = distSq2;
                closest = typedEntity;
                continue;
            }
            class_243 entityCenter = entity.method_19538().method_1031(0.0, (double)(entity.method_17682() / 2.0f), 0.0);
            class_243 toEntity = entityCenter.method_1020(eyePos);
            double projection = toEntity.method_1026(lookVec);
            if (projection <= 0.0 || projection > maxRange || (deviationSq = entityCenter.method_1025(pointOnRay = eyePos.method_1019(lookVec.method_1021(projection)))) > (maxDeviationSq = (tolerance = (double)(entityRadius = Math.max(entity.method_17681() / 2.0f, entity.method_17682() / 2.0f)) + 0.3) * tolerance) || !((distSq = toEntity.method_1027()) < closestDistSq)) continue;
            closestDistSq = distSq;
            closest = typedEntity;
        }
        return (T)closest;
    }

    private static class_3965 findBlockManual(class_310 mc) {
        class_243 eyePos = cachedEyePos;
        class_243 lookVec = cachedLookVec;
        double maxRange = cachedRange;
        class_243 endPos = eyePos.method_1019(lookVec.method_1021(maxRange));
        class_3959 clipContext = new class_3959(eyePos, endPos, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)mc.field_1724);
        class_3965 result = mc.field_1687.method_17742(clipContext);
        if (result.method_17783() == class_239.class_240.field_1332) {
            return result;
        }
        return null;
    }

    private static void refreshCacheIfNeeded() {
        long currentFrame;
        class_310 mc = class_310.method_1551();
        long l = currentFrame = mc.field_1687 != null ? mc.field_1687.method_8510() : 0L;
        if (currentFrame != lastCacheFrame) {
            lastCacheFrame = currentFrame;
            cachedVanillaHit = mc.field_1765;
            cachedBlockTarget = null;
            blockSearchDone = false;
            if (mc.field_1724 != null) {
                cachedEyePos = mc.field_1724.method_33571();
                cachedLookVec = mc.field_1724.method_5720();
                cachedRange = InsightConfig.getDetectionRange();
            } else {
                cachedEyePos = null;
                cachedLookVec = null;
                cachedRange = 0.0;
            }
        }
    }

    public record BlockTarget<T extends class_2248>(class_2338 pos, class_2680 state, T block, class_3965 hitResult) {
    }
}

