/*
 * Decompiled with CFR 0.152.
 */
package com.chan1.client.util.render;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_757;
import org.joml.Matrix4f;

public final class TooltipBackgroundRenderer {
    public static final int BACKGROUND_COLOR = -267386864;
    public static final int BORDER_START_COLOR = -12582708;
    public static final int BORDER_END_COLOR = -14679968;

    private TooltipBackgroundRenderer() {
    }

    public static void render(Matrix4f matrix, float left, float top, float right, float bottom, float alpha) {
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.disableDepthTest();
        TooltipBackgroundRenderer.renderNoStateChange(matrix, left, top, right, bottom, alpha);
        RenderSystem.enableDepthTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public static void renderNoStateChange(Matrix4f matrix, float left, float top, float right, float bottom, float alpha) {
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        class_287 buffer = tesselator.method_1349();
        buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        int bgAlpha = (int)(240.0f * alpha);
        int borderStartAlpha = (int)(255.0f * alpha);
        int borderEndAlpha = (int)(255.0f * alpha);
        float blackA = alpha;
        float bgR = 0.0627451f;
        float bgG = 0.0f;
        float bgB = 0.0627451f;
        float bgA = (float)bgAlpha / 255.0f;
        float bsR = 0.2509804f;
        float bsG = 0.0f;
        float bsB = 0.8f;
        float bsA = (float)borderStartAlpha / 255.0f;
        float beR = 0.1254902f;
        float beG = 0.0f;
        float beB = 0.3764706f;
        float beA = (float)borderEndAlpha / 255.0f;
        float z = 0.0f;
        TooltipBackgroundRenderer.addQuad(buffer, matrix, left - 1.0f, top - 2.0f, right + 1.0f, top - 1.0f, z, 0.0f, 0.0f, 0.0f, blackA);
        TooltipBackgroundRenderer.addQuad(buffer, matrix, left - 1.0f, bottom + 1.0f, right + 1.0f, bottom + 2.0f, z, 0.0f, 0.0f, 0.0f, blackA);
        TooltipBackgroundRenderer.addQuad(buffer, matrix, left - 2.0f, top - 1.0f, left - 1.0f, bottom + 1.0f, z, 0.0f, 0.0f, 0.0f, blackA);
        TooltipBackgroundRenderer.addQuad(buffer, matrix, right + 1.0f, top - 1.0f, right + 2.0f, bottom + 1.0f, z, 0.0f, 0.0f, 0.0f, blackA);
        TooltipBackgroundRenderer.addQuad(buffer, matrix, left - 1.0f, top - 1.0f, right + 1.0f, top, z, bsR, bsG, bsB, bsA);
        TooltipBackgroundRenderer.addQuad(buffer, matrix, left - 1.0f, bottom, right + 1.0f, bottom + 1.0f, z, beR, beG, beB, beA);
        TooltipBackgroundRenderer.addGradientQuad(buffer, matrix, left - 1.0f, top, left, bottom, z, bsR, bsG, bsB, bsA, beR, beG, beB, beA);
        TooltipBackgroundRenderer.addGradientQuad(buffer, matrix, right, top, right + 1.0f, bottom, z, bsR, bsG, bsB, bsA, beR, beG, beB, beA);
        TooltipBackgroundRenderer.addQuad(buffer, matrix, left, top, right, bottom, z, bgR, bgG, bgB, bgA);
        tesselator.method_1350();
    }

    public static void addQuad(class_287 buffer, Matrix4f matrix, float x1, float y1, float x2, float y2, float z, float r, float g, float b, float a) {
        buffer.method_22918(matrix, x1, y1, z).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, x1, y2, z).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, x2, y2, z).method_22915(r, g, b, a).method_1344();
        buffer.method_22918(matrix, x2, y1, z).method_22915(r, g, b, a).method_1344();
    }

    public static void addGradientQuad(class_287 buffer, Matrix4f matrix, float x1, float y1, float x2, float y2, float z, float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2) {
        buffer.method_22918(matrix, x1, y1, z).method_22915(r1, g1, b1, a1).method_1344();
        buffer.method_22918(matrix, x1, y2, z).method_22915(r2, g2, b2, a2).method_1344();
        buffer.method_22918(matrix, x2, y2, z).method_22915(r2, g2, b2, a2).method_1344();
        buffer.method_22918(matrix, x2, y1, z).method_22915(r1, g1, b1, a1).method_1344();
    }
}

