/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import java.io.File;
import me.langyue.autotranslation.config.Config;
import me.langyue.autotranslation.config.TranslationSettings;
import me.langyue.autotranslation.proxy.CommonProxy;
import me.langyue.autotranslation.resource.ResourceManager;
import me.langyue.autotranslation.translate.TranslateThreadPool;
import me.langyue.autotranslation.translate.TranslatorManager;
import me.langyue.autotranslation.translate.google.Google;
import me.langyue.autotranslation.util.QmawTranslator;
import me.langyue.autotranslation.util.TranslatorHelper;
import net.minecraft.client.Minecraft;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="autotranslation", name="AutoTranslation", version="1.0.0")
public class AutoTranslation {
    public static final String MODID = "autotranslation";
    public static final String NAME = "AutoTranslation";
    public static final String VERSION = "1.0.0";
    public static final Logger LOGGER = LogManager.getLogger((String)"AutoTranslation");
    public static final Logger AT_LOG = LogManager.getLogger((String)"AutoTranslationLog");
    public static File ROOT;
    public static Config CONFIG;
    @SidedProxy(clientSide="me.langyue.autotranslation.proxy.ClientProxy", serverSide="me.langyue.autotranslation.proxy.CommonProxy")
    public static CommonProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        LOGGER.info("AutoTranslation PreInitialization");
        ROOT = new File(event.getModConfigurationDirectory().getParentFile(), NAME);
        if (!ROOT.exists()) {
            ROOT.mkdirs();
        }
        CONFIG = new Config(event.getSuggestedConfigurationFile());
        CONFIG.load();
        TranslationSettings.loadFromConfig(CONFIG);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        LOGGER.info("AutoTranslation Initialization");
        ResourceManager.init();
        TranslatorManager.init();
        TranslatorHelper.init();
        QmawTranslator.initAsync();
        proxy.init();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        proxy.registerCommands(event);
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        LOGGER.info("AutoTranslation Stopping - Saving data");
        ResourceManager.save();
        ResourceManager.shutdown();
        TranslateThreadPool.shutdown();
        Google.shutdown();
        CONFIG.save();
    }

    public static String getLanguage() {
        try {
            return Minecraft.func_71410_x().field_71474_y.field_74363_ab;
        }
        catch (Throwable e) {
            return "en_US";
        }
    }

    public static void debug(String message, Object ... args) {
        if (AutoTranslation.CONFIG.debug) {
            LOGGER.info(message, args);
        }
    }
}

