/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.command;

import java.util.ArrayList;
import java.util.List;
import me.langyue.autotranslation.AutoTranslation;
import me.langyue.autotranslation.resource.ResourceManager;
import me.langyue.autotranslation.util.TranslatorHelper;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;

public class AutoTranslationCommand
extends CommandBase {
    public String func_71517_b() {
        return "autotranslation";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/autotranslation <reload|save|clear|debug>";
    }

    public List<String> func_71514_a() {
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add("at");
        aliases.add("autotrans");
        return aliases;
    }

    public int func_82362_a() {
        return 0;
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        String subCommand;
        if (args.length == 0) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7aAutoTranslation v1.0.0"));
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a77Usage: " + this.func_71518_a(sender)));
            return;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                this.handleReload(sender);
                break;
            }
            case "save": {
                this.handleSave(sender);
                break;
            }
            case "clear": {
                this.handleClear(sender);
                break;
            }
            case "debug": {
                this.handleDebug(sender);
                break;
            }
            case "info": {
                this.handleInfo(sender);
                break;
            }
            default: {
                sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7cUnknown subcommand: " + subCommand));
                sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a77Usage: " + this.func_71518_a(sender)));
            }
        }
    }

    private void handleReload(ICommandSender sender) {
        try {
            ResourceManager.reload();
            AutoTranslation.CONFIG.load();
            TranslatorHelper.init();
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7aAutoTranslation reloaded successfully!"));
        }
        catch (Exception e) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7cError reloading: " + e.getMessage()));
            AutoTranslation.LOGGER.error("Error reloading", (Throwable)e);
        }
    }

    private void handleSave(ICommandSender sender) {
        try {
            ResourceManager.save();
            AutoTranslation.CONFIG.save();
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7aTranslations saved successfully!"));
        }
        catch (Exception e) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7cError saving: " + e.getMessage()));
            AutoTranslation.LOGGER.error("Error saving", (Throwable)e);
        }
    }

    private void handleClear(ICommandSender sender) {
        try {
            TranslatorHelper.clearCache();
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7aTranslation cache cleared!"));
        }
        catch (Exception e) {
            sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7cError clearing cache: " + e.getMessage()));
            AutoTranslation.LOGGER.error("Error clearing cache", (Throwable)e);
        }
    }

    private void handleDebug(ICommandSender sender) {
        AutoTranslation.CONFIG.debug = !AutoTranslation.CONFIG.debug;
        sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a7aDebug mode: " + (AutoTranslation.CONFIG.debug ? "\u00a72ON" : "\u00a7cOFF")));
    }

    private void handleInfo(ICommandSender sender) {
        sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a76=== AutoTranslation Info ==="));
        sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a77Version: \u00a7f1.0.0"));
        sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a77Language: \u00a7f" + AutoTranslation.getLanguage()));
        sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a77Translator: \u00a7f" + AutoTranslation.CONFIG.translator));
        sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a77Debug: \u00a7f" + AutoTranslation.CONFIG.debug));
        sender.func_145747_a((IChatComponent)new ChatComponentText("\u00a77Append Original: \u00a7f" + AutoTranslation.CONFIG.appendOriginal));
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        if (args.length == 1) {
            ArrayList<String> options = new ArrayList<String>();
            options.add("reload");
            options.add("save");
            options.add("clear");
            options.add("debug");
            options.add("info");
            return AutoTranslationCommand.func_71530_a((String[])args, (String[])options.toArray(new String[0]));
        }
        return null;
    }
}

