/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.config;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.Configuration;

public class Config {
    private Configuration config;
    public String translator = "Google";
    public boolean appendOriginal = true;
    public boolean debug = false;
    public boolean enableChat = false;
    public boolean enableTooltips = true;
    public boolean enableGui = true;
    public boolean enableScreen = true;
    public boolean enableManuals = true;
    public String enFeature = "[A-Z]?[a-z]+\\s([A-Z]?[a-z]+\\s*)+";
    public String yourLanguageFeature = "";
    public List<String> wordBlacklist = new ArrayList<String>();
    public GoogleConfig google = new GoogleConfig();

    public Config(File file) {
        this.config = new Configuration(file);
    }

    public void load() {
        this.config.load();
        this.translator = this.config.getString("translator", "General", "Google", "Translation API to use (currently only Google is available)");
        this.appendOriginal = this.config.getBoolean("appendOriginal", "General", true, "Append original text after translation");
        this.debug = this.config.getBoolean("debug", "General", false, "Enable debug logging");
        this.enableChat = this.config.getBoolean("enableChat", "Modes", true, "Enable chat translation");
        this.enableTooltips = this.config.getBoolean("enableTooltips", "Modes", true, "Enable tooltips translation");
        this.enableGui = this.config.getBoolean("enableGui", "Modes", true, "Enable GUI/buttons/items translation");
        this.enableScreen = this.config.getBoolean("enableScreen", "Modes", true, "Enable screen FontRenderer proxy translation");
        this.enableManuals = this.config.getBoolean("enableManuals", "Modes", true, "Enable HBM manuals translation");
        this.enFeature = this.config.getString("enFeature", "Translation", "[A-Z]?[a-z]+\\s([A-Z]?[a-z]+\\s*)+", "Regex pattern to detect English text");
        this.yourLanguageFeature = this.config.getString("yourLanguageFeature", "Translation", ".*[\u0410-\u042f\u0430-\u044f\u0401\u0451].*", "Regex pattern to detect your language (e.g. Cyrillic for Russian). Default: detects Cyrillic");
        String[] defaultBlacklist = new String[]{"Minecraft", "Forge", "Java", "FPS", "TPS"};
        this.wordBlacklist = Arrays.asList(this.config.getStringList("wordBlacklist", "Translation", defaultBlacklist, "Words that should not be translated"));
        this.google.domain = this.config.getString("domain", "Google", "translate.google.com", "Google Translate domain");
        this.google.dns = Arrays.asList(this.config.getStringList("dns", "Google", new String[]{"142.250.185.46", "142.251.1.90", "172.217.160.46"}, "DNS IP addresses for Google Translate (for China users)"));
        this.save();
    }

    public void save() {
        if (this.config == null) {
            return;
        }
        this.config.get("Modes", "enableChat", this.enableChat).set(this.enableChat);
        this.config.get("Modes", "enableTooltips", this.enableTooltips).set(this.enableTooltips);
        this.config.get("Modes", "enableGui", this.enableGui).set(this.enableGui);
        this.config.get("Modes", "enableScreen", this.enableScreen).set(this.enableScreen);
        this.config.get("Modes", "enableManuals", this.enableManuals).set(this.enableManuals);
        this.config.get("General", "translator", this.translator).set(this.translator);
        this.config.get("General", "appendOriginal", this.appendOriginal).set(this.appendOriginal);
        this.config.get("General", "debug", this.debug).set(this.debug);
        this.config.get("Translation", "enFeature", this.enFeature).set(this.enFeature);
        this.config.get("Translation", "yourLanguageFeature", this.yourLanguageFeature).set(this.yourLanguageFeature);
        this.config.get("Translation", "wordBlacklist", this.wordBlacklist.toArray(new String[0])).set(this.wordBlacklist.toArray(new String[0]));
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public static class GoogleConfig {
        public String domain = "translate.google.com";
        public List<String> dns = new ArrayList<String>();
    }
}

