/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.config;

import me.langyue.autotranslation.AutoTranslation;
import me.langyue.autotranslation.config.Config;
import me.langyue.autotranslation.util.QmawTranslator;

public class TranslationSettings {
    public static boolean enableChat;
    public static boolean enableTooltips;
    public static boolean enableGui;
    public static boolean enableScreen;
    public static boolean enableManuals;

    public static void loadFromConfig(Config cfg) {
        enableChat = false;
        cfg.enableChat = false;
        enableTooltips = cfg.enableTooltips;
        enableGui = cfg.enableGui;
        enableScreen = cfg.enableScreen;
        enableManuals = cfg.enableManuals;
    }

    public static void saveToConfig(Config cfg) {
        cfg.enableChat = enableChat;
        cfg.enableTooltips = enableTooltips;
        cfg.enableGui = enableGui;
        cfg.enableScreen = enableScreen;
        cfg.enableManuals = enableManuals;
        cfg.save();
    }

    public static void toggleChat(Config cfg) {
        enableChat = false;
        cfg.enableChat = false;
        TranslationSettings.saveToConfig(cfg);
        AutoTranslation.LOGGER.info("Chat translation is disabled; use Screen mode instead");
    }

    public static void toggleTooltips(Config cfg) {
        enableTooltips = !enableTooltips;
        TranslationSettings.saveToConfig(cfg);
        AutoTranslation.LOGGER.info("Tooltip translation: {}", new Object[]{enableTooltips ? "ON" : "OFF"});
    }

    public static void toggleGui(Config cfg) {
        enableGui = !enableGui;
        TranslationSettings.saveToConfig(cfg);
        AutoTranslation.LOGGER.info("GUI translation: {}", new Object[]{enableGui ? "ON" : "OFF"});
    }

    public static void setGuiAndTooltips(Config cfg, boolean enabled) {
        enableGui = enabled;
        enableTooltips = enabled;
        TranslationSettings.saveToConfig(cfg);
        AutoTranslation.LOGGER.info("GUI/Tooltips translation: {}", new Object[]{enabled ? "ON" : "OFF"});
    }

    public static void toggleScreen(Config cfg) {
        enableScreen = !enableScreen;
        TranslationSettings.saveToConfig(cfg);
        AutoTranslation.LOGGER.info("Screen translation: {}", new Object[]{enableScreen ? "ON" : "OFF"});
    }

    public static void toggleManuals(Config cfg) {
        enableManuals = !enableManuals;
        TranslationSettings.saveToConfig(cfg);
        AutoTranslation.LOGGER.info("Manuals translation: {}", new Object[]{enableManuals ? "ON" : "OFF"});
        if (enableManuals) {
            QmawTranslator.rerunAsync();
        }
    }
}

