/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import me.langyue.autotranslation.AutoTranslation;
import me.langyue.autotranslation.config.TranslationSettings;
import me.langyue.autotranslation.util.TranslatorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public class BookHandler {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private ItemStack lastBook = null;
    private boolean translating = false;
    private Set<String> translatedBooks = new HashSet<String>();

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!TranslationSettings.enableGui) {
            return;
        }
        GuiScreen currentScreen = BookHandler.mc.field_71462_r;
        if (!(currentScreen instanceof GuiScreenBook)) {
            this.lastBook = null;
            return;
        }
        GuiScreenBook bookGui = (GuiScreenBook)currentScreen;
        ItemStack book = this.getBookFromGui(bookGui);
        if (book == null || this.translating) {
            return;
        }
        String bookId = this.getBookId(book);
        if (bookId != null && this.translatedBooks.contains(bookId)) {
            return;
        }
        if (book != this.lastBook) {
            this.lastBook = book;
            this.translating = true;
            this.translateBook(book, bookId);
        }
    }

    private ItemStack getBookFromGui(GuiScreenBook bookGui) {
        try {
            Field[] fields = GuiScreenBook.class.getDeclaredFields();
            AutoTranslation.LOGGER.info("Looking for book field in GuiScreenBook, found {} fields", new Object[]{fields.length});
            for (Field field : fields) {
                AutoTranslation.LOGGER.info("Field: {} Type: {}", new Object[]{field.getName(), field.getType().getName()});
                if (field.getType() != ItemStack.class) continue;
                field.setAccessible(true);
                ItemStack book = (ItemStack)field.get(bookGui);
                AutoTranslation.LOGGER.info("Found book field: {}, book: {}", new Object[]{field.getName(), book});
                return book;
            }
            AutoTranslation.LOGGER.info("No ItemStack field found, trying to get book from player...");
            ItemStack heldItem = BookHandler.mc.field_71439_g.func_70694_bm();
            if (heldItem != null && heldItem.func_77973_b() != null) {
                String itemName = heldItem.func_77973_b().getClass().getSimpleName();
                AutoTranslation.LOGGER.info("Player holding: {}", new Object[]{itemName});
                if (itemName.toLowerCase().contains("book") || heldItem.func_77973_b().func_77658_a().contains("book")) {
                    AutoTranslation.LOGGER.info("Found book in player hand!");
                    return heldItem;
                }
            }
            AutoTranslation.LOGGER.warn("Could not find book!");
        }
        catch (Exception e) {
            AutoTranslation.LOGGER.error("Failed to get book from GUI", (Throwable)e);
        }
        return null;
    }

    private String getBookId(ItemStack book) {
        NBTTagList pages;
        if (!book.func_77942_o()) {
            return null;
        }
        NBTTagCompound tag = book.func_77978_p();
        if (tag.func_74764_b("title")) {
            return tag.func_74779_i("title");
        }
        if (tag.func_74764_b("pages") && (pages = (NBTTagList)tag.func_74781_a("pages")).func_74745_c() > 0) {
            return String.valueOf(pages.func_150305_b(0).toString().hashCode());
        }
        return null;
    }

    private void translateBook(ItemStack book, String bookId) {
        if (!book.func_77942_o()) {
            this.translating = false;
            return;
        }
        NBTTagCompound tag = book.func_77978_p();
        if (!tag.func_74764_b("pages")) {
            this.translating = false;
            return;
        }
        NBTTagList pages = (NBTTagList)tag.func_74781_a("pages");
        int totalPages = pages.func_74745_c();
        if (totalPages <= 0) {
            this.translating = false;
            return;
        }
        AutoTranslation.LOGGER.info("Translating book with {} pages", new Object[]{totalPages});
        int[] translatedCount = new int[]{0};
        AutoTranslation.LOGGER.info("Processing {} pages...", new Object[]{totalPages});
        for (int i = 0; i < totalPages; ++i) {
            String pageText = pages.func_150307_f(i);
            AutoTranslation.LOGGER.info("Page {} text: {}", new Object[]{i + 1, pageText});
            if (pageText == null || pageText.isEmpty()) {
                translatedCount[0] = translatedCount[0] + 1;
                this.checkComplete(translatedCount, totalPages, bookId);
                continue;
            }
            if (TranslatorHelper.shouldTranslate(pageText = pageText.replaceAll("^\"|\"$", ""))) {
                int pageIndex = i;
                String originalText = pageText;
                AutoTranslation.LOGGER.info("Page {} should translate: {}", new Object[]{pageIndex + 1, originalText.substring(0, Math.min(50, originalText.length()))});
                TranslatorHelper.translate(originalText, false, translated -> {
                    try {
                        pages.func_150304_a(pageIndex, (NBTBase)new NBTTagString(translated));
                        translatedCount[0] = translatedCount[0] + 1;
                        AutoTranslation.LOGGER.info("Translated page {}/{}: {}", new Object[]{pageIndex + 1, totalPages, translated.length() > 50 ? translated.substring(0, 50) + "..." : translated});
                        this.checkComplete(translatedCount, totalPages, bookId);
                        if (translatedCount[0] >= totalPages && bookId != null) {
                            this.translatedBooks.add(bookId);
                        }
                    }
                    catch (Exception e) {
                        AutoTranslation.LOGGER.error("Failed to translate page " + (pageIndex + 1), (Throwable)e);
                    }
                });
                continue;
            }
            AutoTranslation.LOGGER.info("Page {} skipped (no English or already translated)", new Object[]{i + 1});
            translatedCount[0] = translatedCount[0] + 1;
            this.checkComplete(translatedCount, totalPages, bookId);
        }
    }

    private void checkComplete(int[] translatedCount, int totalPages, String bookId) {
        if (translatedCount[0] >= totalPages) {
            if (bookId != null) {
                this.translatedBooks.add(bookId);
            }
            this.translating = false;
        }
    }
}

