/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import me.langyue.autotranslation.AutoTranslation;
import me.langyue.autotranslation.util.TranslatorHelper;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;

public class ChatHandler {
    private static final boolean CHAT_TRANSLATION_DISABLED = true;

    @SubscribeEvent
    public void onChatMessage(ClientChatReceivedEvent event) {
    }

    private IChatComponent translateComponent(IChatComponent component) {
        if (component == null) {
            return null;
        }
        String originalText = component.func_150261_e();
        String cleanText = originalText != null ? originalText.trim() : "";
        String translated = null;
        boolean hasTranslation = false;
        if (cleanText.length() >= 2) {
            translated = TranslatorHelper.translateCached(cleanText);
            boolean bl = hasTranslation = translated != null && !translated.equals(cleanText);
            if (!hasTranslation) {
                TranslatorHelper.translate(cleanText, false, t -> {});
                translated = cleanText;
            } else {
                translated = TranslatorHelper.reapplyFormatting(component.func_150254_d(), translated);
            }
        } else {
            translated = cleanText;
        }
        boolean hasSiblingChanges = false;
        ArrayList<IChatComponent> translatedSiblings = new ArrayList<IChatComponent>();
        for (Object sibling : component.func_150253_a()) {
            IChatComponent siblingComponent = (IChatComponent)sibling;
            IChatComponent translatedSibling = this.translateComponent(siblingComponent);
            if (translatedSibling != null && translatedSibling != siblingComponent) {
                hasSiblingChanges = true;
                translatedSiblings.add(translatedSibling);
                continue;
            }
            translatedSiblings.add(siblingComponent);
        }
        if (hasTranslation || hasSiblingChanges) {
            ChatComponentText resultComponent = new ChatComponentText(translated != null ? translated : cleanText);
            if (component.func_150256_b() != null) {
                resultComponent.func_150255_a(component.func_150256_b().func_150232_l());
            }
            for (IChatComponent sibling : translatedSiblings) {
                if (sibling == null) continue;
                resultComponent.func_150257_a(sibling);
            }
            if (hasTranslation) {
                AutoTranslation.debug("Chat translated: {} -> {}", cleanText, translated);
            }
            return resultComponent;
        }
        return component;
    }
}

