/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.handler;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import me.langyue.autotranslation.AutoTranslation;
import me.langyue.autotranslation.handler.ScreenTranslatorHandler;
import me.langyue.autotranslation.util.TranslatorHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.util.ResourceLocation;

public class FontRendererTranslationProxy
extends FontRenderer {
    private final FontRenderer original;
    private static final Map<String, String> pendingTranslations = new ConcurrentHashMap<String, String>();

    public FontRendererTranslationProxy(GameSettings settings, ResourceLocation location, TextureManager textureManager, boolean unicode, FontRenderer original) {
        super(settings, location, textureManager, unicode);
        this.original = original;
        this.field_78288_b = original.field_78288_b;
    }

    public int func_85187_a(String text, int x, int y, int color, boolean dropShadow) {
        if (ScreenTranslatorHandler.isTranslationEnabled() && text != null && !text.isEmpty()) {
            if (this.isQmawContext()) {
                String cleanText;
                if (AutoTranslation.CONFIG != null && AutoTranslation.CONFIG.debug && (cleanText = text.replaceAll("\u00a7[0-9a-fk-or]", "")).length() > 5) {
                    boolean hasLinks = cleanText.contains("[[");
                    AutoTranslation.debug("QMAW render: {} (hasLinks: {})", cleanText.length() > 50 ? cleanText.substring(0, 50) + "..." : cleanText, hasLinks);
                }
                return this.original.func_85187_a(text, x, y, color, dropShadow);
            }
            boolean trailingSpace = text.endsWith(" ");
            String cleanText = text.replaceAll("\u00a7[0-9a-fk-or]", "");
            String keyForLookup = cleanText.trim();
            if (keyForLookup.length() >= 2) {
                String translated = TranslatorHelper.translateCached(keyForLookup);
                if (translated != null && !translated.equals(keyForLookup)) {
                    if (trailingSpace) {
                        translated = translated + " ";
                    }
                    text = TranslatorHelper.reapplyFormatting(text, translated);
                    AutoTranslation.debug("Screen text translated: {} -> {}", cleanText, translated);
                } else {
                    String pendingTranslation = pendingTranslations.get(keyForLookup);
                    if (pendingTranslation != null && !pendingTranslation.equals(keyForLookup)) {
                        if (trailingSpace) {
                            pendingTranslation = pendingTranslation + " ";
                        }
                        text = TranslatorHelper.reapplyFormatting(text, pendingTranslation);
                    } else if (pendingTranslation == null) {
                        pendingTranslations.put(keyForLookup, keyForLookup);
                        TranslatorHelper.translate(keyForLookup, false, translatedText -> {
                            if (translatedText != null && !translatedText.equals(keyForLookup)) {
                                pendingTranslations.put(keyForLookup, (String)translatedText);
                                AutoTranslation.debug("Screen text translated (async): {} -> {}", cleanText, translatedText);
                            }
                        });
                    }
                }
            }
        }
        return this.original.func_85187_a(text, x, y, color, dropShadow);
    }

    public int func_78276_b(String text, int x, int y, int color) {
        return this.func_85187_a(text, x, y, color, false);
    }

    public int func_78261_a(String text, int x, int y, int color) {
        return this.func_85187_a(text, x, y, color, true);
    }

    public int func_78256_a(String text) {
        String keyForLookup;
        String cleanText;
        if (ScreenTranslatorHandler.isTranslationEnabled() && text != null && !text.isEmpty()) {
            if (this.isQmawContext()) {
                return this.original.func_78256_a(text);
            }
            boolean trailingSpace = text.endsWith(" ");
            cleanText = text.replaceAll("\u00a7[0-9a-fk-or]", "");
            keyForLookup = cleanText.trim();
            if (keyForLookup.length() >= 2) {
                String translated = TranslatorHelper.translateCached(keyForLookup);
                if (translated != null && !translated.equals(keyForLookup)) {
                    if (trailingSpace) {
                        translated = translated + " ";
                    }
                    text = TranslatorHelper.reapplyFormatting(text, translated);
                } else {
                    String pendingTranslation = pendingTranslations.get(keyForLookup);
                    if (pendingTranslation != null && !pendingTranslation.equals(keyForLookup)) {
                        if (trailingSpace) {
                            pendingTranslation = pendingTranslation + " ";
                        }
                        text = TranslatorHelper.reapplyFormatting(text, pendingTranslation);
                    }
                }
            }
        }
        int width = this.original.func_78256_a(text);
        if (ScreenTranslatorHandler.isTranslationEnabled() && text != null) {
            cleanText = text.replaceAll("\u00a7[0-9a-fk-or]", "");
            keyForLookup = cleanText.trim();
            boolean isFullText = cleanText.contains(" ") && cleanText.length() > 10;
            boolean allowWordWidth = this.isQmawContext();
            if ((isFullText || allowWordWidth) && keyForLookup.length() >= 2) {
                String translated = TranslatorHelper.translateCached(keyForLookup);
                if (translated != null && !translated.equals(keyForLookup)) {
                    String withFormat = TranslatorHelper.reapplyFormatting(text, translated);
                    width = Math.max(width, this.original.func_78256_a(withFormat));
                } else {
                    String pending = pendingTranslations.get(keyForLookup);
                    if (pending != null && !pending.equals(keyForLookup)) {
                        String withFormat = TranslatorHelper.reapplyFormatting(text, pending);
                        width = Math.max(width, this.original.func_78256_a(withFormat));
                    }
                }
            }
        }
        return width;
    }

    private boolean isQmawContext() {
        try {
            for (StackTraceElement el : Thread.currentThread().getStackTrace()) {
                String cn = el.getClassName();
                if (cn == null || !cn.contains("com.hbm.qmaw.GuiQMAW")) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int func_78263_a(char character) {
        return this.original.func_78263_a(character);
    }

    public String func_78269_a(String text, int width) {
        return this.original.func_78269_a(text, width);
    }

    public String func_78262_a(String text, int width, boolean reverse) {
        return this.original.func_78262_a(text, width, reverse);
    }

    public void func_78279_b(String str, int x, int y, int wrapWidth, int textColor) {
        String cleanText;
        if (ScreenTranslatorHandler.isTranslationEnabled() && str != null && !str.isEmpty() && (cleanText = str.replaceAll("\u00a7[0-9a-fk-or]", "").trim()).length() >= 2) {
            String translated = TranslatorHelper.translateCached(cleanText);
            if (translated != null && !translated.equals(cleanText)) {
                str = TranslatorHelper.reapplyFormatting(str, translated);
                AutoTranslation.debug("Screen split text translated: {} -> {}", cleanText, translated);
            } else {
                String pendingTranslation = pendingTranslations.get(cleanText);
                if (pendingTranslation != null && !pendingTranslation.equals(cleanText)) {
                    str = TranslatorHelper.reapplyFormatting(str, pendingTranslation);
                } else if (pendingTranslation == null) {
                    pendingTranslations.put(cleanText, cleanText);
                    TranslatorHelper.translate(cleanText, false, translatedText -> {
                        if (translatedText != null && !translatedText.equals(cleanText)) {
                            pendingTranslations.put(cleanText, (String)translatedText);
                            AutoTranslation.debug("Screen split text translated (async): {} -> {}", cleanText, translatedText);
                        }
                    });
                }
            }
        }
        this.original.func_78279_b(str, x, y, wrapWidth, textColor);
    }

    public int func_78267_b(String str, int maxLength) {
        return this.original.func_78267_b(str, maxLength);
    }

    public void func_78264_a(boolean unicodeFlagIn) {
        this.original.func_78264_a(unicodeFlagIn);
    }

    public boolean func_82883_a() {
        return this.original.func_82883_a();
    }

    public void func_78275_b(boolean bidiFlagIn) {
        this.original.func_78275_b(bidiFlagIn);
    }

    public static void savePendingTranslations() {
        AutoTranslation.LOGGER.info("Clearing {} pending translations (no persistence)", new Object[]{pendingTranslations.size()});
        pendingTranslations.clear();
    }

    public static int getPendingTranslationsSize() {
        return pendingTranslations.size();
    }

    public static void clearPendingTranslations() {
        pendingTranslations.clear();
    }
}

