/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.langyue.autotranslation.AutoTranslation;
import me.langyue.autotranslation.config.TranslationSettings;
import me.langyue.autotranslation.util.TranslatorHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.client.event.GuiScreenEvent;

public class GuiHandler {
    private static final Map<Class<?>, List<Field>> STRING_FIELDS_CACHE = new HashMap();
    private static final Set<String> TRANSLATED_STRINGS = new HashSet<String>();

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!TranslationSettings.enableGui) {
            return;
        }
        GuiScreen gui = event.gui;
        List buttonList = this.getButtonList(gui);
        if (buttonList != null) {
            for (Object obj : buttonList) {
                if (!(obj instanceof GuiButton)) continue;
                GuiButton button = (GuiButton)obj;
                this.translateButton(button);
            }
        }
        if (AutoTranslation.CONFIG.debug) {
            this.translateGuiFields(gui);
        }
    }

    @SubscribeEvent
    public void onGuiDraw(GuiScreenEvent.DrawScreenEvent.Pre event) {
        if (!TranslationSettings.enableGui) {
            return;
        }
        GuiScreen gui = event.gui;
        List buttonList = this.getButtonList(gui);
        if (buttonList != null) {
            for (Object obj : buttonList) {
                if (!(obj instanceof GuiButton)) continue;
                GuiButton button = (GuiButton)obj;
                this.translateButton(button);
            }
        }
    }

    private List getButtonList(GuiScreen gui) {
        try {
            Field buttonListField;
            try {
                buttonListField = GuiScreen.class.getDeclaredField("buttonList");
            }
            catch (NoSuchFieldException e) {
                buttonListField = GuiScreen.class.getDeclaredField("field_146292_n");
            }
            buttonListField.setAccessible(true);
            return (List)buttonListField.get(gui);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void translateButton(GuiButton button) {
        String displayString = button.field_146126_j;
        if (displayString == null || displayString.isEmpty()) {
            return;
        }
        String cleanText = displayString.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
        if (cleanText.length() < 2) {
            return;
        }
        String translated = TranslatorHelper.translateCached(cleanText);
        if (translated != null && !translated.equals(cleanText)) {
            if (displayString.startsWith("\u00a7") && displayString.length() > 2) {
                String colorCode = displayString.substring(0, 2);
                translated = colorCode + translated;
            }
            button.field_146126_j = translated;
            AutoTranslation.debug("Button translated: {} -> {}", cleanText, translated);
        } else {
            TranslatorHelper.translate(cleanText, false, translatedText -> {
                if (translatedText != null && !translatedText.equals(cleanText)) {
                    if (displayString.startsWith("\u00a7") && displayString.length() > 2) {
                        String colorCode = displayString.substring(0, 2);
                        translatedText = colorCode + translatedText;
                    }
                    button.field_146126_j = translatedText;
                    AutoTranslation.debug("Button translated (async): {} -> {}", cleanText, translatedText);
                }
            });
        }
    }

    private void translateGuiFields(GuiScreen gui) {
        Class<?> guiClass = gui.getClass();
        if (!STRING_FIELDS_CACHE.containsKey(guiClass)) {
            ArrayList<Field> stringFields = new ArrayList<Field>();
            for (Field field : this.getAllFields(guiClass)) {
                if (field.getType() != String.class) continue;
                field.setAccessible(true);
                stringFields.add(field);
            }
            STRING_FIELDS_CACHE.put(guiClass, stringFields);
        }
        for (Field field : STRING_FIELDS_CACHE.get(guiClass)) {
            try {
                String value = (String)field.get(gui);
                if (value == null || !TranslatorHelper.shouldTranslate(value) || !TranslatorHelper.hasCache(value)) continue;
                String translated = TranslatorHelper.translateCached(value);
                field.set(gui, translated);
                AutoTranslation.debug("GUI field translated: {} -> {}", value, translated);
            }
            catch (Exception exception) {}
        }
    }

    private List<Field> getAllFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null && clazz != Object.class) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    @SubscribeEvent
    public void onGuiClose(GuiScreenEvent.InitGuiEvent.Pre event) {
        TRANSLATED_STRINGS.clear();
    }

    public static void clearTranslatedStrings() {
        TRANSLATED_STRINGS.clear();
        AutoTranslation.debug("Cleared translated strings cache", new Object[0]);
    }
}

