/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import me.langyue.autotranslation.config.TranslationSettings;
import me.langyue.autotranslation.util.TranslatorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class HotbarHandler {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private String lastItemName = "";
    private int displayTicks = 0;
    private static final int DISPLAY_DURATION = 50;
    private static final int FADE_DURATION = 10;

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        if (!TranslationSettings.enableGui) {
            return;
        }
        if (HotbarHandler.mc.field_71439_g == null || HotbarHandler.mc.field_71474_y.field_74330_P) {
            return;
        }
        ItemStack heldItem = HotbarHandler.mc.field_71439_g.func_70694_bm();
        if (heldItem == null) {
            this.lastItemName = "";
            this.displayTicks = 0;
            return;
        }
        String itemName = heldItem.func_82833_r();
        if (itemName == null || itemName.isEmpty()) {
            return;
        }
        String cleanItemName = itemName.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
        if (!cleanItemName.equals(this.lastItemName)) {
            this.lastItemName = cleanItemName;
            this.displayTicks = 50;
        } else if (this.displayTicks > 0) {
            --this.displayTicks;
        }
        if (this.displayTicks <= 0) {
            return;
        }
        String translatedName = TranslatorHelper.translateCached(cleanItemName);
        if (translatedName == null || translatedName.equals(cleanItemName)) {
            TranslatorHelper.translate(cleanItemName, false, translated -> {});
            return;
        }
        float alpha = 1.0f;
        if (this.displayTicks < 10) {
            alpha = (float)this.displayTicks / 10.0f;
        }
        this.renderTranslatedItemName(translatedName, alpha);
    }

    private void renderTranslatedItemName(String translatedName, float alpha) {
        FontRenderer fontRenderer = HotbarHandler.mc.field_71466_p;
        ScaledResolution scaledResolution = new ScaledResolution(mc, HotbarHandler.mc.field_71443_c, HotbarHandler.mc.field_71440_d);
        int screenWidth = scaledResolution.func_78326_a();
        int screenHeight = scaledResolution.func_78328_b();
        int textWidth = fontRenderer.func_78256_a(translatedName);
        int x = (screenWidth - textWidth) / 2;
        int y = screenHeight - 59;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int padding = 2;
        int bgAlpha = (int)(alpha * 128.0f);
        int bgColor = bgAlpha << 24 | 0;
        this.drawRect(x - padding, y - padding, x + textWidth + padding, y + fontRenderer.field_78288_b + padding, bgColor);
        int textAlpha = (int)(alpha * 255.0f);
        int textColor = textAlpha << 24 | 0xFFFFFF;
        fontRenderer.func_78261_a(translatedName, x, y, textColor);
        GL11.glDisable((int)3042);
    }

    private void drawRect(int left, int top, int right, int bottom, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)left, (double)bottom);
        GL11.glVertex2d((double)right, (double)bottom);
        GL11.glVertex2d((double)right, (double)top);
        GL11.glVertex2d((double)left, (double)top);
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }
}

