/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import me.langyue.autotranslation.AutoTranslation;
import me.langyue.autotranslation.config.TranslationSettings;
import me.langyue.autotranslation.handler.FontRendererTranslationProxy;
import me.langyue.autotranslation.handler.GuiHandler;
import me.langyue.autotranslation.util.QmawTranslator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import org.lwjgl.opengl.GL11;

public class ScreenTranslatorHandler {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static boolean translationEnabled = false;
    private static FontRenderer originalFontRenderer = null;
    private static FontRendererTranslationProxy proxyFontRenderer = null;

    public static void toggleTranslation() {
        boolean bl = translationEnabled = !translationEnabled;
        if (translationEnabled) {
            TranslationSettings.enableScreen = true;
            ScreenTranslatorHandler.installFontRendererProxy();
            AutoTranslation.LOGGER.info("Screen translation ENABLED - FontRenderer proxy installed");
            QmawTranslator.rerunAsync();
            QmawTranslator.forceLangIfPossible(AutoTranslation.getLanguage());
        } else {
            TranslationSettings.enableScreen = false;
            ScreenTranslatorHandler.uninstallFontRendererProxy();
            AutoTranslation.LOGGER.info("Screen translation DISABLED - FontRenderer proxy removed");
        }
        TranslationSettings.saveToConfig(AutoTranslation.CONFIG);
    }

    public static boolean isTranslationEnabled() {
        return translationEnabled && TranslationSettings.enableScreen;
    }

    public static void syncWithSettings() {
        if (TranslationSettings.enableScreen && !translationEnabled) {
            translationEnabled = true;
            ScreenTranslatorHandler.installFontRendererProxy();
            AutoTranslation.LOGGER.info("Screen translation restored from config (enabled)");
        } else if (!TranslationSettings.enableScreen && translationEnabled) {
            translationEnabled = false;
            ScreenTranslatorHandler.uninstallFontRendererProxy();
            AutoTranslation.LOGGER.info("Screen translation restored from config (disabled)");
        }
    }

    private static void installFontRendererProxy() {
        try {
            if (proxyFontRenderer != null && ScreenTranslatorHandler.mc.field_71466_p == proxyFontRenderer) {
                AutoTranslation.debug("FontRenderer proxy already installed", new Object[0]);
                return;
            }
            if (originalFontRenderer == null || ScreenTranslatorHandler.mc.field_71466_p != proxyFontRenderer) {
                Field[] minecraftFields;
                Field[] allFields;
                if (proxyFontRenderer != null && ScreenTranslatorHandler.mc.field_71466_p != proxyFontRenderer) {
                    AutoTranslation.LOGGER.warn("FontRenderer proxy was lost! Reinstalling...");
                }
                originalFontRenderer = ScreenTranslatorHandler.mc.field_71466_p;
                AutoTranslation.LOGGER.info("Original FontRenderer saved: {}", new Object[]{originalFontRenderer.getClass().getName()});
                ResourceLocation fontLocation = null;
                for (Field field : allFields = FontRenderer.class.getDeclaredFields()) {
                    if (field.getType() != ResourceLocation.class) continue;
                    field.setAccessible(true);
                    try {
                        Object value = field.get(originalFontRenderer);
                        if (!(value instanceof ResourceLocation)) continue;
                        fontLocation = (ResourceLocation)value;
                        AutoTranslation.LOGGER.info("Found FontRenderer ResourceLocation field: {} = {}", new Object[]{field.getName(), fontLocation});
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (fontLocation == null) {
                    fontLocation = new ResourceLocation("textures/font/ascii.png");
                    AutoTranslation.LOGGER.warn("FontRenderer ResourceLocation field not found, using default: {}", new Object[]{fontLocation});
                }
                proxyFontRenderer = new FontRendererTranslationProxy(ScreenTranslatorHandler.mc.field_71474_y, fontLocation, ScreenTranslatorHandler.mc.field_71446_o, originalFontRenderer.func_82883_a(), originalFontRenderer);
                Field fontRendererField = null;
                for (Field field : minecraftFields = Minecraft.class.getDeclaredFields()) {
                    if (field.getType() != FontRenderer.class) continue;
                    field.setAccessible(true);
                    try {
                        Object value = field.get(mc);
                        if (!(value instanceof FontRenderer)) continue;
                        fontRendererField = field;
                        AutoTranslation.LOGGER.info("Found Minecraft FontRenderer field: {}", new Object[]{field.getName()});
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (fontRendererField == null) {
                    throw new RuntimeException("Could not find FontRenderer field in Minecraft class!");
                }
                fontRendererField.set(mc, (Object)proxyFontRenderer);
                AutoTranslation.LOGGER.info("FontRenderer proxy successfully installed! (mc.fontRenderer == proxy: {}, proxy class: {})", new Object[]{ScreenTranslatorHandler.mc.field_71466_p == proxyFontRenderer, ((Object)((Object)proxyFontRenderer)).getClass().getName()});
            }
        }
        catch (Exception e) {
            AutoTranslation.LOGGER.error("Failed to install FontRenderer proxy", (Throwable)e);
        }
    }

    private static void uninstallFontRendererProxy() {
        try {
            if (originalFontRenderer != null) {
                Field[] minecraftFields;
                Field fontRendererField = null;
                for (Field field : minecraftFields = Minecraft.class.getDeclaredFields()) {
                    if (field.getType() != FontRenderer.class) continue;
                    field.setAccessible(true);
                    fontRendererField = field;
                    AutoTranslation.LOGGER.debug("Found Minecraft FontRenderer field: {}", new Object[]{field.getName()});
                    break;
                }
                if (fontRendererField == null) {
                    throw new RuntimeException("Could not find FontRenderer field in Minecraft class!");
                }
                if (proxyFontRenderer != null) {
                    AutoTranslation.LOGGER.info("Saving pending translations before uninstalling proxy...");
                    int pendingSize = FontRendererTranslationProxy.getPendingTranslationsSize();
                    FontRendererTranslationProxy.savePendingTranslations();
                    FontRendererTranslationProxy.clearPendingTranslations();
                    if (pendingSize > 0) {
                        AutoTranslation.LOGGER.info("Pending translations processed: {} entries", new Object[]{pendingSize});
                    }
                }
                fontRendererField.set(mc, originalFontRenderer);
                GuiHandler.clearTranslatedStrings();
                proxyFontRenderer = null;
                originalFontRenderer = null;
                AutoTranslation.LOGGER.info("FontRenderer proxy successfully removed!");
            }
        }
        catch (Exception e) {
            AutoTranslation.LOGGER.error("Failed to uninstall FontRenderer proxy", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (translationEnabled) {
            GuiScreen gui;
            if (proxyFontRenderer == null || ScreenTranslatorHandler.mc.field_71466_p != proxyFontRenderer) {
                AutoTranslation.debug("Reinstalling FontRenderer proxy on GUI init (screen: {})", event.gui != null ? event.gui.getClass().getSimpleName() : "null");
                ScreenTranslatorHandler.installFontRendererProxy();
            }
            if ((gui = event.gui) != null && gui.getClass().getName().contains("com.hbm.qmaw.GuiQMAW")) {
                QmawTranslator.forceLangIfPossible(AutoTranslation.getLanguage());
                QmawTranslator.rerunAsync();
            }
        }
    }

    @SubscribeEvent
    public void onGuiDrawPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        this.renderIndicator();
    }

    private void renderIndicator() {
        if (!translationEnabled) {
            return;
        }
        ScaledResolution scaledResolution = new ScaledResolution(mc, ScreenTranslatorHandler.mc.field_71443_c, ScreenTranslatorHandler.mc.field_71440_d);
        int screenWidth = scaledResolution.func_78326_a();
        FontRenderer fontRenderer = originalFontRenderer != null ? originalFontRenderer : ScreenTranslatorHandler.mc.field_71466_p;
        String indicatorText = "[RU]";
        int textWidth = fontRenderer.func_78256_a(indicatorText);
        int x = screenWidth - textWidth - 4;
        int y = 4;
        GL11.glPushMatrix();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        int bgColor = Integer.MIN_VALUE;
        this.drawRect(x - 2, y - 2, x + textWidth + 2, y + fontRenderer.field_78288_b + 2, bgColor);
        GL11.glDisable((int)3042);
        GL11.glPopMatrix();
        int drawX = x;
        drawX = this.drawColoredChar(fontRenderer, "[", drawX, y, 0xFFFFFF);
        drawX = this.drawColoredChar(fontRenderer, "R", drawX, y, 0xFF5555);
        drawX = this.drawColoredChar(fontRenderer, "U", drawX, y, 0x55AAFF);
        this.drawColoredChar(fontRenderer, "]", drawX, y, 0xFFFFFF);
    }

    private int drawColoredChar(FontRenderer fr, String ch, int x, int y, int color) {
        fr.func_78261_a(ch, x, y, color);
        return x + fr.func_78256_a(ch);
    }

    private void drawRect(int left, int top, int right, int bottom, int color) {
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)a);
        GL11.glBegin((int)7);
        GL11.glVertex2d((double)left, (double)bottom);
        GL11.glVertex2d((double)right, (double)bottom);
        GL11.glVertex2d((double)right, (double)top);
        GL11.glVertex2d((double)left, (double)top);
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }
}

