/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import me.langyue.autotranslation.AutoTranslation;
import me.langyue.autotranslation.config.TranslationSettings;
import me.langyue.autotranslation.util.TranslatorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;

public class TooltipHandler {
    private static final int MAX_TOOLTIP_WIDTH = 200;

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (!TranslationSettings.enableTooltips) {
            return;
        }
        List tooltip = event.toolTip;
        if (tooltip == null || tooltip.isEmpty()) {
            return;
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        for (int i = 0; i < tooltip.size(); ++i) {
            String cleanLine;
            String cleanKey;
            String line = (String)tooltip.get(i);
            if (line == null || line.isEmpty() || (cleanKey = (cleanLine = line.replaceAll("\u00a7[0-9a-fk-or]", "")).trim()).length() < 2) continue;
            String translated = TranslatorHelper.translateCached(cleanKey);
            if (translated != null && !translated.equals(cleanLine)) {
                String textToCheck = TranslatorHelper.reapplyFormatting(line, translated);
                int textWidth = fontRenderer.func_78256_a(textToCheck);
                if (textWidth > 200) {
                    List<String> wrappedLines = this.wrapText(fontRenderer, textToCheck, 200);
                    if (wrappedLines != null && !wrappedLines.isEmpty()) {
                        this.propagateFormatting(wrappedLines);
                        tooltip.set(i, wrappedLines.get(0));
                        for (int j = 1; j < wrappedLines.size(); ++j) {
                            tooltip.add(i + j, wrappedLines.get(j));
                        }
                        AutoTranslation.debug("Tooltip wrapped: {} -> {} lines (width: {} > {})", cleanLine, wrappedLines.size(), textWidth, 200);
                    } else {
                        tooltip.set(i, textToCheck);
                    }
                } else {
                    tooltip.set(i, textToCheck);
                }
                AutoTranslation.debug("Tooltip translated: {} -> {}", cleanLine, translated);
                continue;
            }
            TranslatorHelper.translate(cleanLine, false, translatedText -> AutoTranslation.debug("Tooltip translated (async): {} -> {}", cleanLine, translatedText));
        }
    }

    private List<String> wrapText(FontRenderer fontRenderer, String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String remaining = text;
        if (text == null || text.isEmpty()) {
            return lines;
        }
        while (remaining != null && !remaining.isEmpty()) {
            String line = fontRenderer.func_78269_a(remaining, maxWidth);
            if (line == null || line.isEmpty()) {
                if (remaining.isEmpty()) break;
                line = remaining.substring(0, Math.min(1, remaining.length()));
                lines.add(line);
                remaining = remaining.substring(line.length());
                break;
            }
            if (line.length() >= remaining.length()) {
                lines.add(line);
                break;
            }
            int lastSpace = line.lastIndexOf(32);
            if (lastSpace > 0 && lastSpace < line.length() - 1) {
                String beforeSpace = line.substring(0, lastSpace);
                String afterSpaceInLine = line.substring(lastSpace + 1);
                if (beforeSpace.isEmpty()) {
                    lines.add(line);
                    remaining = remaining.substring(line.length());
                    remaining = remaining.trim();
                    continue;
                }
                lines.add(beforeSpace);
                remaining = afterSpaceInLine + remaining.substring(line.length());
            } else {
                lines.add(line);
                remaining = remaining.substring(line.length());
            }
            remaining = remaining.trim();
        }
        if (lines.isEmpty()) {
            lines.add(text);
        }
        return lines;
    }

    private void propagateFormatting(List<String> lines) {
        if (lines == null || lines.size() < 2) {
            return;
        }
        String lastCode = null;
        for (int idx = 0; idx < lines.size(); ++idx) {
            String next;
            String line = lines.get(idx);
            for (int i = 0; i < line.length() - 1; ++i) {
                if (line.charAt(i) != '\u00a7') continue;
                lastCode = line.substring(i, Math.min(i + 2, line.length()));
            }
            if (lastCode == null || idx + 1 >= lines.size() || (next = lines.get(idx + 1)).startsWith("\u00a7") && next.length() > 1) continue;
            lines.set(idx + 1, lastCode + next);
        }
    }
}

