/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.resource;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.langyue.autotranslation.AutoTranslation;
import me.langyue.autotranslation.util.TranslatorHelper;

public class ResourceManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<String, String> NO_KEY_TRANSLATIONS = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> QMAW_TRANSLATIONS = new ConcurrentHashMap<String, String>();
    private static ScheduledExecutorService timer = null;
    public static final String NO_KEY_TRANS_STORE_NAMESPACE = "_at_store";

    public static void init() {
        if (timer == null) {
            timer = Executors.newSingleThreadScheduledExecutor(r -> {
                Thread thread = new Thread(r, "AutoTranslation-ResourceManager");
                thread.setDaemon(true);
                return thread;
            });
            timer.scheduleAtFixedRate(() -> {
                try {
                    ResourceManager.save();
                }
                catch (Exception e) {
                    AutoTranslation.LOGGER.error("Error auto-saving translations", (Throwable)e);
                }
            }, 5L, 5L, TimeUnit.MINUTES);
            AutoTranslation.LOGGER.info("ResourceManager initialized");
        }
        ResourceManager.load();
    }

    public static void noKeyTranslate(String original, String translation) {
        if (original != null && translation != null && !original.equals(translation)) {
            boolean originalIsEnglish = !ResourceManager.containsCyrillic(original);
            boolean translationIsRussian = ResourceManager.containsCyrillic(translation);
            if (originalIsEnglish && translationIsRussian) {
                if (!NO_KEY_TRANSLATIONS.containsKey(original)) {
                    NO_KEY_TRANSLATIONS.put(original, translation);
                }
            } else {
                AutoTranslation.debug("Skipping save in noKeyTranslate - original is not English or translation is not Russian: {} -> {}", original, translation);
            }
        }
    }

    private static boolean containsCyrillic(String text) {
        if (text == null || text.trim().isEmpty()) {
            return false;
        }
        int totalLetters = 0;
        int cyrillicCount = 0;
        for (char c : text.toCharArray()) {
            if (!Character.isLetter(c)) continue;
            ++totalLetters;
            if (!(c >= '\u0430' && c <= '\u044f' || c >= '\u0410' && c <= '\u042f' || c == '\u0451') && c != '\u0401') continue;
            ++cyrillicCount;
        }
        if (totalLetters == 0) {
            return false;
        }
        double cyrillicPercent = (double)cyrillicCount / (double)totalLetters;
        return cyrillicPercent > 0.2;
    }

    public static Map<String, String> getAllTranslations() {
        return new ConcurrentHashMap<String, String>(NO_KEY_TRANSLATIONS);
    }

    public static boolean hasQmawTranslation(String key) {
        return QMAW_TRANSLATIONS.containsKey(key);
    }

    public static String getQmawTranslation(String key) {
        return QMAW_TRANSLATIONS.get(key);
    }

    public static void setQmawTranslation(String key, String translation) {
        if (key != null && translation != null) {
            QMAW_TRANSLATIONS.put(key, translation);
        }
    }

    public static Map<String, String> getAllQmawTranslations() {
        return new ConcurrentHashMap<String, String>(QMAW_TRANSLATIONS);
    }

    public static boolean hasTranslation(String key) {
        return NO_KEY_TRANSLATIONS.containsKey(key);
    }

    public static String getTranslation(String key) {
        return NO_KEY_TRANSLATIONS.get(key);
    }

    public static void save() {
        if (NO_KEY_TRANSLATIONS.isEmpty() && QMAW_TRANSLATIONS.isEmpty()) {
            return;
        }
        try {
            Map.Entry<String, String> entry3;
            Object existing2;
            String language = AutoTranslation.getLanguage();
            File translationDir = new File(AutoTranslation.ROOT, "translations");
            if (!translationDir.exists()) {
                translationDir.mkdirs();
            }
            File translationFile = new File(translationDir, language + ".json");
            File qmawFile = new File(translationDir, "qmaw-" + language + ".json");
            JsonObject translations = new JsonObject();
            if (translationFile.exists()) {
                try {
                    FileReader reader = new FileReader(translationFile);
                    Iterator<Map.Entry<String, String>> iterator = null;
                    try {
                        existing2 = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        if (existing2 != null) {
                            for (Map.Entry entry2 : existing2.entrySet()) {
                                translations.add((String)entry2.getKey(), (JsonElement)entry2.getValue());
                            }
                        }
                    }
                    catch (Throwable existing2) {
                        iterator = existing2;
                        throw existing2;
                    }
                    finally {
                        if (reader != null) {
                            if (iterator != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable existing2) {
                                    ((Throwable)((Object)iterator)).addSuppressed(existing2);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    AutoTranslation.LOGGER.warn("Could not load existing translations", (Throwable)e);
                }
            }
            for (Map.Entry<String, String> entry3 : NO_KEY_TRANSLATIONS.entrySet()) {
                if (translations.has(entry3.getKey())) continue;
                translations.addProperty(entry3.getKey(), (String)entry3.getValue());
            }
            FileWriter writer = new FileWriter(translationFile);
            entry3 = null;
            try {
                GSON.toJson((JsonElement)translations, (Appendable)writer);
                AutoTranslation.LOGGER.info("Saved {} translations to {}", new Object[]{translations.entrySet().size(), translationFile.getName()});
            }
            catch (Throwable existing2) {
                entry3 = existing2;
                throw existing2;
            }
            finally {
                if (writer != null) {
                    if (entry3 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable existing2) {
                            ((Throwable)((Object)entry3)).addSuppressed(existing2);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
            if (!QMAW_TRANSLATIONS.isEmpty()) {
                Map.Entry<String, String> entry42;
                JsonObject qmawJson = new JsonObject();
                if (qmawFile.exists()) {
                    try {
                        FileReader reader = new FileReader(qmawFile);
                        existing2 = null;
                        try {
                            JsonObject existing3 = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                            if (existing3 != null) {
                                for (Map.Entry entry5 : existing3.entrySet()) {
                                    qmawJson.add((String)entry5.getKey(), (JsonElement)entry5.getValue());
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            existing2 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (reader != null) {
                                if (existing2 != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)existing2).addSuppressed(throwable);
                                    }
                                } else {
                                    reader.close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        AutoTranslation.LOGGER.warn("Could not load existing qmaw translations", (Throwable)e);
                    }
                }
                for (Map.Entry<String, String> entry42 : QMAW_TRANSLATIONS.entrySet()) {
                    if (qmawJson.has(entry42.getKey())) continue;
                    qmawJson.addProperty(entry42.getKey(), (String)entry42.getValue());
                }
                FileWriter writer2 = new FileWriter(qmawFile);
                entry42 = null;
                try {
                    GSON.toJson((JsonElement)qmawJson, (Appendable)writer2);
                    AutoTranslation.LOGGER.info("Saved {} QMAW translations to {}", new Object[]{qmawJson.entrySet().size(), qmawFile.getName()});
                }
                catch (Throwable throwable) {
                    entry42 = throwable;
                    throw throwable;
                }
                finally {
                    if (writer2 != null) {
                        if (entry42 != null) {
                            try {
                                writer2.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)((Object)entry42)).addSuppressed(throwable);
                            }
                        } else {
                            writer2.close();
                        }
                    }
                }
            }
            ResourceManager.loadResource(NO_KEY_TRANS_STORE_NAMESPACE);
            ResourceManager.loadResourceQmaw();
            int cacheUpdated = 0;
            for (Map.Entry<String, String> entry42 : NO_KEY_TRANSLATIONS.entrySet()) {
                TranslatorHelper.setCache(entry42.getKey(), entry42.getValue());
                ++cacheUpdated;
            }
            for (Map.Entry<String, String> entry42 : QMAW_TRANSLATIONS.entrySet()) {
                TranslatorHelper.setCache(entry42.getKey(), (String)entry42.getValue());
                ++cacheUpdated;
            }
            if (cacheUpdated > 0) {
                AutoTranslation.debug("Updated {} translations in CACHE directly", cacheUpdated);
            }
        }
        catch (Exception e) {
            AutoTranslation.LOGGER.error("Error saving translations", (Throwable)e);
        }
    }

    private static void load() {
        block36: {
            try {
                JsonObject translations2;
                Throwable throwable;
                FileReader reader;
                String language = AutoTranslation.getLanguage();
                File baseDir = new File(AutoTranslation.ROOT, "translations");
                File translationFile = new File(baseDir, language + ".json");
                File qmawFile = new File(baseDir, "qmaw-" + language + ".json");
                if (translationFile.exists()) {
                    try {
                        reader = new FileReader(translationFile);
                        throwable = null;
                        try {
                            translations2 = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                            if (translations2 != null) {
                                for (Map.Entry entry : translations2.entrySet()) {
                                    NO_KEY_TRANSLATIONS.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                }
                                AutoTranslation.LOGGER.info("Loaded {} translations from {}", new Object[]{translations2.entrySet().size(), translationFile.getName()});
                            }
                        }
                        catch (Throwable translations2) {
                            throwable = translations2;
                            throw translations2;
                        }
                        finally {
                            if (reader != null) {
                                if (throwable != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Throwable translations2) {
                                        throwable.addSuppressed(translations2);
                                    }
                                } else {
                                    reader.close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        AutoTranslation.LOGGER.warn("Could not load translations", (Throwable)e);
                    }
                }
                if (!qmawFile.exists()) break block36;
                try {
                    reader = new FileReader(qmawFile);
                    throwable = null;
                    try {
                        translations2 = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        if (translations2 != null) {
                            for (Map.Entry entry : translations2.entrySet()) {
                                QMAW_TRANSLATIONS.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                                TranslatorHelper.setCache((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                            }
                            AutoTranslation.LOGGER.info("Loaded {} QMAW translations from {}", new Object[]{translations2.entrySet().size(), qmawFile.getName()});
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    AutoTranslation.LOGGER.warn("Could not load QMAW translations", (Throwable)e);
                }
            }
            catch (Exception e) {
                AutoTranslation.LOGGER.error("Error loading translations", (Throwable)e);
            }
        }
    }

    public static void loadResource(String namespace) {
        File file = new File(new File(AutoTranslation.ROOT, namespace), AutoTranslation.getLanguage() + ".json");
        if (!file.exists()) {
            file = new File(new File(AutoTranslation.ROOT, "translations"), AutoTranslation.getLanguage() + ".json");
        }
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                if (jsonObject != null) {
                    for (Map.Entry entry : jsonObject.entrySet()) {
                        String key = (String)entry.getKey();
                        String translation = ((JsonElement)entry.getValue()).getAsString();
                        NO_KEY_TRANSLATIONS.put(key, translation);
                        TranslatorHelper.setCache(key, translation);
                    }
                    AutoTranslation.LOGGER.info("Resource loaded from {}: {} (updated {} entries)", new Object[]{namespace, file.getName(), jsonObject.entrySet().size()});
                }
            }
            catch (Exception e) {
                AutoTranslation.LOGGER.warn("Could not load resource from {}: {}", new Object[]{namespace, e.getMessage()});
            }
        } else {
            AutoTranslation.LOGGER.warn("Resource file not found: {}", new Object[]{file.getAbsolutePath()});
        }
    }

    public static void loadResourceQmaw() {
        File file = new File(new File(AutoTranslation.ROOT, "translations"), "qmaw-" + AutoTranslation.getLanguage() + ".json");
        if (!file.exists()) {
            return;
        }
        try (FileReader reader = new FileReader(file);){
            JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            if (jsonObject != null) {
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String key = (String)entry.getKey();
                    String translation = ((JsonElement)entry.getValue()).getAsString();
                    QMAW_TRANSLATIONS.put(key, translation);
                    TranslatorHelper.setCache(key, translation);
                }
                AutoTranslation.LOGGER.info("Resource QMAW loaded: {} ({} entries)", new Object[]{file.getName(), jsonObject.entrySet().size()});
            }
        }
        catch (Exception e) {
            AutoTranslation.LOGGER.warn("Could not load QMAW resource: {}", new Object[]{e.getMessage()});
        }
    }

    public static void loadResource(String ... namespaces) {
        if (namespaces == null || namespaces.length == 0) {
            ResourceManager.loadResource(NO_KEY_TRANS_STORE_NAMESPACE);
        } else {
            for (String ns : namespaces) {
                ResourceManager.loadResource(ns);
            }
        }
    }

    public static void reload() {
        NO_KEY_TRANSLATIONS.clear();
        ResourceManager.load();
        TranslatorHelper.clearCache();
        TranslatorHelper.init();
        AutoTranslation.LOGGER.info("Translations reloaded");
    }

    public static void shutdown() {
        if (timer != null) {
            ResourceManager.save();
            timer.shutdown();
            try {
                if (!timer.awaitTermination(5L, TimeUnit.SECONDS)) {
                    timer.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                timer.shutdownNow();
            }
        }
    }
}

