/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.translate;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import me.langyue.autotranslation.AutoTranslation;
import me.langyue.autotranslation.resource.ResourceManager;
import me.langyue.autotranslation.translate.ITranslator;
import me.langyue.autotranslation.translate.TranslatorManager;
import me.langyue.autotranslation.util.TranslatorHelper;

public class TranslateThreadPool {
    private static final int CORE_POOL_SIZE = 2;
    private static final int MAX_POOL_SIZE = 4;
    private static final long KEEP_ALIVE_TIME = 60L;
    private static ExecutorService executor;
    private static final ConcurrentHashMap<String, Boolean> processingKeys;
    private static volatile boolean stopped;

    public static void init() {
        stopped = false;
        executor = new ThreadPoolExecutor(2, 4, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), r -> {
            Thread thread = new Thread(r, "AutoTranslation-Worker");
            thread.setDaemon(true);
            return thread;
        });
        AutoTranslation.LOGGER.info("Translation thread pool initialized");
    }

    public static void offer(String key, String text, Consumer<String> callback) {
        if (stopped || executor == null || executor.isShutdown()) {
            TranslateThreadPool.init();
        }
        if (processingKeys.containsKey(key)) {
            return;
        }
        processingKeys.put(key, true);
        executor.submit(() -> {
            try {
                if (TranslatorHelper.containsCyrillic(text)) {
                    TranslatorHelper.logCyrSkip(text);
                    return;
                }
                ITranslator translator = TranslatorManager.getTranslator();
                if (translator == null || !translator.ready()) {
                    AutoTranslation.LOGGER.warn("Translator not ready");
                    return;
                }
                String translation = translator.translate(text, AutoTranslation.getLanguage(), "en");
                if (translation != null && !translation.isEmpty()) {
                    boolean originalIsEnglish = !TranslatorHelper.containsCyrillic(text);
                    boolean translationIsRussian = TranslatorHelper.containsCyrillic(translation);
                    if (originalIsEnglish && translationIsRussian) {
                        TranslatorHelper.setCache(key, translation);
                        if (key.equals(text)) {
                            ResourceManager.noKeyTranslate(text, translation);
                        }
                        AutoTranslation.debug("Translated: {} -> {}", text, translation);
                    } else {
                        AutoTranslation.debug("Skipping save - original is not English or translation is not Russian: {} -> {}", text, translation);
                    }
                    if (callback != null) {
                        callback.accept(translation);
                    }
                } else {
                    AutoTranslation.LOGGER.warn("Translation failed for: {}", new Object[]{text});
                }
            }
            catch (Exception e) {
                AutoTranslation.LOGGER.error("Error translating text: " + text, (Throwable)e);
            }
            finally {
                processingKeys.remove(key);
            }
        });
    }

    public static void shutdown() {
        stopped = true;
        if (executor != null) {
            executor.shutdown();
            try {
                if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                    executor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
            }
        }
    }

    static {
        processingKeys = new ConcurrentHashMap();
        stopped = false;
    }
}

