/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.translate;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import me.langyue.autotranslation.AutoTranslation;
import me.langyue.autotranslation.translate.ITranslator;
import me.langyue.autotranslation.translate.TranslateThreadPool;
import me.langyue.autotranslation.translate.google.Google;
import org.apache.commons.lang3.StringUtils;

public class TranslatorManager {
    public static final String DEFAULT_TRANSLATOR = "Google";
    private static final Map<String, Supplier<ITranslator>> TRANSLATOR_MAP = new LinkedHashMap<String, Supplier<ITranslator>>();
    private static final Map<String, ITranslator> TRANSLATOR_INSTANCES = new HashMap<String, ITranslator>();

    public static void init() {
        TranslatorManager.setTranslator(AutoTranslation.CONFIG.translator);
        TranslateThreadPool.init();
    }

    public static void setTranslator(String name) {
        if (!TRANSLATOR_INSTANCES.containsKey(name)) {
            Supplier<ITranslator> supplier = TRANSLATOR_MAP.get(name);
            if (supplier == null) {
                AutoTranslation.LOGGER.error("Unknown translator: {}", new Object[]{name});
                TranslatorManager.setTranslator(DEFAULT_TRANSLATOR);
            } else {
                ITranslator translator = supplier.get();
                translator.init();
                TRANSLATOR_INSTANCES.put(name, translator);
                AutoTranslation.LOGGER.info("Translator set to: {}", new Object[]{name});
            }
        }
    }

    public static void registerTranslator(String name, Supplier<ITranslator> getInstance) {
        TRANSLATOR_MAP.put(name, getInstance);
        AutoTranslation.LOGGER.info("Registered translator: {}", new Object[]{name});
    }

    public static ITranslator getTranslator() {
        return TranslatorManager.getTranslator(AutoTranslation.CONFIG.translator);
    }

    public static ITranslator getTranslator(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        return TRANSLATOR_INSTANCES.get(name);
    }

    static {
        TRANSLATOR_MAP.put(DEFAULT_TRANSLATOR, Google::getInstance);
    }
}

