/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.translate.google;

import com.google.gson.JsonArray;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.langyue.autotranslation.AutoTranslation;
import me.langyue.autotranslation.translate.ITranslator;
import me.langyue.autotranslation.translate.google.HttpClientUtil;

public class Google
implements ITranslator {
    private static final Google instance = new Google();
    private static final ScheduledExecutorService timer = Executors.newScheduledThreadPool(5);
    private static final String DEFAULT_DOMAIN = "translate.google.com";
    private static final Object syncLock = new Object();
    private static String client = "gtx";
    private boolean ready = false;
    private String domain = "translate.google.com";
    private DNS dns = null;

    private Google() {
    }

    public static Google getInstance() {
        return instance;
    }

    @Override
    public void init() {
        AutoTranslation.LOGGER.info("Initializing Google Translator");
        timer.scheduleAtFixedRate(() -> {
            if (this.dns != null) {
                return;
            }
            if (!this.pingDomain(AutoTranslation.CONFIG.google.domain) && !this.pingDomain(DEFAULT_DOMAIN)) {
                this.chooseDNS();
            }
        }, 0L, 10L, TimeUnit.MINUTES);
    }

    private void chooseDNS() {
        this.dns = null;
        AutoTranslation.CONFIG.google.dns.forEach(ip -> timer.schedule(() -> {
            int latency = this.ping((String)ip);
            if (latency > -1) {
                this.ready = true;
                HttpClientUtil.reset();
                Object object = syncLock;
                synchronized (object) {
                    if (this.dns == null || this.dns.latency > latency) {
                        this.dns = new DNS((String)ip, latency);
                        AutoTranslation.LOGGER.info("Selected DNS: {} with latency {}ms", new Object[]{ip, latency});
                    }
                }
            }
        }, 10L, TimeUnit.MILLISECONDS));
    }

    private boolean pingDomain(String domain) {
        long time = System.currentTimeMillis();
        int status = HttpClientUtil.status("https://" + domain + "?t=" + time, this.dns == null ? null : this.dns.ip);
        if (status < 400) {
            this.ready = true;
            this.domain = domain;
            AutoTranslation.LOGGER.info("Google Translate available at {}: {}ms", new Object[]{domain, System.currentTimeMillis() - time});
            return true;
        }
        if (status < 999) {
            AutoTranslation.LOGGER.warn("Google Translate returned status {}", new Object[]{status});
            this.ready = true;
            this.domain = domain;
            return true;
        }
        AutoTranslation.LOGGER.warn("Cannot connect to {}", new Object[]{domain});
        return false;
    }

    private int ping(String address) {
        try {
            long time = System.currentTimeMillis();
            InetAddress inet = InetAddress.getByName(address);
            boolean reachable = inet.isReachable(3000);
            if (reachable) {
                int latency = (int)(System.currentTimeMillis() - time);
                AutoTranslation.LOGGER.info("Ping {}: {}ms", new Object[]{address, latency});
                this.ready = true;
                return latency;
            }
            AutoTranslation.LOGGER.warn("Ping {}: unreachable", new Object[]{address});
        }
        catch (Exception e) {
            AutoTranslation.LOGGER.warn("Ping {}: failed", new Object[]{address});
        }
        return -1;
    }

    @Override
    public boolean ready() {
        return this.ready;
    }

    @Override
    public int maxLength() {
        return 5000;
    }

    @Override
    public String translate(String text, String targetLang, String sourceLang) {
        JsonArray jsonArray = null;
        try {
            String tl = targetLang.contains("_") ? targetLang.split("_")[0] : targetLang;
            String sl = sourceLang.contains("_") ? sourceLang.split("_")[0] : sourceLang;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("client", client);
            params.put("sl", sl);
            params.put("tl", tl);
            params.put("dt", "t");
            params.put("ie", "UTF-8");
            params.put("oe", "UTF-8");
            params.put("q", text);
            jsonArray = HttpClientUtil.get("https://" + this.domain + "/translate_a/single", this.dns == null ? null : this.dns.ip, params, JsonArray.class);
        }
        catch (Throwable e) {
            AutoTranslation.LOGGER.error("Google Translate exception", e);
            return null;
        }
        if (jsonArray == null) {
            return null;
        }
        try {
            JsonArray elements = jsonArray.getAsJsonArray().get(0).getAsJsonArray();
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < elements.size(); ++i) {
                JsonArray element = elements.get(i).getAsJsonArray();
                if (element.size() <= 0 || element.get(0).isJsonNull()) continue;
                String translated = element.get(0).getAsString();
                result.append(translated.replaceAll("\u200b", "").replaceAll("\\\\[\"'']", "`"));
            }
            return result.toString();
        }
        catch (Throwable e) {
            AutoTranslation.LOGGER.error("Failed to parse Google Translate response", e);
            return null;
        }
    }

    public static void shutdown() {
        try {
            timer.shutdownNow();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class DNS {
        final String ip;
        final int latency;

        DNS(String ip, int latency) {
            this.ip = ip;
            this.latency = latency;
        }
    }
}

