/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.translate.google;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import me.langyue.autotranslation.AutoTranslation;

public class HttpClientUtil {
    private static final Gson GSON = new Gson();
    private static Proxy proxy = null;

    public static void reset() {
        proxy = null;
    }

    public static int status(String urlString, String dnsIp) {
        try {
            HttpURLConnection conn;
            URL url = new URL(urlString);
            if (dnsIp != null) {
                Proxy p = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(dnsIp, 80));
                conn = (HttpURLConnection)url.openConnection(p);
            } else {
                conn = (HttpURLConnection)url.openConnection();
            }
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            conn.setReadTimeout(5000);
            conn.setRequestProperty("User-Agent", "Mozilla/5.0");
            int responseCode = conn.getResponseCode();
            conn.disconnect();
            return responseCode;
        }
        catch (Exception e) {
            return 999;
        }
    }

    public static <T> T get(String urlString, String dnsIp, Map<String, String> params, Class<T> clazz) {
        try {
            String line;
            StringBuilder queryString = new StringBuilder();
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (queryString.length() > 0) {
                    queryString.append("&");
                }
                queryString.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                queryString.append("=");
                queryString.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
            String fullUrl = urlString + "?" + queryString.toString();
            URL url = new URL(fullUrl);
            if (dnsIp != null && proxy == null) {
                proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(dnsIp, 80));
            }
            HttpURLConnection conn = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(10000);
            conn.setReadTimeout(10000);
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36");
            conn.setRequestProperty("Accept", "*/*");
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                AutoTranslation.LOGGER.warn("HTTP request failed with code: {}", new Object[]{responseCode});
                conn.disconnect();
                return null;
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            reader.close();
            conn.disconnect();
            String jsonResponse = response.toString();
            AutoTranslation.debug("Google Translate response: {}", jsonResponse);
            return (T)GSON.fromJson(jsonResponse, clazz);
        }
        catch (Exception e) {
            AutoTranslation.LOGGER.error("HTTP request error", (Throwable)e);
            return null;
        }
    }
}

