/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.util;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cpw.mods.fml.common.Loader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import me.langyue.autotranslation.AutoTranslation;
import me.langyue.autotranslation.config.TranslationSettings;
import me.langyue.autotranslation.resource.ResourceManager;
import me.langyue.autotranslation.translate.ITranslator;
import me.langyue.autotranslation.translate.TranslatorManager;
import me.langyue.autotranslation.util.TranslatorHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.LanguageManager;

public class QmawTranslator {
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "AutoTranslation-QMAW");
        t.setDaemon(true);
        return t;
    });
    private static final JsonParser PARSER = new JsonParser();
    private static final Pattern LINK_PATTERN = Pattern.compile("\\[\\[([^\\]|]+)(?:\\|([^\\]]+))?\\]\\]");
    private static final AtomicBoolean translating = new AtomicBoolean(false);
    public static volatile boolean running = false;
    public static volatile int totalPages = 0;
    public static volatile int translatedPages = 0;
    public static volatile String currentEntry = "";
    public static volatile long lastStartMillis = 0L;
    public static volatile long lastEndMillis = 0L;

    public static void initAsync() {
        AutoTranslation.AT_LOG.info("QMAW: initAsync submit");
        QmawTranslator.scheduleBatch("init");
    }

    public static void rerunAsync() {
        AutoTranslation.AT_LOG.info("QMAW: rerunAsync submit");
        QmawTranslator.scheduleBatch("manual");
    }

    private static void translateAllWithTag(String tag) {
        if (!translating.compareAndSet(false, true)) {
            AutoTranslation.AT_LOG.info("QMAW: translateAll skipped ({}) - already running", new Object[]{tag});
            return;
        }
        AutoTranslation.AT_LOG.info("QMAW: translateAll start ({})", new Object[]{tag});
        try {
            QmawTranslator.translateAll();
            translating.set(false);
        }
        catch (Throwable throwable) {
            translating.set(false);
            AutoTranslation.AT_LOG.info("QMAW: translateAll end ({})", new Object[]{tag});
            throw throwable;
        }
        AutoTranslation.AT_LOG.info("QMAW: translateAll end ({})", new Object[]{tag});
    }

    private static void scheduleBatch(String tagPrefix) {
        int[] delays;
        int[] nArray = delays = new int[]{0, 3};
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int d;
            int delay = d = nArray[i];
            AutoTranslation.AT_LOG.info("QMAW: schedule translateAll ({}-{}s) in {}s", new Object[]{tagPrefix, delay, delay});
            executor.schedule(() -> QmawTranslator.translateAllWithTag(tagPrefix + "-" + delay + "s"), (long)delay, TimeUnit.SECONDS);
        }
    }

    public static void forceLangIfPossible(String lang) {
        try {
            Class<?> loaderClass = Class.forName("com.hbm.qmaw.QMAWLoader");
            QmawTranslator.forceLang(loaderClass, lang);
        }
        catch (Exception e) {
            AutoTranslation.AT_LOG.warn("QMAW: forceLangIfPossible failed: {}", new Object[]{e.toString()});
        }
    }

    private static void forceLang(Class<?> loaderClass, String targetLang) {
        try {
            String[] fieldNames;
            boolean set = false;
            for (String fName : fieldNames = new String[]{"lang", "currentLang", "language", "locale", "currentLocale"}) {
                try {
                    Field f = loaderClass.getDeclaredField(fName);
                    f.setAccessible(true);
                    Object oldValue = f.get(null);
                    f.set(null, targetLang);
                    AutoTranslation.AT_LOG.info("QMAW: lang field {} changed from {} to {}", new Object[]{fName, oldValue, targetLang});
                    set = true;
                }
                catch (NoSuchFieldException f) {
                    // empty catch block
                }
            }
            if (!set) {
                String[] methodNames;
                for (String mName : methodNames = new String[]{"setLang", "setLanguage", "setLocale", "changeLang"}) {
                    try {
                        Method m = loaderClass.getDeclaredMethod(mName, String.class);
                        m.setAccessible(true);
                        m.invoke(null, targetLang);
                        AutoTranslation.AT_LOG.info("QMAW: called {}({})", new Object[]{mName, targetLang});
                        set = true;
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            if (!set) {
                AutoTranslation.AT_LOG.warn("QMAW: lang field/method not found, could not set {}", new Object[]{targetLang});
                AutoTranslation.AT_LOG.info("QMAW: will rely on en_US overwrite strategy");
            }
        }
        catch (Exception e) {
            AutoTranslation.AT_LOG.warn("QMAW: cannot set lang to {}: {}", new Object[]{targetLang, e.toString()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void translateAll() {
        try {
            int missingBeforeTranslate;
            if (!TranslationSettings.enableManuals) {
                AutoTranslation.AT_LOG.info("QMAW: manuals translation disabled by settings");
                return;
            }
            LanguageManager langManager = Minecraft.func_71410_x().func_135016_M();
            String targetLang = langManager.func_135041_c().func_135034_a();
            String gameSettingsLang = Minecraft.func_71410_x().field_71474_y.field_74363_ab;
            AutoTranslation.AT_LOG.info("QMAW: target lang from LanguageManager: {}, from gameSettings: {}", new Object[]{targetLang, gameSettingsLang});
            if ("en_US".equalsIgnoreCase(targetLang) || "en_us".equalsIgnoreCase(targetLang)) {
                AutoTranslation.AT_LOG.info("QMAW: skip translation for en_US");
                return;
            }
            if (!QmawTranslator.waitTranslatorReady()) {
                AutoTranslation.AT_LOG.warn("QMAW: translator not ready, skip run");
                return;
            }
            Map<String, JsonManual> manualData = QmawTranslator.loadManualFromHbmJar();
            if (manualData.isEmpty()) {
                AutoTranslation.AT_LOG.warn("QMAW: no manual data found in HBM jar");
            }
            Class<?> loaderClass = Class.forName("com.hbm.qmaw.QMAWLoader");
            QmawTranslator.ensureQmawLoaded(loaderClass);
            QmawTranslator.forceLang(loaderClass, targetLang);
            Field qmawField = loaderClass.getDeclaredField("qmaw");
            qmawField.setAccessible(true);
            Object qmawObj = qmawField.get(null);
            if (!(qmawObj instanceof Map)) {
                AutoTranslation.AT_LOG.warn("QMAW: qmaw field is not a Map");
                return;
            }
            Map qmawMap = (Map)qmawObj;
            if (qmawMap.isEmpty()) {
                AutoTranslation.AT_LOG.warn("QMAW: map is empty after init, skip");
                return;
            }
            Class<?> qmawEntryClass = Class.forName("com.hbm.qmaw.QuickManualAndWiki");
            Field nameField = qmawEntryClass.getDeclaredField("name");
            Field titleField = qmawEntryClass.getDeclaredField("title");
            Field contentsField = qmawEntryClass.getDeclaredField("contents");
            nameField.setAccessible(true);
            titleField.setAccessible(true);
            contentsField.setAccessible(true);
            int translated = 0;
            Object[] snapshot = qmawMap.values().toArray();
            totalPages = snapshot.length;
            ResourceManager.loadResourceQmaw();
            int appliedFromCache = QmawTranslator.applyCachedTranslationsToQmaw(qmawMap, qmawEntryClass, nameField, titleField, contentsField, targetLang);
            if (appliedFromCache > 0) {
                AutoTranslation.AT_LOG.info("QMAW: applied {} cached translations from ResourceManager", new Object[]{appliedFromCache});
            }
            if ((missingBeforeTranslate = QmawTranslator.countMissingManualTranslations(snapshot, titleField, contentsField, targetLang)) == 0) {
                translatedPages = translated = totalPages;
                lastEndMillis = System.currentTimeMillis();
                currentEntry = "";
                running = false;
                AutoTranslation.AT_LOG.info("QMAW: cache already covers all manuals for {}", new Object[]{targetLang});
                QmawTranslator.refreshOpenGuiQMAW();
                return;
            }
            translatedPages = translated = Math.max(0, totalPages - missingBeforeTranslate);
            running = true;
            currentEntry = "";
            lastStartMillis = System.currentTimeMillis();
            lastEndMillis = 0L;
            for (Object entry : snapshot) {
                String translatedBody;
                boolean alreadyTranslated;
                String altKey;
                String name;
                if (entry == null) continue;
                currentEntry = name = (String)nameField.get(entry);
                HashMap<String, String> titles = (HashMap<String, String>)titleField.get(entry);
                HashMap<String, String> contents = (HashMap<String, String>)contentsField.get(entry);
                if (contents == null) {
                    contents = new HashMap<String, String>();
                    contentsField.set(entry, contents);
                    AutoTranslation.AT_LOG.warn("QMAW: entry {} had null contents, created new map", new Object[]{name});
                }
                if (titles == null) {
                    titles = new HashMap<String, String>();
                    titleField.set(entry, titles);
                    AutoTranslation.AT_LOG.warn("QMAW: entry {} had null titles, created new map", new Object[]{name});
                }
                if (contents == null || contents.isEmpty()) {
                    AutoTranslation.AT_LOG.warn("QMAW: entry {} has null/empty contents", new Object[]{name});
                    continue;
                }
                String en = (String)contents.get("en_US");
                if (en == null && manualData.containsKey(name) && (en = manualData.get((Object)name).content) != null) {
                    contents.put("en_US", en);
                }
                if ((en == null || en.trim().isEmpty()) && manualData.containsKey(altKey = "machine/" + name) && (en = manualData.get((Object)altKey).content) != null) {
                    contents.put("en_US", en);
                    AutoTranslation.AT_LOG.info("QMAW: hydrated en_US from alt key {} for {}", new Object[]{altKey, name});
                }
                if (en == null || en.trim().isEmpty()) continue;
                boolean bl = alreadyTranslated = contents.containsKey(targetLang) || contents.containsKey(targetLang.toLowerCase()) || contents.containsKey(targetLang.replace("_", "-"));
                if (alreadyTranslated) {
                    AutoTranslation.AT_LOG.debug("QMAW [{}]: already has translation for {}", new Object[]{name, targetLang});
                    continue;
                }
                String cacheBodyKey = "qmaw:body:" + name;
                String cacheTitleKey = "qmaw:title:" + name;
                String cachedBody = ResourceManager.getQmawTranslation(cacheBodyKey);
                LinkProcess lp = QmawTranslator.extractLinks(en, targetLang);
                String bodyForTranslate = lp.textWithPlaceholders;
                if (!lp.links.isEmpty()) {
                    AutoTranslation.AT_LOG.info("QMAW [{}]: extracted {} links", new Object[]{name, lp.links.size()});
                    for (LinkEntry le : lp.links) {
                        AutoTranslation.AT_LOG.info("  Link: {} -> [[{}|{}]]", new Object[]{le.placeholder, le.target, le.translatedLabel});
                    }
                }
                if ((translatedBody = cachedBody) == null || translatedBody.isEmpty()) {
                    translatedBody = TranslatorManager.getTranslator().translate(bodyForTranslate, targetLang, "en");
                }
                if (translatedBody != null && !translatedBody.isEmpty()) {
                    try {
                        AutoTranslation.AT_LOG.info("QMAW [{}]: translated (before restore): {}", new Object[]{name, translatedBody.length() > 100 ? translatedBody.substring(0, 100) + "..." : translatedBody});
                        translatedBody = QmawTranslator.restoreLinks(translatedBody, lp.links);
                        if (!lp.links.isEmpty()) {
                            AutoTranslation.AT_LOG.info("QMAW [{}]: translated (after restore): {}", new Object[]{name, translatedBody.length() > 100 ? translatedBody.substring(0, 100) + "..." : translatedBody});
                        }
                        boolean hasLinksBeforePut = translatedBody.contains("[[");
                        AutoTranslation.AT_LOG.info("QMAW [{}]: translatedBody has links before put: {} (length: {})", new Object[]{name, hasLinksBeforePut, translatedBody.length()});
                        contents.put(targetLang, translatedBody);
                        contents.put(targetLang.toLowerCase(), translatedBody);
                        contents.put(targetLang.replace("_", "-"), translatedBody);
                        String verifyTranslated = (String)contents.get(targetLang);
                        if (verifyTranslated == null) {
                            AutoTranslation.AT_LOG.warn("QMAW [{}]: {} is NULL after put!", new Object[]{name, targetLang});
                        } else if (verifyTranslated.contains("[[")) {
                            AutoTranslation.AT_LOG.info("QMAW [{}]: {} contains links \u2713 (found {} brackets)", new Object[]{name, targetLang, QmawTranslator.countOccurrences(verifyTranslated, "[[")});
                            if (!lp.links.isEmpty() && "Boiler".equals(name)) {
                                AutoTranslation.AT_LOG.info("QMAW [{}]: FULL TRANSLATED TEXT:\n{}", new Object[]{name, verifyTranslated});
                            }
                        } else if (!lp.links.isEmpty()) {
                            AutoTranslation.AT_LOG.warn("QMAW [{}]: {} does NOT contain [[...]] but had {} links! First 100 chars: {}", new Object[]{name, targetLang, lp.links.size(), verifyTranslated.length() > 100 ? verifyTranslated.substring(0, 100) : verifyTranslated});
                        }
                        TranslatorHelper.setCache(en, translatedBody);
                        ResourceManager.setQmawTranslation(cacheBodyKey, translatedBody);
                        translatedPages = ++translated;
                        AutoTranslation.AT_LOG.info("QMAW: body translated for {}", new Object[]{name});
                    }
                    catch (Exception putEx) {
                        AutoTranslation.AT_LOG.error("QMAW: failed to put translated body for {}", new Object[]{name, putEx});
                    }
                }
                if (titles == null) continue;
                boolean hasTitleTranslation = titles.containsKey(targetLang) || titles.containsKey(targetLang.toLowerCase()) || titles.containsKey(targetLang.replace("_", "-"));
                String cachedTitle = ResourceManager.getQmawTranslation(cacheTitleKey);
                if (!hasTitleTranslation && cachedTitle == null) {
                    String translatedTitle;
                    String titleEn = (String)titles.get("en_US");
                    if (titleEn == null && manualData.containsKey(name) && (titleEn = manualData.get((Object)name).title) != null) {
                        titles.put("en_US", titleEn);
                    }
                    if (titleEn == null || titleEn.trim().isEmpty() || (translatedTitle = TranslatorManager.getTranslator().translate(titleEn, targetLang, "en")) == null || translatedTitle.isEmpty()) continue;
                    try {
                        titles.put(targetLang, translatedTitle);
                        titles.put(targetLang.toLowerCase(), translatedTitle);
                        titles.put(targetLang.replace("_", "-"), translatedTitle);
                        TranslatorHelper.setCache(titleEn, translatedTitle);
                        ResourceManager.setQmawTranslation(cacheTitleKey, translatedTitle);
                        AutoTranslation.AT_LOG.info("QMAW: title translated for {}", new Object[]{name});
                    }
                    catch (Exception putEx) {
                        AutoTranslation.AT_LOG.error("QMAW: failed to put translated title for {}", new Object[]{name, putEx});
                    }
                    continue;
                }
                if (cachedTitle == null) continue;
                titles.put(targetLang, cachedTitle);
                titles.put(targetLang.toLowerCase(), cachedTitle);
                titles.put(targetLang.replace("_", "-"), cachedTitle);
                TranslatorHelper.setCache((String)titles.get("en_US"), cachedTitle);
                translatedPages = ++translated;
                AutoTranslation.AT_LOG.info("QMAW: title loaded from cache for {}", new Object[]{name});
            }
            AutoTranslation.AT_LOG.info("QMAW translated pages: {}", new Object[]{translated});
            if (translated > 0) {
                AutoTranslation.AT_LOG.info("QMAW: trying to refresh GUI if open...");
                try {
                    QmawTranslator.refreshOpenGuiQMAW();
                }
                catch (Exception e) {
                    AutoTranslation.AT_LOG.warn("QMAW: GUI refresh failed: {}", new Object[]{e.getMessage()});
                }
            }
        }
        catch (Throwable t) {
            AutoTranslation.AT_LOG.error("QMAW translation failed", t);
        }
        finally {
            running = false;
            lastEndMillis = System.currentTimeMillis();
            currentEntry = "";
        }
    }

    private static void refreshOpenGuiQMAW() {
        try {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc == null || mc.field_71462_r == null) {
                return;
            }
            GuiScreen currentGui = mc.field_71462_r;
            String guiClassName = currentGui.getClass().getName();
            if (!guiClassName.contains("com.hbm.qmaw.GuiQMAW")) {
                return;
            }
            AutoTranslation.AT_LOG.info("QMAW: detected open GuiQMAW, trying to refresh...");
            Class<?> guiClass = currentGui.getClass();
            Field qmawIDField = guiClass.getDeclaredField("qmawID");
            qmawIDField.setAccessible(true);
            String qmawID = (String)qmawIDField.get(currentGui);
            if (qmawID == null) {
                AutoTranslation.AT_LOG.warn("QMAW: qmawID is null, cannot refresh");
                return;
            }
            Field backField = guiClass.getDeclaredField("back");
            Field forwardField = guiClass.getDeclaredField("forward");
            backField.setAccessible(true);
            forwardField.setAccessible(true);
            List back = (List)backField.get(currentGui);
            List forward = (List)forwardField.get(currentGui);
            Class<?> loaderClass = Class.forName("com.hbm.qmaw.QMAWLoader");
            Field qmawMapField = loaderClass.getDeclaredField("qmaw");
            qmawMapField.setAccessible(true);
            HashMap qmawMap = (HashMap)qmawMapField.get(null);
            Object qmawData = qmawMap.get(qmawID);
            if (qmawData == null) {
                Class<?> qmawEntryClass = Class.forName("com.hbm.qmaw.QuickManualAndWiki");
                Field nameField = qmawEntryClass.getDeclaredField("name");
                nameField.setAccessible(true);
                for (Object entry : qmawMap.values()) {
                    String entryName;
                    if (entry == null || !qmawID.equals(entryName = (String)nameField.get(entry))) continue;
                    qmawData = entry;
                    AutoTranslation.AT_LOG.info("QMAW: found data by matching name field: {}", new Object[]{entryName});
                    break;
                }
            }
            if (qmawData == null) {
                AutoTranslation.AT_LOG.warn("QMAW: no data found for ID {} (tried both map key and name field)", new Object[]{qmawID});
                return;
            }
            Constructor<?> constructor = guiClass.getConstructor(qmawData.getClass());
            Object newGui = constructor.newInstance(qmawData);
            backField.set(newGui, new ArrayList(back));
            forwardField.set(newGui, new ArrayList(forward));
            mc.func_147108_a((GuiScreen)newGui);
            AutoTranslation.AT_LOG.info("QMAW: GUI refreshed successfully!");
        }
        catch (Exception e) {
            AutoTranslation.AT_LOG.debug("QMAW: GUI refresh failed (this is normal if GUI was not open): {}", new Object[]{e.toString()});
        }
    }

    private static boolean ensureQmawLoaded(Class<?> loaderClass) {
        try {
            Field qmawField = loaderClass.getDeclaredField("qmaw");
            qmawField.setAccessible(true);
            Object obj = qmawField.get(null);
            if (obj instanceof Map && !((Map)obj).isEmpty()) {
                return true;
            }
            Method init = loaderClass.getDeclaredMethod("init", new Class[0]);
            init.setAccessible(true);
            init.invoke(null, new Object[0]);
            return true;
        }
        catch (Exception e) {
            AutoTranslation.AT_LOG.warn("QMAW: cannot invoke init(): {}", new Object[]{e.getMessage()});
            return false;
        }
    }

    private static boolean waitTranslatorReady() {
        for (int i = 0; i < 10; ++i) {
            ITranslator tr = TranslatorManager.getTranslator();
            if (tr != null && tr.ready()) {
                return true;
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    private static Map<String, JsonManual> loadManualFromHbmJar() {
        HashMap<String, JsonManual> map = new HashMap<String, JsonManual>();
        try {
            Object modContainer = Loader.instance().getIndexedModList().get("hbm");
            if (modContainer == null) {
                return map;
            }
            Method getSource = modContainer.getClass().getMethod("getSource", new Class[0]);
            File source = (File)getSource.invoke(modContainer, new Object[0]);
            if (source == null || !source.exists()) {
                return map;
            }
            ZipFile zip = new ZipFile(source);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                String content;
                ZipEntry e = entries.nextElement();
                String name = e.getName();
                if (!name.startsWith("assets/hbm/manual/") || !name.endsWith(".json")) continue;
                InputStreamReader reader = new InputStreamReader(zip.getInputStream(e), StandardCharsets.UTF_8);
                JsonObject obj = (JsonObject)PARSER.parse((Reader)reader);
                String manName = name.replace("assets/hbm/manual/", "");
                String title = obj.has("title") ? obj.getAsJsonObject("title").get("en_US").getAsString() : null;
                String string = content = obj.has("content") ? obj.getAsJsonObject("content").get("en_US").getAsString() : null;
                if (content != null) {
                    map.put(manName.replace(".json", ""), new JsonManual(title, content));
                }
                reader.close();
            }
            zip.close();
        }
        catch (Exception e) {
            AutoTranslation.AT_LOG.warn("QMAW: failed to read manual from jar: {}", new Object[]{e.getMessage()});
        }
        return map;
    }

    private static LinkProcess extractLinks(String text, String targetLang) {
        Matcher m = LINK_PATTERN.matcher(text);
        StringBuffer sb = new StringBuffer();
        ArrayList<LinkEntry> links = new ArrayList<LinkEntry>();
        int idx = 0;
        while (m.find()) {
            String target = m.group(1);
            String label = m.group(2) != null ? m.group(2) : target;
            String placeholder = "ZZZLINK" + idx++ + "ZZZ";
            String translatedLabel = label;
            try {
                String t = TranslatorManager.getTranslator().translate(label, targetLang, "en");
                if (t != null && !t.isEmpty()) {
                    translatedLabel = t;
                }
            }
            catch (Exception t) {
                // empty catch block
            }
            links.add(new LinkEntry(placeholder, label, translatedLabel));
            String safePlaceholder = placeholder.replace("\\", "\\\\").replace("$", "\\$");
            m.appendReplacement(sb, safePlaceholder);
        }
        m.appendTail(sb);
        return new LinkProcess(sb.toString(), links);
    }

    private static String restoreLinks(String translated, List<LinkEntry> links) {
        if (links == null || links.isEmpty() || translated == null) {
            return translated;
        }
        String result = translated;
        for (LinkEntry le : links) {
            String linkText = "[[" + le.translatedLabel + "|" + le.target + "]]";
            if (!result.contains(le.placeholder)) {
                AutoTranslation.AT_LOG.warn("QMAW restoreLinks: placeholder {} NOT FOUND in translated text!", new Object[]{le.placeholder});
                String lowerResult = result.toLowerCase();
                String lowerPlaceholder = le.placeholder.toLowerCase();
                int pos = lowerResult.indexOf(lowerPlaceholder);
                if (pos >= 0) {
                    String actualPlaceholder = result.substring(pos, pos + le.placeholder.length());
                    result = result.replace(actualPlaceholder, linkText);
                    AutoTranslation.AT_LOG.info("QMAW restoreLinks: placeholder {} found with different case: {}", new Object[]{le.placeholder, actualPlaceholder});
                    continue;
                }
                AutoTranslation.AT_LOG.error("QMAW restoreLinks: placeholder {} COMPLETELY LOST by translator!", new Object[]{le.placeholder});
                continue;
            }
            result = result.replace(le.placeholder, linkText);
        }
        int linkCount = QmawTranslator.countOccurrences(result, "[[");
        if (linkCount != links.size()) {
            AutoTranslation.AT_LOG.warn("QMAW restoreLinks: expected {} links, but result has {} [[ markers", new Object[]{links.size(), linkCount});
        }
        return result;
    }

    private static int countOccurrences(String str, String sub) {
        if (str == null || sub == null || sub.isEmpty()) {
            return 0;
        }
        int count = 0;
        int pos = 0;
        while ((pos = str.indexOf(sub, pos)) >= 0) {
            ++count;
            pos += sub.length();
        }
        return count;
    }

    private static int applyCachedTranslationsToQmaw(Map<String, Object> qmawMap, Class<?> qmawEntryClass, Field nameField, Field titleField, Field contentsField, String targetLang) {
        Map<String, String> cached = ResourceManager.getAllQmawTranslations();
        if (cached.isEmpty() || qmawMap.isEmpty()) {
            return 0;
        }
        int applied = 0;
        for (Map.Entry<String, String> entry : cached.entrySet()) {
            String manualName;
            Object qmawEntry;
            String key = entry.getKey();
            String translation = entry.getValue();
            boolean isBody = key.startsWith("qmaw:body:");
            boolean isTitle = key.startsWith("qmaw:title:");
            if (!isBody && !isTitle || (qmawEntry = QmawTranslator.findQmawEntry(qmawMap, nameField, manualName = key.substring(isBody ? "qmaw:body:".length() : "qmaw:title:".length()))) == null) continue;
            try {
                HashMap<String, String> map = (HashMap<String, String>)(isBody ? contentsField.get(qmawEntry) : titleField.get(qmawEntry));
                if (map == null) {
                    map = new HashMap<String, String>();
                    if (isBody) {
                        contentsField.set(qmawEntry, map);
                    } else {
                        titleField.set(qmawEntry, map);
                    }
                }
                if (QmawTranslator.hasLang((Map<String, String>)map, targetLang)) continue;
                map.put(targetLang, translation);
                map.put(targetLang.toLowerCase(), translation);
                map.put(targetLang.replace("_", "-"), translation);
                ++applied;
            }
            catch (Exception exception) {}
        }
        return applied;
    }

    private static Object findQmawEntry(Map<String, Object> qmawMap, Field nameField, String name) {
        Object direct = qmawMap.get(name);
        if (direct != null) {
            return direct;
        }
        for (Object value : qmawMap.values()) {
            if (value == null) continue;
            try {
                String entryName = (String)nameField.get(value);
                if (!name.equals(entryName)) continue;
                return value;
            }
            catch (Exception exception) {
            }
        }
        return null;
    }

    private static int countMissingManualTranslations(Object[] entries, Field titleField, Field contentsField, String targetLang) {
        int missing = 0;
        for (Object entry : entries) {
            if (entry == null) continue;
            try {
                boolean titleTranslated;
                Map contents = (Map)contentsField.get(entry);
                boolean bodyTranslated = contents != null && QmawTranslator.hasLang(contents, targetLang);
                Map titles = (Map)titleField.get(entry);
                boolean bl = titleTranslated = titles == null || titles.isEmpty() || QmawTranslator.hasLang(titles, targetLang);
                if (bodyTranslated && titleTranslated) continue;
                ++missing;
            }
            catch (Exception ignored) {
                ++missing;
            }
        }
        return missing;
    }

    private static boolean hasLang(Map<String, String> map, String targetLang) {
        return map.containsKey(targetLang) || map.containsKey(targetLang.toLowerCase()) || map.containsKey(targetLang.replace("_", "-"));
    }

    private static class JsonManual {
        final String title;
        final String content;

        JsonManual(String title, String content) {
            this.title = title;
            this.content = content;
        }
    }

    private static class LinkProcess {
        final String textWithPlaceholders;
        final List<LinkEntry> links;

        LinkProcess(String textWithPlaceholders, List<LinkEntry> links) {
            this.textWithPlaceholders = textWithPlaceholders;
            this.links = links;
        }
    }

    private static class LinkEntry {
        final String placeholder;
        final String target;
        final String translatedLabel;

        LinkEntry(String placeholder, String target, String translatedLabel) {
            this.placeholder = placeholder;
            this.target = target;
            this.translatedLabel = translatedLabel;
        }
    }
}

