/*
 * Decompiled with CFR 0.152.
 */
package me.langyue.autotranslation.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import me.langyue.autotranslation.AutoTranslation;
import me.langyue.autotranslation.resource.ResourceManager;
import me.langyue.autotranslation.translate.TranslateThreadPool;
import me.langyue.autotranslation.translate.TranslatorManager;

public class TranslatorHelper {
    private static final Pattern TAG_PATTERN = Pattern.compile("(([^\\s:]+:)+([^\\s.]+\\.)*[^\\s.]+)|(([^\\s.]+\\.)+[^\\s.]+)");
    private static Pattern enPattern = Pattern.compile("[A-Z]?[a-z]+\\s([A-Z]?[a-z]+\\s*)+");
    private static Pattern langPattern = null;
    private static final List<String> blacklist = Collections.synchronizedList(new ArrayList());
    private static final Map<String, String> CACHE = new ConcurrentHashMap<String, String>();
    public static Set<String> noNeedForTranslation = new LinkedHashSet<String>();
    private static final int CYR_LOG_LIMIT = 20;
    private static int cyrLogEmitted = 0;

    public static void init() {
        try {
            enPattern = Pattern.compile(AutoTranslation.CONFIG.enFeature);
            if (AutoTranslation.CONFIG.yourLanguageFeature != null && !AutoTranslation.CONFIG.yourLanguageFeature.isEmpty()) {
                langPattern = Pattern.compile(AutoTranslation.CONFIG.yourLanguageFeature);
            }
            noNeedForTranslation.addAll(AutoTranslation.CONFIG.wordBlacklist);
            CACHE.putAll(ResourceManager.getAllTranslations());
            AutoTranslation.LOGGER.info("Loaded {} cached translations from file", new Object[]{CACHE.size()});
            AutoTranslation.LOGGER.info("TranslatorHelper initialized");
        }
        catch (Exception e) {
            AutoTranslation.LOGGER.error("Error initializing TranslatorHelper", (Throwable)e);
        }
    }

    public static void addBlacklist(String key) {
        blacklist.add(key);
    }

    public static boolean containsCyrillic(String text) {
        if (text == null || text.trim().isEmpty()) {
            return false;
        }
        int totalLetters = 0;
        int cyrillicCount = 0;
        for (char c : text.toCharArray()) {
            if (!Character.isLetter(c)) continue;
            ++totalLetters;
            if (!(c >= '\u0430' && c <= '\u044f' || c >= '\u0410' && c <= '\u042f' || c == '\u0451') && c != '\u0401') continue;
            ++cyrillicCount;
        }
        if (totalLetters == 0) {
            return false;
        }
        double cyrillicPercent = (double)cyrillicCount / (double)totalLetters;
        return cyrillicPercent > 0.2;
    }

    public static boolean shouldTranslate(String content) {
        return TranslatorHelper.shouldTranslate(content, content);
    }

    public static boolean shouldTranslate(String key, String content) {
        if (blacklist.remove(content)) {
            return false;
        }
        if ("en_US".equals(AutoTranslation.getLanguage())) {
            return false;
        }
        if (content == null || content.trim().length() < 2) {
            return false;
        }
        if (content.trim().startsWith("* (")) {
            return false;
        }
        if (!enPattern.matcher(content).find()) {
            return false;
        }
        if (langPattern != null && langPattern.matcher(content).find()) {
            AutoTranslation.debug("Skipping translation - native language detected in: {}", content);
            return false;
        }
        if (TAG_PATTERN.matcher(content).matches()) {
            return false;
        }
        if (CACHE.containsKey(key)) {
            return true;
        }
        String filtered = content.replaceAll("(\u00a7[0-9a-fk-or])", "").replaceAll(TAG_PATTERN.pattern(), "").replaceAll("[@#*&]\\S+", "").toLowerCase();
        for (String word : noNeedForTranslation) {
            filtered = filtered.replaceAll(word.toLowerCase(), " ");
        }
        return enPattern.matcher(filtered.trim()).find();
    }

    public static String reapplyFormatting(String originalWithCodes, String translatedPlain) {
        if (originalWithCodes == null || translatedPlain == null) {
            return translatedPlain;
        }
        int originalLeading = TranslatorHelper.leadingWhitespace(originalWithCodes);
        int translatedLeading = TranslatorHelper.leadingWhitespace(translatedPlain);
        if (translatedLeading < originalLeading) {
            StringBuilder pad = new StringBuilder();
            for (int i = 0; i < originalLeading - translatedLeading; ++i) {
                pad.append(' ');
            }
            translatedPlain = pad + translatedPlain;
        }
        ArrayList<FormatCode> codes = new ArrayList<FormatCode>();
        int outPos = 0;
        for (int i = 0; i < originalWithCodes.length(); ++i) {
            char c = originalWithCodes.charAt(i);
            if (c == '\u00a7' && i + 1 < originalWithCodes.length()) {
                String code = originalWithCodes.substring(i, i + 2);
                codes.add(new FormatCode(outPos, code));
                ++i;
                continue;
            }
            ++outPos;
        }
        StringBuilder sb = new StringBuilder(translatedPlain);
        for (int i = codes.size() - 1; i >= 0; --i) {
            FormatCode fc = (FormatCode)codes.get(i);
            int pos = Math.min(Math.max(fc.pos, 0), sb.length());
            sb.insert(pos, fc.code);
        }
        if (!codes.isEmpty() && ((FormatCode)codes.get((int)0)).pos == 0 && sb.length() > 0 && sb.charAt(0) != '\u00a7') {
            sb.insert(0, ((FormatCode)codes.get((int)0)).code);
        }
        return sb.toString();
    }

    private static int leadingWhitespace(String s) {
        if (s == null) {
            return 0;
        }
        int count = 0;
        boolean skipNext = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (skipNext) {
                skipNext = false;
                continue;
            }
            if (ch == '\u00a7') {
                skipNext = true;
                continue;
            }
            if (ch != ' ' && ch != '\t') break;
            ++count;
        }
        return count;
    }

    public static String translate(String text, Consumer<String> callback) {
        return TranslatorHelper.translate(text, AutoTranslation.CONFIG.appendOriginal, callback);
    }

    public static String translate(String text, boolean appendOriginal, Consumer<String> callback) {
        return TranslatorHelper.translate(text, text, appendOriginal, callback);
    }

    public static String translate(String key, String text, Consumer<String> callback) {
        return TranslatorHelper.translate(key, text, AutoTranslation.CONFIG.appendOriginal, callback);
    }

    public static String translate(String key, String text, boolean appendOriginal, Consumer<String> callback) {
        if (CACHE.containsKey(key)) {
            String translation = TranslatorHelper.append(CACHE.get(key), text, appendOriginal);
            if (callback != null) {
                callback.accept(translation);
            }
            return translation;
        }
        String saved = null;
        if (ResourceManager.hasTranslation(key)) {
            saved = ResourceManager.getTranslation(key);
        } else if (ResourceManager.hasTranslation(text)) {
            saved = ResourceManager.getTranslation(text);
        }
        if (saved != null) {
            TranslatorHelper.setCache(key, saved);
            String translation = TranslatorHelper.append(saved, text, appendOriginal);
            if (callback != null) {
                callback.accept(translation);
            }
            AutoTranslation.debug("Translation loaded from file: {} -> {}", key, saved);
            return translation;
        }
        TranslateThreadPool.offer(key, text, translated -> {
            if (callback != null) {
                callback.accept(TranslatorHelper.append(translated, text, appendOriginal));
            }
        });
        return null;
    }

    public static String translateSync(String text) {
        return TranslatorHelper.translateSync(text, text);
    }

    public static String translateSync(String key, String text) {
        String saved;
        String cleanKey = key.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
        String cleanText = text.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
        if (TranslatorHelper.containsCyrillic(cleanText)) {
            TranslatorHelper.logCyrSkip(cleanText);
            return text;
        }
        if (CACHE.containsKey(cleanKey)) {
            return CACHE.get(cleanKey);
        }
        if (!cleanKey.equals(cleanText) && CACHE.containsKey(cleanText)) {
            String cached = CACHE.get(cleanText);
            TranslatorHelper.setCache(cleanKey, cached);
            return cached;
        }
        if (ResourceManager.hasTranslation(cleanKey) && (saved = ResourceManager.getTranslation(cleanKey)) != null) {
            TranslatorHelper.setCache(cleanKey, saved);
            return saved;
        }
        if (!cleanKey.equals(cleanText) && ResourceManager.hasTranslation(cleanText) && (saved = ResourceManager.getTranslation(cleanText)) != null) {
            TranslatorHelper.setCache(cleanKey, saved);
            return saved;
        }
        String translation = TranslatorManager.getTranslator().translate(cleanText, AutoTranslation.getLanguage(), "en");
        if (translation != null && !translation.isEmpty()) {
            boolean originalIsEnglish = !TranslatorHelper.containsCyrillic(cleanText);
            boolean translationIsRussian = TranslatorHelper.containsCyrillic(translation);
            if (originalIsEnglish && translationIsRussian) {
                if (cleanKey.equals(cleanText)) {
                    if (!ResourceManager.hasTranslation(cleanText)) {
                        ResourceManager.noKeyTranslate(cleanText, translation);
                    } else {
                        translation = ResourceManager.getTranslation(cleanText);
                    }
                }
            } else {
                AutoTranslation.debug("Skipping save - original is not English or translation is not Russian: {} -> {}", cleanText, translation);
            }
            return TranslatorHelper.setCache(cleanKey, translation);
        }
        return text;
    }

    public static String translateCached(String key) {
        String saved;
        String cleanKey = key.replaceAll("\u00a7[0-9a-fk-or]", "").trim();
        if (TranslatorHelper.containsCyrillic(cleanKey)) {
            TranslatorHelper.logCyrSkip(cleanKey);
            return key;
        }
        if (CACHE.containsKey(cleanKey)) {
            return CACHE.get(cleanKey);
        }
        if (!cleanKey.equals(key) && CACHE.containsKey(key)) {
            String cached = CACHE.get(key);
            TranslatorHelper.setCache(cleanKey, cached);
            return cached;
        }
        if (ResourceManager.hasTranslation(cleanKey) && (saved = ResourceManager.getTranslation(cleanKey)) != null) {
            TranslatorHelper.setCache(cleanKey, saved);
            return saved;
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void logCyrSkip(String text) {
        if (AutoTranslation.CONFIG != null && !AutoTranslation.CONFIG.debug) {
            return;
        }
        Class<TranslatorHelper> clazz = TranslatorHelper.class;
        synchronized (TranslatorHelper.class) {
            if (cyrLogEmitted >= 20) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ++cyrLogEmitted;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            AutoTranslation.AT_LOG.debug("Skipping translation - Cyrillic detected in: {}", new Object[]{text});
            return;
        }
    }

    private static String append(String translation, String original, boolean appendOriginal) {
        String[] originalLines;
        if (!appendOriginal || translation == null) {
            return translation;
        }
        if (!translation.contains("\n")) {
            return translation + " \u00a77* (" + original + ")";
        }
        StringBuilder result = new StringBuilder();
        String[] translatedLines = translation.split("\n");
        if (translatedLines.length != (originalLines = original.split("\n")).length) {
            return translation + " \u00a77* (" + original + ")";
        }
        for (int i = 0; i < translatedLines.length; ++i) {
            result.append(translatedLines[i]).append(" \u00a77* (").append(originalLines[i]).append(')');
            if (i >= translatedLines.length - 1) continue;
            result.append("\n");
        }
        return result.toString();
    }

    public static String setCache(String key, String value) {
        if (key != null && value != null && !key.trim().startsWith("{") && !key.trim().endsWith("}")) {
            CACHE.put(key, value);
        }
        return value;
    }

    public static boolean hasCache(String key) {
        if (key == null) {
            return false;
        }
        if (CACHE.containsKey(key)) {
            return true;
        }
        return ResourceManager.hasTranslation(key);
    }

    public static void clearCache() {
        CACHE.clear();
    }

    static {
        noNeedForTranslation.add("Esc");
        noNeedForTranslation.add("Tab");
        noNeedForTranslation.add("Caps");
        noNeedForTranslation.add("Ins");
        noNeedForTranslation.add("Del");
        noNeedForTranslation.add("Home");
        noNeedForTranslation.add("End");
        noNeedForTranslation.add("Ctrl");
        noNeedForTranslation.add("Shift");
        noNeedForTranslation.add("Alt");
        noNeedForTranslation.add("Java");
        noNeedForTranslation.add("Minecraft");
        noNeedForTranslation.add("MC");
        noNeedForTranslation.add("Modrinth");
        noNeedForTranslation.add("CurseForge");
        noNeedForTranslation.add("Fabric");
        noNeedForTranslation.add("Forge");
        noNeedForTranslation.add("Discord");
        noNeedForTranslation.add("Patreon");
        noNeedForTranslation.add("YouTube");
        noNeedForTranslation.add("Twitch");
        noNeedForTranslation.add("Twitter");
        noNeedForTranslation.add("PayPal");
        noNeedForTranslation.add("FPS");
        noNeedForTranslation.add("TPS");
        noNeedForTranslation.add("ping");
        noNeedForTranslation.add("max");
        noNeedForTranslation.add("min");
        noNeedForTranslation.add("avg");
        noNeedForTranslation.add("id");
        noNeedForTranslation.add("Server");
    }

    private static class FormatCode {
        final int pos;
        final String code;

        FormatCode(int pos, String code) {
            this.pos = pos;
            this.code = code;
        }
    }
}

