/*
 * Decompiled with CFR 0.152.
 */
package dev.strangequark.stashlight.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.strangequark.stashlight.logic.sort.SortKey;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public final class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path FILE = FabricLoader.getInstance().getConfigDir().resolve("stashlight.json");
    private static Config INSTANCE;
    private boolean lookAtTarget = false;
    private boolean showSmallContainers = false;
    private int searchRadiusIndex = 2;
    private transient String searchQuery = "";
    private transient SortKey sortKey = SortKey.ALPHABETICAL;

    private Config() {
    }

    public static Config get() {
        if (INSTANCE == null) {
            Config.load();
        }
        return INSTANCE;
    }

    public boolean lookAtTarget() {
        return this.lookAtTarget;
    }

    public boolean showSmallContainers() {
        return this.showSmallContainers;
    }

    public String searchQuery() {
        return this.searchQuery;
    }

    public SortKey sortKey() {
        return this.sortKey;
    }

    public int searchRadiusIndex() {
        if (this.searchRadiusIndex < 0 || this.searchRadiusIndex > 5) {
            this.searchRadiusIndex = 2;
        }
        return this.searchRadiusIndex;
    }

    public void setLookAtTarget(boolean value) {
        if (this.lookAtTarget == value) {
            return;
        }
        this.lookAtTarget = value;
        Config.save();
    }

    public void setShowSmallContainers(boolean value) {
        if (this.showSmallContainers == value) {
            return;
        }
        this.showSmallContainers = value;
        Config.save();
    }

    public void setSearchQuery(String searchQuery) {
        this.searchQuery = searchQuery;
    }

    public void setSortKey(SortKey key) {
        this.sortKey = key;
    }

    public void setSearchRadiusIndex(int index) {
        this.searchRadiusIndex = Math.max(0, Math.min(index, 5));
        Config.save();
    }

    public static void load() {
        if (Files.exists(FILE, new LinkOption[0])) {
            try {
                INSTANCE = (Config)GSON.fromJson(Files.readString(FILE), Config.class);
                INSTANCE.validate();
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        INSTANCE = new Config();
    }

    private void validate() {
        this.searchRadiusIndex = Math.max(0, Math.min(this.searchRadiusIndex, 5));
    }

    public static void save() {
        try {
            Files.writeString(FILE, (CharSequence)GSON.toJson((Object)Config.get()), new OpenOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

