/*
 * Decompiled with CFR 0.152.
 */
package dev.strangequark.stashlight.gui;

import dev.strangequark.stashlight.config.Config;
import dev.strangequark.stashlight.gui.QuantityLabel;
import dev.strangequark.stashlight.model.IndexedItem;
import dev.strangequark.stashlight.render.HighlightManager;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.ItemComponent;
import io.wispforest.owo.ui.container.StackLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_9334;

public class ItemSlot
extends StackLayout {
    private final IndexedItem indexedItem;
    private static final Surface BASE_SURFACE = Surface.flat((int)0x55888888);
    private static final Surface HOVER_SURFACE = Surface.flat((int)0x44FFFFFF).and(Surface.outline((int)-1));

    public static ItemSlot of(IndexedItem indexedItem) {
        return new ItemSlot(indexedItem);
    }

    protected ItemSlot(IndexedItem indexedItem) {
        super(Sizing.fixed((int)24), Sizing.fixed((int)24));
        this.indexedItem = indexedItem;
        class_1799 stack = indexedItem.stack();
        ItemComponent itemdisplay = Components.item((class_1799)stack);
        itemdisplay.showOverlay(false).sizing(Sizing.fill((int)85));
        int count = stack.method_7947();
        float scale = count > 999 ? 0.75f : 0.85f;
        QuantityLabel countLabel = QuantityLabel.of((class_2561)class_2561.method_43470((String)String.valueOf(count)));
        countLabel.positioning(Positioning.relative((int)90, (int)90));
        this.surface(BASE_SURFACE).alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        this.child((Component)itemdisplay);
        if (count > 1) {
            this.child((Component)countLabel.scale(scale));
        }
    }

    public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        boolean isMouseInside = mouseX >= this.x && mouseX <= this.x + this.width && mouseY >= this.y && mouseY <= this.y + this.height;
        this.surface(isMouseInside ? HOVER_SURFACE : BASE_SURFACE);
        super.draw(context, mouseX, mouseY, partialTicks, delta);
        if (isMouseInside) {
            this.drawTooltip(context, mouseX, mouseY, partialTicks, delta);
        }
    }

    public void drawTooltip(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return;
        }
        double dist = Math.sqrt(client.field_1724.method_24515().method_10262((class_2382)this.indexedItem.pos()));
        String formattedDist = String.format("%.1f", dist);
        String posStr = String.format("%d, %d, %d", this.indexedItem.pos().method_10263(), this.indexedItem.pos().method_10264(), this.indexedItem.pos().method_10260());
        ArrayList<class_5250> lines = new ArrayList<class_5250>(this.indexedItem.stack().method_7950(class_1792.class_9635.method_59530((class_7225.class_7874)client.field_1687.method_30349()), (class_1657)client.field_1724, (class_1836)(client.field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070)));
        lines.add(class_2561.method_43473());
        lines.add(class_2561.method_43471((String)"gui.stashlight.label.container").method_27692(class_124.field_1080).method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)this.indexedItem.containerName()).method_27692(class_124.field_1068)));
        lines.add(class_2561.method_43471((String)"gui.stashlight.label.location").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)": ").method_27692(class_124.field_1080)).method_10852((class_2561)class_2561.method_43470((String)posStr).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43469((String)"gui.stashlight.label.blocksAway", (Object[])new Object[]{formattedDist}).method_27692(class_124.field_1080)));
        lines.add(class_2561.method_43471((String)"gui.stashlight.label.dimension").method_27692(class_124.field_1080).method_27693(": ").method_10852((class_2561)class_2561.method_43470((String)this.indexedItem.dimension()).method_27692(class_124.field_1060)));
        context.method_51437(client.field_1772, lines, this.indexedItem.stack().method_32347(), mouseX, mouseY, (class_2960)this.indexedItem.stack().method_58694(class_9334.field_54198));
    }

    public boolean onMouseDown(class_11909 click, boolean doubled) {
        if (click.method_74245() != 0) {
            return super.onMouseDown(click, doubled);
        }
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            return true;
        }
        boolean highlighted = HighlightManager.tryHighlight(this.indexedItem);
        if (!highlighted) {
            return true;
        }
        if (Config.get().lookAtTarget()) {
            this.lookAt((class_1657)player, this.indexedItem.pos());
        }
        client.method_1507(null);
        return true;
    }

    private void lookAt(class_1657 player, class_2338 target) {
        double d = (double)target.method_10263() + 0.5 - player.method_23317();
        double e = (double)target.method_10264() + 0.5 - player.method_23320();
        double f = (double)target.method_10260() + 0.5 - player.method_23321();
        double g = Math.sqrt(d * d + f * f);
        float yaw = (float)(Math.atan2(f, d) * 180.0 / Math.PI) - 90.0f;
        float pitch = (float)(-(Math.atan2(e, g) * 180.0 / Math.PI));
        player.method_36456(yaw);
        player.method_36457(pitch);
    }
}

