/*
 * Decompiled with CFR 0.152.
 */
package dev.strangequark.stashlight.logic.filter;

import dev.strangequark.stashlight.logic.filter.FilterStrategy;
import dev.strangequark.stashlight.model.IndexedItem;
import java.util.ArrayList;
import java.util.List;

public class FilterManager {
    private final List<FilterStrategy> cycling = new ArrayList<FilterStrategy>();
    private final List<FilterStrategy> alwaysOn = new ArrayList<FilterStrategy>();
    private int currentIndex;

    public void setCyclingStrategies(List<FilterStrategy> strategies) {
        this.cycling.clear();
        this.cycling.addAll(strategies);
        this.currentIndex = 0;
    }

    public void addAlwaysOn(FilterStrategy strategy) {
        this.alwaysOn.add(strategy);
    }

    public void cycle() {
        if (this.cycling.isEmpty()) {
            return;
        }
        this.currentIndex = (this.currentIndex + 1) % this.cycling.size();
    }

    public boolean matches(IndexedItem item) {
        for (FilterStrategy s : this.alwaysOn) {
            if (s.matches(item)) continue;
            return false;
        }
        if (this.cycling.isEmpty()) {
            return true;
        }
        return this.cycling.get(this.currentIndex).matches(item);
    }

    public String getCurrentLabel() {
        return this.cycling.isEmpty() ? "" : this.cycling.get(this.currentIndex).getLabel();
    }
}

