/*
 * Decompiled with CFR 0.152.
 */
package dev.strangequark.stashlight.logic.filter;

import dev.strangequark.stashlight.config.Config;
import dev.strangequark.stashlight.logic.filter.FilterStrategy;
import dev.strangequark.stashlight.model.IndexedItem;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public final class RadiusFilter
implements FilterStrategy {
    private static final int[] RADIUS_VALUES = new int[]{4, 8, 16, 32, 64, -1};
    private static final int DEFAULT_INDEX = 2;

    @Override
    public String getLabel() {
        int index = Config.get().searchRadiusIndex();
        int val = RADIUS_VALUES[index];
        return val == -1 ? "All" : val + " (Chunks)";
    }

    @Override
    public boolean matches(IndexedItem item) {
        int index = Config.get().searchRadiusIndex();
        int maxRadius = RADIUS_VALUES[index];
        if (maxRadius == -1) {
            return true;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || item.pos() == null) {
            return true;
        }
        int pX = player.method_24515().method_10263() >> 4;
        int pZ = player.method_24515().method_10260() >> 4;
        int iX = item.pos().method_10263() >> 4;
        int iZ = item.pos().method_10260() >> 4;
        int dist = Math.max(Math.abs(pX - iX), Math.abs(pZ - iZ));
        return dist <= maxRadius;
    }

    public static class_2561 getLabelForIndex(int index) {
        int safeIndex = index < 0 || index >= RADIUS_VALUES.length ? 2 : index;
        int val = RADIUS_VALUES[safeIndex];
        class_5250 valueText = val == -1 ? class_2561.method_43471((String)"gui.stashlight.label.rangeAll") : class_2561.method_43469((String)"gui.stashlight.label.rangeChunks", (Object[])new Object[]{val});
        return class_2561.method_43469((String)"gui.stashlight.label.searchRange", (Object[])new Object[]{valueText});
    }
}

