/*
 * Decompiled with CFR 0.152.
 */
package dev.strangequark.stashlight.logic.sort;

import dev.strangequark.stashlight.logic.sort.AlphabeticalSort;
import dev.strangequark.stashlight.logic.sort.CountSort;
import dev.strangequark.stashlight.logic.sort.DistanceSort;
import dev.strangequark.stashlight.logic.sort.SortKey;
import dev.strangequark.stashlight.logic.sort.SortStrategy;
import java.util.Map;

public class SortManager {
    private static final Map<SortKey, SortStrategy> STRATEGIES = Map.of(SortKey.ALPHABETICAL, new AlphabeticalSort(), SortKey.COUNT, new CountSort(), SortKey.DISTANCE, new DistanceSort());
    private SortKey current;

    public SortManager(SortKey initial) {
        this.current = initial;
    }

    public void cycle() {
        SortKey[] keys = SortKey.values();
        int nextIndex = (this.current.ordinal() + 1) % keys.length;
        this.current = keys[nextIndex];
    }

    public SortStrategy getCurrent() {
        return STRATEGIES.get((Object)this.current);
    }
}

