/*
 * Decompiled with CFR 0.152.
 */
package dev.strangequark.stashlight.repository;

import dev.strangequark.stashlight.model.ContainerSnapshot;
import dev.strangequark.stashlight.model.IndexedItem;
import dev.strangequark.stashlight.model.StackKey;
import dev.strangequark.stashlight.serializer.Serializer;
import dev.strangequark.stashlight.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_638;

public class ContainerRepository {
    private final Serializer serializer;
    private volatile boolean isDirty = false;
    private final Map<String, Map<class_2338, ContainerSnapshot>> CONTAINER_ENTRIES_MAP;
    private List<IndexedItem> SEARCH_INDEX = new ArrayList<IndexedItem>();
    private final Map<String, Map<class_2338, List<IndexedItem>>> INDEX_LOOKUP = new HashMap<String, Map<class_2338, List<IndexedItem>>>();
    private final ExecutorService cleanupExecutor = Executors.newSingleThreadExecutor(r -> {
        Thread t = new Thread(r, "ChestFinder-Cleanup");
        t.setDaemon(true);
        return t;
    });

    public ContainerRepository(Serializer serializer) {
        this.serializer = serializer;
        this.CONTAINER_ENTRIES_MAP = serializer.read();
        this.rebuildIndex();
    }

    public void runCleanup(class_638 world) {
        String dimension = Util.getDimensionName((class_1937)world);
        Map<class_2338, ContainerSnapshot> dataMap = this.CONTAINER_ENTRIES_MAP.get(dimension);
        if (dataMap == null || dataMap.isEmpty()) {
            return;
        }
        this.cleanupExecutor.submit(() -> {
            ArrayList toCheck;
            Map<String, Map<class_2338, ContainerSnapshot>> map = this.CONTAINER_ENTRIES_MAP;
            synchronized (map) {
                toCheck = new ArrayList(dataMap.keySet());
            }
            ArrayList<class_2338> toRemove = new ArrayList<class_2338>();
            for (class_2338 pos : toCheck) {
                try {
                    class_2680 state;
                    if (!world.method_2935().method_12123(pos.method_10263() >> 4, pos.method_10260() >> 4) || Util.isValidSearchableContainer(state = world.method_8320(pos))) continue;
                    toRemove.add(pos);
                }
                catch (Exception state) {}
            }
            if (!toRemove.isEmpty()) {
                Map<String, Map<class_2338, ContainerSnapshot>> map2 = this.CONTAINER_ENTRIES_MAP;
                synchronized (map2) {
                    for (class_2338 pos : toRemove) {
                        dataMap.remove(pos);
                        this.removeFromIndex(dimension, pos);
                    }
                    this.isDirty = true;
                }
                this.saveIfDirty();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String dimension, class_2338 pos, String blockName, int capacity, List<class_1799> stacks) {
        ArrayList<class_1799> copiedStacks = new ArrayList<class_1799>();
        for (class_1799 original : stacks) {
            if (original == null || original.method_7960()) continue;
            copiedStacks.add(original.method_7972());
        }
        ContainerSnapshot snapshot = new ContainerSnapshot(blockName, capacity, copiedStacks, System.currentTimeMillis());
        Map<String, Map<class_2338, ContainerSnapshot>> map = this.CONTAINER_ENTRIES_MAP;
        synchronized (map) {
            this.CONTAINER_ENTRIES_MAP.computeIfAbsent(dimension, k -> new HashMap()).put(pos, snapshot);
            this.isDirty = true;
            this.removeFromIndex(dimension, pos);
            this.addToIndex(dimension, pos, snapshot);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String dimension, class_2338 pos) {
        Map<String, Map<class_2338, ContainerSnapshot>> map = this.CONTAINER_ENTRIES_MAP;
        synchronized (map) {
            Map<class_2338, ContainerSnapshot> dimMap = this.CONTAINER_ENTRIES_MAP.get(dimension);
            if (dimMap != null && dimMap.remove(pos) != null) {
                this.isDirty = true;
                this.removeFromIndex(dimension, pos);
            }
        }
    }

    private void removeFromIndex(String dimension, class_2338 pos) {
        List<IndexedItem> oldItems;
        Map<class_2338, List<IndexedItem>> dimLookup = this.INDEX_LOOKUP.get(dimension);
        if (dimLookup != null && (oldItems = dimLookup.remove(pos)) != null && !oldItems.isEmpty()) {
            HashSet<IndexedItem> itemsToRemove = new HashSet<IndexedItem>(oldItems);
            ArrayList<IndexedItem> newIndex = new ArrayList<IndexedItem>(this.SEARCH_INDEX.size());
            for (IndexedItem item : this.SEARCH_INDEX) {
                if (itemsToRemove.contains(item)) continue;
                newIndex.add(item);
            }
            this.SEARCH_INDEX = newIndex;
        }
    }

    private void addToIndex(String dimension, class_2338 pos, ContainerSnapshot snapshot) {
        LinkedHashMap<StackKey, class_1799> localMap = new LinkedHashMap<StackKey, class_1799>();
        for (class_1799 stack : snapshot.items()) {
            if (stack == null || stack.method_7960()) continue;
            StackKey key = new StackKey(stack);
            if (localMap.containsKey(key)) {
                ((class_1799)localMap.get(key)).method_7933(stack.method_7947());
                continue;
            }
            localMap.put(key, stack.method_7972());
        }
        ArrayList<IndexedItem> newItems = new ArrayList<IndexedItem>();
        for (class_1799 summedStack : localMap.values()) {
            IndexedItem indexedItem = new IndexedItem(summedStack, pos, dimension, snapshot.containerName(), snapshot.containerCapacity(), snapshot.timestamp());
            newItems.add(indexedItem);
            this.SEARCH_INDEX.add(indexedItem);
        }
        this.INDEX_LOOKUP.computeIfAbsent(dimension, k -> new HashMap()).put(pos, newItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveIfDirty() {
        if (this.isDirty) {
            Map<String, Map<class_2338, ContainerSnapshot>> map = this.CONTAINER_ENTRIES_MAP;
            synchronized (map) {
                this.serializer.write(this.CONTAINER_ENTRIES_MAP);
                this.isDirty = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebuildIndex() {
        Map<String, Map<class_2338, ContainerSnapshot>> map = this.CONTAINER_ENTRIES_MAP;
        synchronized (map) {
            this.SEARCH_INDEX = new ArrayList<IndexedItem>();
            this.INDEX_LOOKUP.clear();
            for (Map.Entry<String, Map<class_2338, ContainerSnapshot>> dimEntry : this.CONTAINER_ENTRIES_MAP.entrySet()) {
                String dimension = dimEntry.getKey();
                for (Map.Entry<class_2338, ContainerSnapshot> posEntry : dimEntry.getValue().entrySet()) {
                    class_2338 pos = posEntry.getKey();
                    ContainerSnapshot snapshot = posEntry.getValue();
                    this.addToIndex(dimension, pos, snapshot);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getDimensions() {
        Map<String, Map<class_2338, ContainerSnapshot>> map = this.CONTAINER_ENTRIES_MAP;
        synchronized (map) {
            return new HashSet<String>(this.CONTAINER_ENTRIES_MAP.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<IndexedItem> getSearchIndex() {
        Map<String, Map<class_2338, ContainerSnapshot>> map = this.CONTAINER_ENTRIES_MAP;
        synchronized (map) {
            return new ArrayList<IndexedItem>(this.SEARCH_INDEX);
        }
    }

    public void shutdown() {
        this.saveIfDirty();
        this.cleanupExecutor.shutdown();
    }
}

