/*
 * Decompiled with CFR 0.152.
 */
package dev.strangequark.stashlight.screen;

import dev.strangequark.stashlight.config.Config;
import dev.strangequark.stashlight.gui.ItemSlot;
import dev.strangequark.stashlight.logic.filter.DimensionFilter;
import dev.strangequark.stashlight.logic.filter.FilterManager;
import dev.strangequark.stashlight.logic.filter.FilterStrategy;
import dev.strangequark.stashlight.logic.filter.RadiusFilter;
import dev.strangequark.stashlight.logic.filter.SmallContainerFilter;
import dev.strangequark.stashlight.logic.sort.SortManager;
import dev.strangequark.stashlight.model.IndexedItem;
import dev.strangequark.stashlight.repository.ContainerRepository;
import dev.strangequark.stashlight.util.Util;
import io.wispforest.owo.ui.base.BaseOwoScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.CheckboxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.DiscreteSliderComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.GridLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_638;
import net.minecraft.class_9276;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;

public class SearchScreen
extends BaseOwoScreen<FlowLayout> {
    private final ContainerRepository repository;
    private FlowLayout rootComponent;
    private FlowLayout scrollContent;
    private TextBoxComponent searchField;
    private final FilterManager filterManager = new FilterManager();
    private final SortManager sortManager;

    public SearchScreen(ContainerRepository repository) {
        this.repository = repository;
        this.sortManager = new SortManager(Config.get().sortKey());
        this.setupFilters();
    }

    private void setupFilters() {
        ArrayList<FilterStrategy> strategies = new ArrayList<FilterStrategy>();
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            String currentDim = Util.getDimensionName((class_1937)world);
            strategies.add(new DimensionFilter("Current", currentDim));
        }
        strategies.add(new DimensionFilter("All", null));
        this.repository.getDimensions().forEach(dim -> strategies.add(new DimensionFilter((String)dim, (String)dim)));
        this.filterManager.setCyclingStrategies(strategies);
        this.filterManager.addAlwaysOn(new SmallContainerFilter());
        this.filterManager.addAlwaysOn(new RadiusFilter());
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void method_25426() {
        super.method_25426();
        if (this.rootComponent.focusHandler() != null && this.searchField.focusHandler() != null) {
            this.rootComponent.focusHandler().focus((Component)this.searchField, Component.FocusSource.MOUSE_CLICK);
            this.searchField.method_1875(0);
            this.searchField.method_1884(this.searchField.method_1882().length());
        }
    }

    protected void build(FlowLayout rootComponent) {
        this.rootComponent = rootComponent;
        Config config = Config.get();
        FlowLayout mainWindow = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)95), (Sizing)Sizing.fill((int)95)).gap(4).surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.TOP).padding(Insets.of((int)8));
        LabelComponent title = Components.label((class_2561)class_2561.method_43471((String)"screen.stashlight.label.searchContainers")).shadow(true);
        FlowLayout searchBar = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill(), (Sizing)Sizing.fixed((int)20)).gap(4).alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        ButtonComponent sortBtn = (ButtonComponent)Components.button((class_2561)class_2561.method_30163((String)this.sortManager.getCurrent().getLabel()), b -> {
            this.sortManager.cycle();
            b.method_25355(class_2561.method_30163((String)this.sortManager.getCurrent().getLabel()));
            b.tooltip(this.sortManager.getCurrent().getTooltip());
            config.setSortKey(this.sortManager.getCurrent().key());
            this.refreshGrid(this.searchField.method_1882());
        }).tooltip(this.sortManager.getCurrent().getTooltip()).sizing(Sizing.fixed((int)20), Sizing.fixed((int)20));
        this.searchField = Components.textBox((Sizing)Sizing.fixed((int)200), (String)config.searchQuery());
        this.searchField.method_1880(100);
        this.searchField.onChanged().subscribe(text -> {
            config.setSearchQuery(text);
            this.refreshGrid(text);
        });
        ButtonComponent dimFilterBtn = (ButtonComponent)Components.button((class_2561)class_2561.method_43471((String)"gui.stashlight.label.dimension").method_27693(": ").method_27693(this.filterManager.getCurrentLabel()), b -> {
            this.filterManager.cycle();
            b.method_25355((class_2561)class_2561.method_43471((String)"gui.stashlight.label.dimension").method_27693(": ").method_27693(this.filterManager.getCurrentLabel()));
            this.refreshGrid(this.searchField.method_1882());
        }).sizing(Sizing.fixed((int)150), Sizing.fixed((int)20));
        searchBar.child((Component)sortBtn).child((Component)this.searchField).child((Component)dimFilterBtn);
        FlowLayout gridWrapper = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.expand((int)100)).surface(Surface.outline((int)-11184811)).padding(Insets.of((int)1));
        this.scrollContent = (FlowLayout)Containers.verticalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content()).padding(Insets.right((int)4)).horizontalAlignment(HorizontalAlignment.CENTER);
        ScrollContainer scrollContainer = Containers.verticalScroll((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fill((int)100), (Component)this.scrollContent);
        scrollContainer.scrollbarThiccness(6).scrollbar(ScrollContainer.Scrollbar.vanillaFlat()).surface((drawContext, component) -> {
            int x1 = component.x() + component.width() - 6;
            int y1 = component.y();
            int x2 = component.x() + component.width();
            int y2 = component.y() + component.height();
            drawContext.method_25294(x1, y1, x2, y2, -14671840);
        });
        gridWrapper.child((Component)scrollContainer);
        FlowLayout footer = (FlowLayout)Containers.horizontalFlow((Sizing)Sizing.fill((int)100), (Sizing)Sizing.fixed((int)20)).gap(4).verticalAlignment(VerticalAlignment.CENTER);
        CheckboxComponent lookAtCheckbox = (CheckboxComponent)Components.checkbox((class_2561)class_2561.method_43471((String)"screen.stashlight.lookAtTarget")).checked(config.lookAtTarget()).onChanged(config::setLookAtTarget).margins(Insets.top((int)1));
        CheckboxComponent showSmallCheckbox = (CheckboxComponent)Components.checkbox((class_2561)class_2561.method_43471((String)"screen.stashlight.showSmallContainers")).checked(config.showSmallContainers()).onChanged(v -> {
            config.setShowSmallContainers((boolean)v);
            this.refreshGrid(this.searchField.method_1882());
        }).margins(Insets.top((int)1));
        DiscreteSliderComponent distanceSlider = Components.discreteSlider((Sizing)Sizing.fixed((int)150), (double)0.0, (double)5.0);
        distanceSlider.snap(true).decimalPlaces(0);
        distanceSlider.setFromDiscreteValue((double)config.searchRadiusIndex());
        distanceSlider.message(s -> RadiusFilter.getLabelForIndex(config.searchRadiusIndex()));
        distanceSlider.onChanged().subscribe(v -> {
            int index = (int)Math.round(v);
            if (index == config.searchRadiusIndex()) {
                return;
            }
            config.setSearchRadiusIndex(index);
            distanceSlider.message(s -> RadiusFilter.getLabelForIndex(config.searchRadiusIndex()));
            this.refreshGrid(this.searchField.method_1882());
        });
        footer.child((Component)distanceSlider).child((Component)lookAtCheckbox).child((Component)showSmallCheckbox);
        mainWindow.child((Component)title).child((Component)searchBar).child((Component)gridWrapper).child((Component)footer);
        rootComponent.child((Component)mainWindow).alignment(HorizontalAlignment.CENTER, VerticalAlignment.CENTER);
        this.refreshGrid(config.searchQuery());
    }

    private void refreshGrid(String query) {
        this.scrollContent.clearChildren();
        int windowWidth = (int)((double)this.field_22789 * 0.95);
        int availableWidth = windowWidth - 16 - 10;
        int itemFootprint = 28;
        int slotsPerRow = Math.max(1, availableWidth / itemFootprint);
        List<IndexedItem> filteredItems = this.repository.getSearchIndex().stream().filter(item -> {
            boolean matchesQuery = SearchScreen.matchesDeep(item.stack(), query);
            return matchesQuery && this.filterManager.matches((IndexedItem)item);
        }).toList();
        ArrayList<IndexedItem> sortedItems = new ArrayList<IndexedItem>(filteredItems);
        if (this.sortManager.getCurrent() != null) {
            this.sortManager.getCurrent().sort(sortedItems);
        }
        int rows = (int)Math.ceil((double)sortedItems.size() / (double)slotsPerRow);
        GridLayout grid = (GridLayout)Containers.grid((Sizing)Sizing.fill((int)100), (Sizing)Sizing.content(), (int)rows, (int)slotsPerRow).margins(Insets.of((int)2));
        for (int i = 0; i < sortedItems.size(); ++i) {
            grid.child((Component)ItemSlot.of((IndexedItem)sortedItems.get(i)).margins(Insets.of((int)2)), i / slotsPerRow, i % slotsPerRow);
        }
        this.scrollContent.child((Component)grid);
    }

    public static boolean matchesDeep(class_1799 stack, String query) {
        class_9276 bundle;
        if (query.isEmpty()) {
            return true;
        }
        String q = query.toLowerCase();
        if (stack.method_7964().getString().toLowerCase().contains(q)) {
            return true;
        }
        class_9288 container = (class_9288)stack.method_58694(class_9334.field_49622);
        if (container != null) {
            for (class_1799 inner : container.method_59714()) {
                if (!inner.method_7964().getString().toLowerCase().contains(q)) continue;
                return true;
            }
        }
        if ((bundle = (class_9276)stack.method_58694(class_9334.field_49650)) != null) {
            for (class_1799 inner : bundle.method_57421()) {
                if (!inner.method_7964().getString().toLowerCase().contains(q)) continue;
                return true;
            }
        }
        return false;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_71278();
        super.method_25420(context, mouseX, mouseY, delta);
    }

    public void method_25410(int width, int height) {
        super.method_25410(width, height);
        this.refreshGrid(this.searchField.method_1882());
    }

    public boolean method_25421() {
        return false;
    }
}

