/*
 * Decompiled with CFR 0.152.
 */
package dev.strangequark.stashlight;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1132;
import net.minecraft.class_310;
import net.minecraft.class_5218;
import net.minecraft.class_642;

public final class Init {
    private static Path ROOT;

    public static void init() {
        if (FabricLoader.getInstance().getEnvironmentType() != EnvType.CLIENT) {
            throw new IllegalStateException("Stashlight initialized outside client");
        }
        ROOT = FabricLoader.getInstance().getGameDir().resolve("stashlight_cache");
        try {
            Files.createDirectories(ROOT, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to create Stashlight cache dir", e);
        }
    }

    public static Path getFileName() {
        Object fileName;
        class_310 client = class_310.method_1551();
        if (client.method_1542()) {
            class_1132 server = client.method_1576();
            if (server == null) {
                throw new IllegalStateException("Singleplayer server missing");
            }
            Path worldFolder = server.method_27050(class_5218.field_24188).normalize();
            fileName = worldFolder.getFileName().toString().replace(" ", "_").replace("(", "_").replace(")", "_");
        } else {
            class_642 info = client.method_1558();
            if (info == null) {
                throw new IllegalStateException("Multiplayer server info missing");
            }
            fileName = "MP_" + info.field_3761.replace(':', '_').replace('/', '_');
        }
        return ROOT.resolve((String)fileName + ".dat");
    }
}

