/*
 * Decompiled with CFR 0.152.
 */
package dev.strangequark.stashlight;

import dev.strangequark.stashlight.Init;
import dev.strangequark.stashlight.render.HighlightRenderer;
import dev.strangequark.stashlight.repository.ContainerRepository;
import dev.strangequark.stashlight.screen.SearchScreen;
import dev.strangequark.stashlight.serializer.Serializer;
import dev.strangequark.stashlight.util.Util;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.event.client.player.ClientPlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_638;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stashlight
implements ClientModInitializer {
    public static final String MOD_ID = "stashlight";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"stashlight");
    private Serializer serializer;
    private ContainerRepository repository;
    private static class_304 searchKey;
    public static final class_304.class_11900 STASHLIGHT;
    private int tickCounter = 0;
    @Nullable
    private class_2338 lastOpened;

    public void onInitializeClient() {
        Init.init();
        UseBlockCallback.EVENT.register(this::onBlockUsed);
        ClientPlayerBlockBreakEvents.AFTER.register(this::onBlockBreak);
        ScreenEvents.AFTER_INIT.register(this::onScreenInit);
        WorldRenderEvents.AFTER_ENTITIES.register(HighlightRenderer::render);
        searchKey = KeyBindingHelper.registerKeyBinding((class_304)new class_304("key.stashlight.search_menu", class_3675.class_307.field_1668, 325, STASHLIGHT));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (searchKey.method_1436()) {
                client.method_1507((class_437)new SearchScreen(this.repository));
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1687 == null || this.repository == null) {
                return;
            }
            ++this.tickCounter;
            if (this.tickCounter % 100 == 0) {
                this.repository.runCleanup(client.field_1687);
            }
            if (this.tickCounter % 3000 == 0) {
                this.repository.saveIfDirty();
                this.tickCounter = 0;
            }
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            this.serializer = new Serializer(Init.getFileName(), (class_7225.class_7874)handler.method_29091());
            this.repository = new ContainerRepository(this.serializer);
        });
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            if (this.repository != null) {
                this.repository.shutdown();
            }
            this.serializer = null;
            this.repository = null;
        });
    }

    private class_1269 onBlockUsed(class_1657 playerEntity, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
        class_2338 pos = blockHitResult.method_17777();
        class_2680 state = world.method_8320(pos);
        if (Util.isValidSearchableContainer(state)) {
            this.lastOpened = pos;
        }
        return class_1269.field_5811;
    }

    private void onBlockBreak(class_638 clientWorld, class_746 clientPlayerEntity, class_2338 blockPos, class_2680 blockState) {
        if (this.repository == null || !(blockState.method_26204() instanceof class_2237)) {
            return;
        }
        class_2338 canonicalPos = Util.getCanonicalPos((class_1937)clientWorld, blockPos);
        String dimension = Util.getDimensionName((class_1937)clientWorld);
        this.repository.remove(dimension, canonicalPos);
    }

    private void onScreenInit(class_310 client, class_437 screen, int w, int h) {
        if (client.field_1687 == null || screen instanceof class_481) {
            return;
        }
        if (screen instanceof class_465) {
            class_465 handled = (class_465)screen;
            class_1703 handler = handled.method_17577();
            ScreenEvents.remove((class_437)screen).register(closedScreen -> this.serializeContainer(client, handler));
        }
    }

    private void serializeContainer(class_310 client, class_1703 handler) {
        if (client.field_1687 == null || this.repository == null || this.lastOpened == null) {
            return;
        }
        String dimension = Util.getDimensionName((class_1937)client.field_1687);
        Set<class_2338> pair = Util.resolveContainerPositions((class_1937)client.field_1687, this.lastOpened);
        class_2338 canonicalPos = Util.getCanonicalPos((class_1937)client.field_1687, pair.iterator().next());
        class_2680 blockstate = client.field_1687.method_8320(canonicalPos);
        if (!Util.isValidSearchableContainer(blockstate)) {
            this.lastOpened = null;
            return;
        }
        class_2371 stacks = handler.method_7602();
        int containerSize = stacks.size() - 36;
        if (containerSize <= 0) {
            this.lastOpened = null;
            return;
        }
        this.repository.remove(dimension, canonicalPos);
        for (class_2338 p : pair) {
            this.repository.remove(dimension, p);
        }
        this.repository.update(dimension, canonicalPos, blockstate.method_26204().method_9518().getString(), containerSize, stacks.subList(0, containerSize));
        this.lastOpened = null;
    }

    static {
        STASHLIGHT = class_304.class_11900.method_74698((class_2960)class_2960.method_60655((String)MOD_ID, (String)MOD_ID));
    }
}

