/*
 * Decompiled with CFR 0.152.
 */
package dev.strangequark.stashlight.render;

import dev.strangequark.stashlight.model.HighlightPos;
import dev.strangequark.stashlight.model.IndexedItem;
import dev.strangequark.stashlight.render.HighlightEffect;
import dev.strangequark.stashlight.util.Util;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

public final class HighlightManager {
    private static final List<HighlightPos> highlights = new ArrayList<HighlightPos>();

    private HighlightManager() {
    }

    public static boolean tryHighlight(IndexedItem item) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || client.field_1687 == null) {
            return false;
        }
        String currentDim = Util.getDimensionName((class_1937)client.field_1687);
        if (!currentDim.equals(item.dimension())) {
            HighlightManager.notifyWrongDimension(client.field_1724);
            return false;
        }
        highlights.add(new HighlightPos(item.pos(), System.currentTimeMillis()));
        return true;
    }

    public static void removeExpired() {
        long now = System.currentTimeMillis();
        highlights.removeIf(h -> HighlightEffect.isExpired(now - h.startTimeMillis()));
    }

    public static List<HighlightPos> getActiveHighlights() {
        long now = System.currentTimeMillis();
        ArrayList<HighlightPos> active = new ArrayList<HighlightPos>();
        for (HighlightPos h : highlights) {
            if (HighlightEffect.isExpired(now - h.startTimeMillis())) continue;
            active.add(h);
        }
        return active;
    }

    private static void notifyWrongDimension(@NotNull class_746 player) {
        player.method_7353((class_2561)class_2561.method_43470((String)"Container is in a different dimension.").method_27692(class_124.field_1061), false);
    }
}

