/*
 * Decompiled with CFR 0.152.
 */
package dev.strangequark.stashlight.serializer;

import com.mojang.serialization.DynamicOps;
import dev.strangequark.stashlight.Stashlight;
import dev.strangequark.stashlight.model.ContainerSnapshot;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_6903;
import net.minecraft.class_7225;

public class Serializer {
    private final Path file;
    private final class_7225.class_7874 lookup;
    private static final String NBT_CONTAINER_NAME_KEY = "name";
    private static final String NBT_CONTAINER_CAPACITY_KEY = "capacity";
    private static final String NBT_STACK_LIST_KEY = "items";
    private static final String NBT_TIMESTAMP_KEY = "time";

    public Serializer(Path file, class_7225.class_7874 lookup) {
        this.file = file;
        this.lookup = lookup;
    }

    public Map<String, Map<class_2338, ContainerSnapshot>> read() {
        HashMap<String, Map<class_2338, ContainerSnapshot>> database = new HashMap<String, Map<class_2338, ContainerSnapshot>>();
        if (this.file == null || !Files.exists(this.file, new LinkOption[0])) {
            return database;
        }
        try {
            class_2487 root = class_2507.method_30613((Path)this.file, (class_2505)class_2505.method_53898());
            for (String dim : root.method_10541()) {
                root.method_10562(dim).ifPresent(dimTag -> {
                    HashMap posMap = new HashMap();
                    for (String key : dimTag.method_10541()) {
                        class_2338 pos = class_2338.method_10092((long)Long.parseLong(key));
                        dimTag.method_10562(key).ifPresent(snapNbt -> posMap.put(pos, this.deserializeSnapshot((class_2487)snapNbt)));
                    }
                    database.put(dim, posMap);
                });
            }
        }
        catch (Exception e) {
            Stashlight.LOGGER.error("Load failed", (Throwable)e);
        }
        return database;
    }

    public void write(Map<String, Map<class_2338, ContainerSnapshot>> database) {
        if (this.file == null) {
            return;
        }
        class_2487 root = new class_2487();
        database.forEach((dim, posMap) -> {
            class_2487 dimTag = new class_2487();
            posMap.forEach((pos, snap) -> dimTag.method_10566(String.valueOf(pos.method_10063()), (class_2520)this.serializeSnapshot((ContainerSnapshot)snap)));
            root.method_10566(dim, (class_2520)dimTag);
        });
        try {
            class_2507.method_30614((class_2487)root, (Path)this.file);
        }
        catch (Exception e) {
            Stashlight.LOGGER.error("Save failed", (Throwable)e);
        }
    }

    private class_2487 serializeSnapshot(ContainerSnapshot snap) {
        class_2487 nbt = new class_2487();
        nbt.method_10582(NBT_CONTAINER_NAME_KEY, snap.containerName());
        nbt.method_10569(NBT_CONTAINER_CAPACITY_KEY, snap.containerCapacity());
        nbt.method_10544(NBT_TIMESTAMP_KEY, snap.timestamp());
        class_2499 itemList = new class_2499();
        for (class_1799 stack : snap.items()) {
            itemList.add((Object)this.serializeStack(stack));
        }
        nbt.method_10566(NBT_STACK_LIST_KEY, (class_2520)itemList);
        return nbt;
    }

    private ContainerSnapshot deserializeSnapshot(class_2487 nbt) {
        String name = nbt.method_10558(NBT_CONTAINER_NAME_KEY).orElse("");
        int capacity = nbt.method_10550(NBT_CONTAINER_CAPACITY_KEY).orElse(0);
        long timestamp = nbt.method_10537(NBT_TIMESTAMP_KEY).orElse(0L);
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        nbt.method_10554(NBT_STACK_LIST_KEY).ifPresent(itemList -> {
            for (int i = 0; i < itemList.size(); ++i) {
                itemList.method_10602(i).map(this::deserializeStack).ifPresent(items::add);
            }
        });
        return new ContainerSnapshot(name, capacity, items, timestamp);
    }

    private class_2520 serializeStack(class_1799 stack) {
        try {
            class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)this.lookup);
            return (class_2520)class_1799.field_24671.encodeStart((DynamicOps)ops, (Object)stack).resultOrPartial(error -> Stashlight.LOGGER.warn("Failed to serialize item: {}", error)).orElse(new class_2487());
        }
        catch (Exception e) {
            Stashlight.LOGGER.warn("ItemStack serialization failed for {}", (Object)stack.method_7909(), (Object)e);
            return new class_2487();
        }
    }

    private class_1799 deserializeStack(class_2487 nbt) {
        try {
            class_6903 ops = class_6903.method_46632((DynamicOps)class_2509.field_11560, (class_7225.class_7874)this.lookup);
            return class_1799.field_24671.parse((DynamicOps)ops, (Object)nbt).resultOrPartial(error -> Stashlight.LOGGER.warn("Failed to deserialize item: {}", error)).orElse(class_1799.field_8037);
        }
        catch (Exception e) {
            Stashlight.LOGGER.warn("ItemStack deserialization failed", (Throwable)e);
            return class_1799.field_8037;
        }
    }
}

