/*
 * Decompiled with CFR 0.152.
 */
package com.futurevillagertradesvisible;

import com.futurevillagertradesvisible.FutureVillagerTradesVisible;
import com.futurevillagertradesvisible.ducks.VillagerDuck;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.slf4j.Logger;

public class LockedTradeData {
    private static final String TAG_LOCKED_OFFERS = "FVTvLockedOffers";
    private static final int MAX_LEVEL = 5;
    private final List<MerchantOffers> lockedOffers;

    public LockedTradeData(Villager villager) {
        this.lockedOffers = LockedTradeData.generateTrades(villager);
    }

    private LockedTradeData(List<MerchantOffers> offers) {
        this.lockedOffers = new ArrayList<MerchantOffers>(offers);
    }

    @Nullable
    public static LockedTradeData load(CompoundTag tag, RegistryAccess registryAccess) {
        if (!tag.contains(TAG_LOCKED_OFFERS)) {
            return null;
        }
        return MerchantOffers.CODEC.listOf().parse((DynamicOps)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag.get(TAG_LOCKED_OFFERS)).resultOrPartial(arg_0 -> ((Logger)FutureVillagerTradesVisible.LOGGER).error(arg_0)).map(LockedTradeData::new).orElse(null);
    }

    public void save(CompoundTag tag, RegistryAccess registryAccess) {
        MerchantOffers.CODEC.listOf().encodeStart((DynamicOps)registryAccess.createSerializationContext((DynamicOps)NbtOps.INSTANCE), this.lockedOffers).resultOrPartial(arg_0 -> ((Logger)FutureVillagerTradesVisible.LOGGER).error(arg_0)).ifPresent(nbt -> tag.put(TAG_LOCKED_OFFERS, nbt));
    }

    public MerchantOffers popTradeSet() {
        return this.lockedOffers.isEmpty() ? null : this.lockedOffers.removeFirst();
    }

    public MerchantOffers buildLockedOffers() {
        MerchantOffers result = new MerchantOffers();
        for (MerchantOffers listOffers : this.lockedOffers) {
            for (MerchantOffer offer : listOffers) {
                result.add((Object)offer);
            }
        }
        return result;
    }

    public void tick(Villager villager, Runnable popCallback) {
        int requiredSets = 5 - villager.getVillagerData().getLevel();
        while (requiredSets < this.lockedOffers.size()) {
            popCallback.run();
        }
        if (requiredSets > this.lockedOffers.size()) {
            FutureVillagerTradesVisible.LOGGER.error("Detected missing locked trade sets. Rebuilding locked offers");
            this.lockedOffers.clear();
            this.lockedOffers.addAll(LockedTradeData.generateTrades(villager));
        }
    }

    private static List<MerchantOffers> generateTrades(Villager villager) {
        MerchantOffers offers = villager.getOffers();
        VillagerData data = villager.getVillagerData();
        ArrayList<MerchantOffers> lockedOffers = new ArrayList<MerchantOffers>();
        int level = data.getLevel();
        while (level < 5) {
            villager.setVillagerData(data.setLevel(++level));
            int previousSize = offers.size();
            VillagerDuck.of(villager).visibleTraders$updateTrades();
            int newCount = offers.size() - previousSize;
            MerchantOffers newOffers = new MerchantOffers();
            for (int i = 0; i < newCount; ++i) {
                newOffers.add((Object)((MerchantOffer)offers.removeLast()));
            }
            lockedOffers.add(newOffers);
        }
        villager.setVillagerData(data);
        return lockedOffers;
    }
}

