/*
 * Decompiled with CFR 0.152.
 */
package com.futurevillagertradesvisible.mixin;

import com.futurevillagertradesvisible.Config;
import com.futurevillagertradesvisible.ducks.ClientSideMerchantDuck;
import com.futurevillagertradesvisible.ducks.MerchantMenuDuck;
import java.util.Collection;
import java.util.List;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffers;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MerchantMenu.class})
public abstract class MerchantMenuMixin
implements MerchantMenuDuck {
    @Shadow
    private int merchantLevel;
    @Shadow
    @Final
    private Merchant trader;
    @Unique
    private int fvtv$unlockedTradeCount = 0;

    @Shadow
    public abstract MerchantOffers getOffers();

    @Inject(method={"setMerchantLevel"}, at={@At(value="TAIL")})
    private void fvtv$readUnlockedTradeCountFromLevel(int level, CallbackInfo ci) {
        if (!Config.isEnabled()) {
            this.fvtv$unlockedTradeCount = 0;
            this.merchantLevel = level;
            this.fvtv$setClientUnlockedTrades(0);
            return;
        }
        this.fvtv$unlockedTradeCount = level >> 8;
        this.fvtv$setClientUnlockedTrades(this.fvtv$unlockedTradeCount);
        this.merchantLevel = level & 0xFF;
    }

    @Override
    public boolean visibleTraders$shouldAllowTrade(int index) {
        if (!Config.isEnabled()) {
            return true;
        }
        return this.fvtv$unlockedTradeCount == 0 || index <= this.fvtv$unlockedTradeCount - 1;
    }

    @Unique
    private void fvtv$setClientUnlockedTrades(int unlockedCount) {
        Merchant merchant = this.trader;
        if (!(merchant instanceof ClientSideMerchantDuck)) {
            return;
        }
        ClientSideMerchantDuck duck = (ClientSideMerchantDuck)merchant;
        if (unlockedCount <= 0) {
            duck.visibleTraders$setClientUnlockedTrades(null);
            return;
        }
        MerchantOffers offers = this.getOffers();
        if (offers.isEmpty()) {
            duck.visibleTraders$setClientUnlockedTrades(null);
            return;
        }
        int max = Math.min(unlockedCount, offers.size());
        List list = offers.subList(0, max);
        MerchantOffers unlocked = new MerchantOffers();
        unlocked.addAll((Collection)list);
        duck.visibleTraders$setClientUnlockedTrades(unlocked);
    }
}

