/*
 * Decompiled with CFR 0.152.
 */
package com.futurevillagertradesvisible.mixin;

import com.futurevillagertradesvisible.Config;
import com.futurevillagertradesvisible.ducks.MerchantMenuDuck;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MerchantScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.item.trading.MerchantOffers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MerchantScreen.class})
public abstract class MerchantScreenMixin
extends AbstractContainerScreen<MerchantMenu> {
    @Shadow
    int scrollOff;

    public MerchantScreenMixin(MerchantMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
    }

    @Inject(method={"render"}, at={@At(value="HEAD")})
    private void fvtv$updateButtonStates(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        AbstractContainerMenu abstractContainerMenu;
        if (!Config.isEnabled() || !((abstractContainerMenu = this.menu) instanceof MerchantMenuDuck)) {
            return;
        }
        MerchantMenuDuck duck = (MerchantMenuDuck)abstractContainerMenu;
        int buttonIndex = 0;
        for (Renderable renderable : this.renderables) {
            Button button;
            if (!(renderable instanceof Button) || (button = (Button)renderable).getWidth() != 88 || button.getHeight() != 20) continue;
            int tradeIndex = buttonIndex + this.scrollOff;
            button.active = duck.visibleTraders$shouldAllowTrade(tradeIndex);
            ++buttonIndex;
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private void fvtv$renderLockedTradesOverlay(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, CallbackInfo ci) {
        AbstractContainerMenu abstractContainerMenu;
        if (!Config.isEnabled() || !((abstractContainerMenu = this.menu) instanceof MerchantMenuDuck)) {
            return;
        }
        MerchantMenuDuck duck = (MerchantMenuDuck)abstractContainerMenu;
        MerchantOffers offers = ((MerchantMenu)this.menu).getOffers();
        int total = offers.size();
        if (total == 0) {
            return;
        }
        int startX = this.leftPos + 5;
        int startY = this.topPos + 16 + 1;
        for (int index = 0; index < total; ++index) {
            if (!this.fvtv$isRowVisible(index, total) || duck.visibleTraders$shouldAllowTrade(index)) continue;
            int row = index - this.scrollOff;
            int y = startY + row * 20;
            guiGraphics.fill(startX, y, startX + 88, y + 20, -2013265920);
        }
    }

    @Unique
    private boolean fvtv$isRowVisible(int index, int total) {
        return total <= 7 || index >= this.scrollOff && index < 7 + this.scrollOff;
    }
}

