/*
 * Decompiled with CFR 0.152.
 */
package com.futurevillagertradesvisible.mixin;

import com.futurevillagertradesvisible.Config;
import com.futurevillagertradesvisible.LockedTradeData;
import com.futurevillagertradesvisible.ducks.VillagerDuck;
import com.futurevillagertradesvisible.mixin.AbstractVillagerAccessor;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Villager.class})
public abstract class VillagerMixin
extends AbstractVillager
implements ReputationEventHandler,
VillagerDataHolder,
VillagerDuck {
    @Unique
    private LockedTradeData fvtv$lockedTradeData;

    @Shadow
    public abstract VillagerData getVillagerData();

    @Shadow
    protected abstract void updateTrades();

    public VillagerMixin(EntityType<? extends AbstractVillager> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="HEAD")})
    private void fvtv$saveLockedTradeData(CompoundTag tag, CallbackInfo ci) {
        if (!this.fvtv$isEnabled() || this.fvtv$lockedTradeData == null) {
            return;
        }
        this.fvtv$lockedTradeData.save(tag, this.registryAccess());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void fvtv$readLockedTradeData(CompoundTag tag, CallbackInfo ci) {
        if (!this.fvtv$isEnabled()) {
            return;
        }
        this.fvtv$lockedTradeData = LockedTradeData.load(tag, this.registryAccess());
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void fvtv$syncLockedTradeData(CallbackInfo ci) {
        if (!this.fvtv$isEnabled()) {
            this.fvtv$lockedTradeData = null;
            return;
        }
        if (this.fvtv$getOffersOrNull() == null) {
            this.fvtv$lockedTradeData = null;
            return;
        }
        if (this.fvtv$lockedTradeData != null) {
            this.fvtv$lockedTradeData.tick((Villager)this, this::fvtv$appendLockedOffer);
        }
    }

    @Inject(method={"updateTrades"}, at={@At(value="HEAD")}, cancellable=true)
    private void fvtv$preventAdditionalTradesOnRankIncrease(CallbackInfo ci) {
        if (!this.fvtv$isEnabled()) {
            return;
        }
        MerchantOffers offers = this.fvtv$getOffersOrNull();
        if (offers == null || offers.isEmpty()) {
            this.fvtv$lockedTradeData = null;
            return;
        }
        if (this.fvtv$appendLockedOffer()) {
            ci.cancel();
        }
    }

    @Unique
    private boolean fvtv$appendLockedOffer() {
        MerchantOffers offers = this.fvtv$getOffersOrNull();
        if (offers == null || this.fvtv$lockedTradeData == null) {
            return false;
        }
        MerchantOffers dismissedTrades = this.fvtv$lockedTradeData.popTradeSet();
        if (dismissedTrades == null) {
            return false;
        }
        offers.addAll((Collection)dismissedTrades);
        return true;
    }

    @Override
    public void visibleTraders$setLockedTradeData(LockedTradeData data) {
        if (!this.fvtv$isEnabled()) {
            return;
        }
        this.fvtv$lockedTradeData = data;
    }

    @Override
    public Optional<LockedTradeData> visibleTraders$getLockedTradeData() {
        return this.fvtv$isEnabled() ? Optional.ofNullable(this.fvtv$lockedTradeData) : Optional.empty();
    }

    @Override
    public void visibleTrades$regenerateTrades() {
        if (!this.fvtv$isEnabled() || this.level().isClientSide) {
            return;
        }
        this.fvtv$lockedTradeData = new LockedTradeData((Villager)this);
    }

    @Override
    public int visibleTraders$getShiftedLevel() {
        int level = this.getVillagerData().getLevel();
        if (!this.fvtv$isEnabled()) {
            return level;
        }
        MerchantOffers offers = this.fvtv$getOffersOrNull();
        return offers == null ? level : level | offers.size() << 8;
    }

    @Override
    public MerchantOffers visibleTraders$getCombinedOffers() {
        MerchantOffers combined = new MerchantOffers();
        MerchantOffers offers = this.fvtv$getOffersOrNull();
        if (offers != null) {
            combined.addAll((Collection)offers);
        }
        if (!this.fvtv$isEnabled()) {
            return combined;
        }
        if (!this.level().isClientSide) {
            if (this.fvtv$lockedTradeData == null) {
                this.visibleTrades$regenerateTrades();
            }
            if (this.fvtv$lockedTradeData != null) {
                combined.addAll((Collection)this.fvtv$lockedTradeData.buildLockedOffers());
            }
        }
        return combined;
    }

    @Override
    public void visibleTraders$updateTrades() {
        if (this.fvtv$isEnabled() && this.level() instanceof ServerLevel) {
            this.updateTrades();
        }
    }

    @Unique
    private MerchantOffers fvtv$getOffersOrNull() {
        return ((AbstractVillagerAccessor)((Object)this)).fvtv$getOffers();
    }

    @Unique
    private boolean fvtv$isEnabled() {
        return Config.isEnabled();
    }
}

