/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.api.event;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import padej.soup.api.event.EventHandler;
import padej.soup.api.event.events.Event;
import padej.soup.api.event.events.EventStoppable;
import padej.soup.api.event.types.Priority;
import padej.soup.api.feature.module.exception.ModuleException;
import padej.soup.api.system.logger.implement.ConsoleLogger;
import padej.soup.api.system.logger.implement.MinecraftLogger;
import padej.soup.base.util.logger.LoggerUtil;

public final class EventManager {
    private static final Map<Class<? extends Event>, List<MethodData>> REGISTRY_MAP = new HashMap<Class<? extends Event>, List<MethodData>>();

    public void register(Object object) {
        for (Method method : object.getClass().getDeclaredMethods()) {
            if (EventManager.isMethodBad(method)) continue;
            this.register(method, object);
        }
    }

    public void unregister(Object object) {
        for (List<MethodData> dataList : REGISTRY_MAP.values()) {
            dataList.removeIf(data -> data.source().equals(object));
        }
        EventManager.cleanMap(true);
    }

    private void register(Method method, Object object) {
        Class<?> indexClass = method.getParameterTypes()[0];
        final MethodData data = new MethodData(object, method, method.getAnnotation(EventHandler.class).value());
        if (!data.target().isAccessible()) {
            data.target().setAccessible(true);
        }
        if (REGISTRY_MAP.containsKey(indexClass)) {
            if (!REGISTRY_MAP.get(indexClass).contains(data)) {
                REGISTRY_MAP.get(indexClass).add(data);
                EventManager.sortListValue(indexClass);
            }
        } else {
            REGISTRY_MAP.put(indexClass, (List<MethodData>)new CopyOnWriteArrayList<MethodData>(this){
                private static final long serialVersionUID = 100L;
                final /* synthetic */ EventManager this$0;
                {
                    this.this$0 = this$0;
                    this.add(data);
                }
            });
        }
    }

    public static void cleanMap(boolean onlyEmptyEntries) {
        Iterator<Map.Entry<Class<? extends Event>, List<MethodData>>> mapIterator = REGISTRY_MAP.entrySet().iterator();
        while (mapIterator.hasNext()) {
            if (onlyEmptyEntries && !mapIterator.next().getValue().isEmpty()) continue;
            mapIterator.remove();
        }
    }

    private static void sortListValue(Class<? extends Event> indexClass) {
        CopyOnWriteArrayList<MethodData> sortedList = new CopyOnWriteArrayList<MethodData>();
        for (byte priority : Priority.VALUE_ARRAY) {
            for (MethodData data : REGISTRY_MAP.get(indexClass)) {
                if (data.priority() != priority) continue;
                sortedList.add(data);
            }
        }
        REGISTRY_MAP.put(indexClass, sortedList);
    }

    private static boolean isMethodBad(Method method) {
        return method.getParameterTypes().length != 1 || !method.isAnnotationPresent(EventHandler.class);
    }

    public static Event callEvent(Event event) {
        block6: {
            List<MethodData> dataList = REGISTRY_MAP.get(event.getClass());
            if (dataList == null) break block6;
            if (event instanceof EventStoppable) {
                EventStoppable stoppable = (EventStoppable)event;
                for (MethodData data : dataList) {
                    EventManager.invoke(data, event);
                    if (!stoppable.isStopped()) continue;
                    break;
                }
            } else {
                for (MethodData data : dataList) {
                    try {
                        EventManager.invoke(data, event);
                    }
                    catch (Exception e) {
                        LoggerUtil.error((Object)"Failed to invoke event handler", e);
                    }
                }
            }
        }
        return event;
    }

    private static void invoke(MethodData data, Event argument) {
        try {
            data.target().invoke(data.source(), argument);
        }
        catch (IllegalAccessException e) {
            ConsoleLogger consoleLogger = new ConsoleLogger();
            Object errorMessage = "Illegal access to method. ";
            errorMessage = (String)errorMessage + "Method: " + data.target().getName() + ", ";
            errorMessage = (String)errorMessage + "Argument: " + argument.toString() + ", ";
            errorMessage = (String)errorMessage + "Log: " + String.valueOf(e.fillInStackTrace());
            consoleLogger.log(errorMessage);
        }
        catch (IllegalArgumentException e) {
            ConsoleLogger consoleLogger = new ConsoleLogger();
            Object errorMessage = "Illegal arguments passed to method. ";
            errorMessage = (String)errorMessage + "Method: " + data.target().getName() + ", ";
            errorMessage = (String)errorMessage + "Argument: " + argument.toString() + ", ";
            errorMessage = (String)errorMessage + "Log: " + String.valueOf(e.getCause());
            consoleLogger.log(errorMessage);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            ConsoleLogger consoleLogger = new ConsoleLogger();
            MinecraftLogger minecraftLogger = new MinecraftLogger();
            if (cause instanceof ModuleException) {
                ModuleException moduleException = (ModuleException)cause;
                minecraftLogger.minecraftLog(new class_2561[]{class_2561.method_43470((String)("[" + moduleException.getModuleName() + "] " + String.valueOf(class_124.field_1061) + moduleException.getMessage()))});
            }
            Object errorMessage = "Exception occurred within invoked method. ";
            errorMessage = (String)errorMessage + "Method: " + data.target().getName() + ", ";
            errorMessage = (String)errorMessage + "Argument: " + argument.toString() + ", ";
            errorMessage = (String)errorMessage + "Log: " + String.valueOf(e.getCause());
            consoleLogger.log(errorMessage);
        }
    }

    private record MethodData(Object source, Method target, byte priority) {
    }
}

