/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.api.feature.draggable;

import net.minecraft.class_332;
import padej.soup.api.feature.draggable.Draggable;
import padej.soup.api.feature.module.Module;
import padej.soup.api.system.animation.Animation;
import padej.soup.api.system.animation.Direction;
import padej.soup.api.system.animation.implement.DecelerateAnimation;
import padej.soup.base.QuickImports;
import padej.soup.base.QuickLogger;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.entity.PlayerIntersectionUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.render.Render2DUtil;
import padej.soup.core.Main;
import padej.soup.implement.events.container.SetScreenEvent;
import padej.soup.implement.events.packet.PacketEvent;

public abstract class AbstractDraggable
implements Draggable,
QuickImports,
QuickLogger {
    private String name;
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean dragging;
    private boolean canDrag;
    private int dragX;
    private int dragY;
    public final Animation scaleAnimation = new DecelerateAnimation().setValue(1.0).setMs(200);

    public AbstractDraggable(String name, int x, int y, int width, int height, boolean canDrag) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.canDrag = canDrag;
    }

    @Override
    public boolean visible() {
        return true;
    }

    @Override
    public void tick() {
    }

    @Override
    public void packet(PacketEvent e) {
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        int windowWidth = window.method_4486();
        int windowHeight = window.method_4502();
        int radius = 3;
        if (this.dragging) {
            float mouseDragX = mouseX + this.dragX;
            float mouseDragY = mouseY + this.dragY;
            this.x = (int)Math.max(0.0f, Math.min(mouseDragX, (float)(windowWidth - this.width)));
            this.y = (int)Math.max(0.0f, Math.min(mouseDragY, (float)(windowHeight - this.height)));
            for (AbstractDraggable drag : Main.getInstance().getDraggableRepository().draggable()) {
                if (!this.canDraw(drag) || !drag.canDrag || drag == this) continue;
                int x1 = drag.x + drag.width + radius;
                int x2 = drag.x - this.width - radius;
                int y1 = drag.y + drag.height + radius;
                int y2 = drag.y - this.height - radius;
                int y3 = drag.y;
                if (Math.abs((float)x1 - mouseDragX) <= (float)radius) {
                    this.drawRect((float)x1 - 1.5f, 0.0f, 1.0f, windowHeight);
                    this.x = x1;
                }
                if (Math.abs((float)x2 - mouseDragX) <= (float)radius) {
                    this.drawRect(x2 + this.width + 1, 0.0f, 1.0f, windowHeight);
                    this.x = x2;
                }
                if (Math.abs((float)y1 - mouseDragY) <= (float)radius) {
                    this.drawRect(0.0f, (float)y1 - 1.5f, windowWidth, 1.0f);
                    this.y = y1;
                }
                if (Math.abs((float)y2 - mouseDragY) <= (float)radius) {
                    this.drawRect(0.0f, y2 + this.height + 1, windowWidth, 1.0f);
                    this.y = y2;
                }
                if (!(Math.abs((float)y3 - mouseDragY) <= (float)radius)) continue;
                this.drawRect(0.0f, (float)y3 - 1.5f, windowWidth, 1.0f);
                this.y = y3;
            }
            if (Math.abs(mouseDragX - (float)(windowWidth - this.width) / 2.0f) <= (float)radius) {
                this.drawRect((float)windowWidth / 2.0f - 0.5f, 0.0f, 1.0f, windowHeight);
                this.x = (windowWidth - this.width) / 2;
            }
            if (Math.abs(mouseDragY - (float)(windowHeight - this.height) / 2.0f) <= (float)radius) {
                this.drawRect(0.0f, (float)windowHeight / 2.0f - 0.5f, windowWidth, 1.0f);
                this.y = (windowHeight - this.height) / 2;
            }
        }
    }

    @Override
    public void setScreen(SetScreenEvent e) {
        if (PlayerIntersectionUtil.isChat(e.getScreen())) {
            this.dragging = false;
        }
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (MathUtil.isHovered(mouseX, mouseY, this.x, this.y, this.width, this.height) && button == 0 && this.canDrag) {
            this.dragging = true;
            this.dragX = this.x - (int)mouseX;
            this.dragY = this.y - (int)mouseY;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (this.dragging) {
            this.dragging = false;
            this.saveDraggablePositions();
            return true;
        }
        return false;
    }

    private void saveDraggablePositions() {
        try {
            Main.getInstance().getConfigManager().scheduleSave();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public abstract void drawDraggable(class_332 var1);

    public void drawRect(float x, float y, float width, float height) {
        Render2DUtil.drawQuad(x, y, width, height, ColorUtil.getText(0.5f));
    }

    public void stopAnimation() {
        this.scaleAnimation.setDirection(Direction.BACKWARDS);
    }

    public void startAnimation() {
        this.scaleAnimation.setDirection(Direction.FORWARDS);
    }

    public void validPosition() {
    }

    public boolean canDraw(AbstractDraggable draggable) {
        Object module = Main.getInstance().getModuleProvider().get(draggable.getName());
        return module != null && ((Module)module).isEnabled() && this.visible();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setDragging(boolean dragging) {
        this.dragging = dragging;
    }

    public void setCanDrag(boolean canDrag) {
        this.canDrag = canDrag;
    }

    public void setDragX(int dragX) {
        this.dragX = dragX;
    }

    public void setDragY(int dragY) {
        this.dragY = dragY;
    }

    public String getName() {
        return this.name;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    public boolean isCanDrag() {
        return this.canDrag;
    }

    public int getDragX() {
        return this.dragX;
    }

    public int getDragY() {
        return this.dragY;
    }

    public Animation getScaleAnimation() {
        return this.scaleAnimation;
    }
}

