/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.api.feature.module.setting.implement;

import java.util.function.Supplier;
import padej.soup.api.feature.module.setting.Setting;
import padej.soup.base.util.math.MathUtil;

public class ColorSetting
extends Setting {
    private static final int[] DEFAULT_PRESETS = new int[]{-6969946, -1499549, -1618884, -1671646, -932849, -13710223, -15024996, -13273872, -13330213, -6596170, -5930259, -8943479, -4581296, -4571856, -4561637, -4088564, -14310566, -15362435, -13934912, -13993296, -8566895, -8034114, -10853018, -7597508, -7590364, -7582700, -7244278, -14910908, -15699618, -14661744, -14721915, -10602899, -10202993};
    private float hue = 0.0f;
    private float saturation = 1.0f;
    private float brightness = 1.0f;
    private float alpha = 1.0f;
    private int[] presets = DEFAULT_PRESETS;
    private Integer defaultColor;

    public ColorSetting(String name, String description) {
        super(name, description);
    }

    public ColorSetting value(int value) {
        if (this.defaultColor == null) {
            this.defaultColor = value;
        }
        this.setColorInternal(value);
        return this;
    }

    public ColorSetting presets(int ... presets) {
        this.presets = presets;
        return this;
    }

    public ColorSetting visible(Supplier<Boolean> visible) {
        this.setVisible(visible);
        return this;
    }

    public int getColor() {
        return this.getColorWithAlpha() & 0xFFFFFF | Math.round(this.alpha * 255.0f) << 24;
    }

    public int getColorWithAlpha() {
        return ColorSetting.HSBtoRGB(this.hue, this.saturation, this.brightness);
    }

    public ColorSetting setColor(int color) {
        if (this.defaultColor == null) {
            this.defaultColor = color;
        }
        this.setColorInternal(color);
        return this;
    }

    private void setColorInternal(int color) {
        float[] hsb = ColorSetting.RGBtoHSB(ColorSetting.getRed(color), ColorSetting.getGreen(color), ColorSetting.getBlue(color));
        this.hue = hsb[0];
        this.saturation = hsb[1];
        this.brightness = hsb[2];
        this.alpha = (float)MathUtil.getAlpha(color) / 255.0f;
        this.notifyChange();
    }

    @Override
    public boolean isModified() {
        if (this.defaultColor == null) {
            return false;
        }
        return this.getColor() != this.defaultColor.intValue();
    }

    @Override
    public void reset() {
        if (this.defaultColor != null) {
            this.setColorInternal(this.defaultColor);
        }
    }

    private static int getRed(int color) {
        return color >> 16 & 0xFF;
    }

    private static int getGreen(int color) {
        return color >> 8 & 0xFF;
    }

    private static int getBlue(int color) {
        return color & 0xFF;
    }

    private static float[] RGBtoHSB(int r, int g, int b) {
        float[] hsb = new float[3];
        float rf = (float)r / 255.0f;
        float gf = (float)g / 255.0f;
        float bf = (float)b / 255.0f;
        float max = Math.max(rf, Math.max(gf, bf));
        float min = Math.min(rf, Math.min(gf, bf));
        float delta = max - min;
        hsb[2] = max;
        hsb[1] = max != 0.0f ? delta / max : 0.0f;
        if (delta == 0.0f) {
            hsb[0] = 0.0f;
        } else {
            hsb[0] = rf == max ? (gf - bf) / delta : (gf == max ? 2.0f + (bf - rf) / delta : 4.0f + (rf - gf) / delta);
            hsb[0] = hsb[0] / 6.0f;
            if (hsb[0] < 0.0f) {
                hsb[0] = hsb[0] + 1.0f;
            }
        }
        return hsb;
    }

    private static int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g << 8 | b;
    }

    public float getHue() {
        return this.hue;
    }

    public float getSaturation() {
        return this.saturation;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public int[] getPresets() {
        return this.presets;
    }

    public Integer getDefaultColor() {
        return this.defaultColor;
    }

    public void setHue(float hue) {
        this.hue = hue;
    }

    public void setSaturation(float saturation) {
        this.saturation = saturation;
    }

    public void setBrightness(float brightness) {
        this.brightness = brightness;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setPresets(int[] presets) {
        this.presets = presets;
    }

    public void setDefaultColor(Integer defaultColor) {
        this.defaultColor = defaultColor;
    }
}

