/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.api.repository.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;
import padej.soup.api.feature.draggable.AbstractDraggable;
import padej.soup.api.feature.draggable.DraggableRepository;
import padej.soup.api.feature.module.Module;
import padej.soup.api.feature.module.ModuleRepository;
import padej.soup.api.feature.module.setting.Setting;
import padej.soup.api.feature.module.setting.implement.BindSetting;
import padej.soup.api.feature.module.setting.implement.BooleanSetting;
import padej.soup.api.feature.module.setting.implement.ColorSetting;
import padej.soup.api.feature.module.setting.implement.GroupSetting;
import padej.soup.api.feature.module.setting.implement.MultiColorSetting;
import padej.soup.api.feature.module.setting.implement.MultiSelectSetting;
import padej.soup.api.feature.module.setting.implement.SelectSetting;
import padej.soup.api.feature.module.setting.implement.TextSetting;
import padej.soup.api.feature.module.setting.implement.ValueSetting;
import padej.soup.base.util.logger.LoggerUtil;
import padej.soup.implement.features.modules.client.KeyBind;

public class ConfigManager {
    public static final String CONFIG_FOLDER_NAME = "SoupAPI";
    public static final File MAIN_FOLDER = new File(class_310.method_1551().field_1697, "SoupAPI");
    public static final File CONFIGS_FOLDER = new File(MAIN_FOLDER, "configs");
    public static final File TEMP_FOLDER = new File(MAIN_FOLDER, "temp");
    public static final File FILES_FOLDER = new File(class_310.method_1551().field_1697, "soupapi/files");
    private File currentConfig = null;
    private static boolean firstLaunch = false;
    private final ModuleRepository moduleRepository;
    private DraggableRepository draggableRepository;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final ScheduledExecutorService autoSaveScheduler = Executors.newSingleThreadScheduledExecutor();
    private volatile long lastChangeTime = 0L;
    private volatile boolean isLoadingConfig = false;
    private static final long SAVE_DELAY_MS = 1000L;

    public ConfigManager(ModuleRepository moduleRepository) {
        this.moduleRepository = moduleRepository;
        firstLaunch = !MAIN_FOLDER.exists();
        this.createDirs(MAIN_FOLDER, CONFIGS_FOLDER, TEMP_FOLDER);
        Setting.setGlobalChangeListener(setting -> {
            if (!this.isLoadingConfig) {
                this.scheduleSave();
            }
        });
        Module.setGlobalStateChangeListener(module -> {
            if (!this.isLoadingConfig) {
                this.scheduleSave();
            }
        });
        this.autoSaveScheduler.scheduleWithFixedDelay(() -> {
            long timeSinceLastChange;
            if (!this.isLoadingConfig && this.lastChangeTime > 0L && (timeSinceLastChange = System.currentTimeMillis() - this.lastChangeTime) >= 1000L) {
                try {
                    this.saveCurrentActiveConfig();
                    this.lastChangeTime = 0L;
                }
                catch (Exception e) {
                    LoggerUtil.error((Object)"Failed to auto-save config", e);
                }
            }
        }, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    private void createDirs(File ... dirs) {
        for (File dir : dirs) {
            if (dir.exists()) continue;
            dir.mkdirs();
        }
    }

    public void setDraggableRepository(DraggableRepository draggableRepository) {
        this.draggableRepository = draggableRepository;
    }

    @NotNull
    public static String getConfigDate(String name) {
        File file = new File(CONFIGS_FOLDER, name + ".soup");
        if (!file.exists()) {
            return "none";
        }
        return new SimpleDateFormat("dd MMM yyyy HH:mm").format(new Date(file.lastModified()));
    }

    public void scheduleSave() {
        this.lastChangeTime = System.currentTimeMillis();
    }

    private void saveCurrentActiveConfig() {
        if (this.currentConfig != null && this.currentConfig.exists()) {
            this.save(this.currentConfig);
            LoggerUtil.info("Auto-saved config: " + this.currentConfig.getName());
        }
    }

    public void load(String name) {
        File file = new File(CONFIGS_FOLDER, name + ".soup");
        if (!file.exists()) {
            LoggerUtil.warn("Config " + name + " does not exist!");
            return;
        }
        if (this.currentConfig != null) {
            this.save(this.currentConfig);
        }
        this.isLoadingConfig = true;
        try {
            this.onUnload();
            this.load(file);
            this.onLoad();
        }
        finally {
            this.isLoadingConfig = false;
        }
    }

    public void loadBinds(String name) {
        File file = new File(CONFIGS_FOLDER, name + ".soup");
        if (!file.exists()) {
            LoggerUtil.warn("Config " + name + " does not exist!");
            return;
        }
        if (this.currentConfig != null) {
            this.save(this.currentConfig);
        }
        this.loadBinds(file);
        this.saveCurrentConfig();
    }

    private void loadBinds(@NotNull File config) {
        if (!config.exists()) {
            this.save(config);
        }
        try (FileReader reader = new FileReader(config, StandardCharsets.UTF_8);){
            JsonObject rootObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonArray modules = rootObject.getAsJsonArray("Modules");
            if (modules != null) {
                for (JsonElement element : modules) {
                    this.parseBinds(element.getAsJsonObject());
                }
            }
            LoggerUtil.info("Loaded binds from config: " + config.getName());
        }
        catch (IOException e) {
            LoggerUtil.error((Object)"Failed to load binds", e);
        }
    }

    public void loadModuleOnly(String name, Module module) {
        File file = new File(CONFIGS_FOLDER, name + ".soup");
        if (!file.exists()) {
            LoggerUtil.warn("Config " + name + " does not exist!");
            return;
        }
        if (module.isEnabled()) {
            module.setState(false);
        }
        this.loadModuleOnly(file, module);
        if (module.isEnabled()) {
            module.setState(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(@NotNull File config) {
        if (!config.exists()) {
            this.save(config);
        }
        this.isLoadingConfig = true;
        try {
            try (FileReader reader = new FileReader(config, StandardCharsets.UTF_8);){
                JsonArray draggables;
                JsonObject rootObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                JsonArray modules = rootObject.getAsJsonArray("Modules");
                if (modules != null) {
                    for (JsonElement element : modules) {
                        this.parseModule(element.getAsJsonObject());
                    }
                }
                if (this.draggableRepository != null && (draggables = rootObject.getAsJsonArray("Draggables")) != null) {
                    for (JsonElement element : draggables) {
                        this.parseDraggable(element.getAsJsonObject());
                    }
                }
                LoggerUtil.info("Loaded config: " + config.getName());
            }
            catch (Exception e) {
                LoggerUtil.error((Object)"Failed to load config", e);
            }
            this.currentConfig = config;
            this.saveCurrentConfig();
            this.onLoad();
        }
        finally {
            this.isLoadingConfig = false;
        }
    }

    private void loadModuleOnly(@NotNull File config, Module module) {
        try (FileReader reader = new FileReader(config, StandardCharsets.UTF_8);){
            JsonObject rootObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonArray modules = rootObject.getAsJsonArray("Modules");
            if (modules != null) {
                for (JsonElement element : modules) {
                    JsonObject moduleObject = element.getAsJsonObject();
                    Module loadedModule = this.moduleRepository.modules().stream().filter(m -> moduleObject.has(m.getIdentifier())).findFirst().orElse(null);
                    if (loadedModule == null || !Objects.equals(module.getIdentifier(), loadedModule.getIdentifier())) continue;
                    this.parseModule(moduleObject);
                }
            }
            LoggerUtil.info("Loaded module " + module.getIdentifier() + " from " + config.getName());
        }
        catch (IOException e) {
            LoggerUtil.error((Object)"Failed to load module", e);
        }
    }

    public void save(String name) {
        File file = new File(CONFIGS_FOLDER, name + ".soup");
        if (file.exists()) {
            file.delete();
        }
        this.save(file);
    }

    public void save(@NotNull File config) {
        try {
            if (!config.exists()) {
                config.createNewFile();
            }
            JsonObject rootObject = new JsonObject();
            rootObject.add("Modules", (JsonElement)this.getModuleArray());
            if (this.draggableRepository != null) {
                rootObject.add("Draggables", (JsonElement)this.getDraggableArray());
            }
            try (FileWriter writer = new FileWriter(config, StandardCharsets.UTF_8);){
                this.gson.toJson((JsonElement)rootObject, (Appendable)writer);
            }
        }
        catch (IOException e) {
            LoggerUtil.error((Object)"Failed to save config", e);
        }
    }

    private void parseModule(@NotNull JsonObject object) throws NullPointerException {
        Module module = this.moduleRepository.modules().stream().filter(m -> object.has(m.getIdentifier())).findFirst().orElse(null);
        if (module == null) {
            return;
        }
        JsonObject moduleObject = object.getAsJsonObject(module.getIdentifier());
        if (moduleObject.has("enabled")) {
            module.setStateSilent(moduleObject.get("enabled").getAsBoolean());
        }
        if (moduleObject.has("bind")) {
            module.setKey(moduleObject.get("bind").getAsInt());
        }
        for (Setting setting : module.settings()) {
            try {
                this.loadSetting(setting, moduleObject);
            }
            catch (Exception e) {
                LoggerUtil.error((Object)("[SoupAPI] Module: " + module.getIdentifier() + " Setting: " + setting.getNameKey() + " Error: "), e);
            }
        }
    }

    private void parseDraggable(@NotNull JsonObject object) throws NullPointerException {
        AbstractDraggable draggable = this.draggableRepository.draggable().stream().filter(d -> object.has(d.getName())).findFirst().orElse(null);
        if (draggable == null) {
            return;
        }
        JsonObject draggableObject = object.getAsJsonObject(draggable.getName());
        if (draggableObject.has("x")) {
            draggable.setX(draggableObject.get("x").getAsInt());
        }
        if (draggableObject.has("y")) {
            draggable.setY(draggableObject.get("y").getAsInt());
        }
    }

    private void parseBinds(@NotNull JsonObject object) throws NullPointerException {
        Module module = this.moduleRepository.modules().stream().filter(m -> object.has(m.getName())).findFirst().orElse(null);
        if (module == null) {
            return;
        }
        JsonObject moduleObject = object.getAsJsonObject(module.getIdentifier());
        if (moduleObject.has("bind")) {
            module.setKey(moduleObject.get("bind").getAsInt());
        }
    }

    private void loadSetting(Setting setting, JsonObject moduleObject) {
        block10: {
            JsonElement element;
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block13: {
                                block12: {
                                    block11: {
                                        block9: {
                                            if (!setting.isSaveToConfig()) {
                                                return;
                                            }
                                            String key = setting.getNameKey();
                                            if (!moduleObject.has(key)) {
                                                return;
                                            }
                                            element = moduleObject.get(key);
                                            if (!(setting instanceof BooleanSetting)) break block9;
                                            ((BooleanSetting)setting).setValue(element.getAsBoolean());
                                            break block10;
                                        }
                                        if (!(setting instanceof ValueSetting)) break block11;
                                        ((ValueSetting)setting).setValue(element.getAsFloat());
                                        break block10;
                                    }
                                    if (!(setting instanceof TextSetting)) break block12;
                                    String value = element.getAsString();
                                    value = value.replace("%%", " ").replace("++", "/");
                                    ((TextSetting)setting).setText(value);
                                    break block10;
                                }
                                if (!(setting instanceof BindSetting)) break block13;
                                ((BindSetting)setting).setKey(element.getAsInt());
                                break block10;
                            }
                            if (!(setting instanceof ColorSetting)) break block14;
                            ((ColorSetting)setting).setColor(element.getAsInt());
                            break block10;
                        }
                        if (!(setting instanceof SelectSetting)) break block15;
                        ((SelectSetting)setting).setSelected(element.getAsString());
                        break block10;
                    }
                    if (!(setting instanceof MultiSelectSetting)) break block16;
                    String value = element.getAsString();
                    ArrayList<String> selected = new ArrayList<String>(Arrays.asList(value.split(",")));
                    selected.removeIf(s -> !((MultiSelectSetting)setting).getList().contains(s));
                    ((MultiSelectSetting)setting).setSelected(selected);
                    break block10;
                }
                if (!(setting instanceof MultiColorSetting)) break block17;
                MultiColorSetting multiColor = (MultiColorSetting)setting;
                if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
                    int oldColor = element.getAsInt();
                    if (multiColor.getColor1() != null) {
                        multiColor.getColor1().setColor(oldColor);
                    }
                    return;
                }
                JsonObject colorObject = element.getAsJsonObject();
                if (colorObject.has("selectedColorIndex")) {
                    multiColor.setSelectedColorIndex(colorObject.get("selectedColorIndex").getAsInt());
                }
                if (!colorObject.has("colors")) break block10;
                JsonArray colorsArray = colorObject.getAsJsonArray("colors");
                List<ColorSetting> colorSettings = multiColor.getAllColors();
                for (int i = 0; i < Math.min(colorsArray.size(), colorSettings.size()); ++i) {
                    colorSettings.get(i).setColor(colorsArray.get(i).getAsInt());
                }
                break block10;
            }
            if (setting instanceof GroupSetting) {
                JsonObject groupObject = element.getAsJsonObject();
                GroupSetting group = (GroupSetting)setting;
                if (groupObject.has("state")) {
                    group.setValue(groupObject.get("state").getAsBoolean());
                }
                for (Setting subSetting : group.getSubSettings()) {
                    this.loadSetting(subSetting, groupObject);
                }
            }
        }
    }

    @NotNull
    private JsonArray getModuleArray() {
        JsonArray modulesArray = new JsonArray();
        for (Module module : this.moduleRepository.modules()) {
            modulesArray.add((JsonElement)this.getModuleObject(module));
        }
        return modulesArray;
    }

    @NotNull
    private JsonArray getDraggableArray() {
        JsonArray draggablesArray = new JsonArray();
        for (AbstractDraggable draggable : this.draggableRepository.draggable()) {
            draggablesArray.add((JsonElement)this.getDraggableObject(draggable));
        }
        return draggablesArray;
    }

    @NotNull
    private JsonObject getDraggableObject(@NotNull AbstractDraggable draggable) {
        JsonObject draggableContainer = new JsonObject();
        JsonObject draggableData = new JsonObject();
        draggableData.addProperty("x", (Number)draggable.getX());
        draggableData.addProperty("y", (Number)draggable.getY());
        draggableContainer.add(draggable.getName(), (JsonElement)draggableData);
        return draggableContainer;
    }

    @NotNull
    private JsonObject getModuleObject(@NotNull Module module) {
        JsonObject moduleContainer = new JsonObject();
        JsonObject moduleData = new JsonObject();
        moduleData.addProperty("enabled", Boolean.valueOf(module.isState()));
        moduleData.addProperty("bind", (Number)module.getKey());
        for (Setting setting : module.settings()) {
            this.saveSetting(setting, moduleData);
        }
        moduleContainer.add(module.getIdentifier(), (JsonElement)moduleData);
        return moduleContainer;
    }

    private void saveSetting(Setting setting, JsonObject moduleData) {
        if (!setting.isSaveToConfig()) {
            return;
        }
        String key = setting.getNameKey();
        if (setting instanceof BooleanSetting) {
            moduleData.addProperty(key, Boolean.valueOf(((BooleanSetting)setting).isValue()));
        } else if (setting instanceof ValueSetting) {
            moduleData.addProperty(key, (Number)Float.valueOf(((ValueSetting)setting).getValue()));
        } else if (setting instanceof TextSetting) {
            String value = ((TextSetting)setting).getText();
            value = value.replace(" ", "%%").replace("/", "++");
            moduleData.addProperty(key, value);
        } else if (setting instanceof BindSetting) {
            moduleData.addProperty(key, (Number)((BindSetting)setting).getKey());
        } else if (setting instanceof ColorSetting) {
            moduleData.addProperty(key, (Number)((ColorSetting)setting).getColor());
        } else if (setting instanceof SelectSetting) {
            moduleData.addProperty(key, ((SelectSetting)setting).getSelected());
        } else if (setting instanceof MultiSelectSetting) {
            List<String> selected = ((MultiSelectSetting)setting).getSelected();
            moduleData.addProperty(key, String.join((CharSequence)",", selected));
        } else if (setting instanceof MultiColorSetting) {
            MultiColorSetting multiColor = (MultiColorSetting)setting;
            JsonObject colorObject = new JsonObject();
            colorObject.addProperty("selectedColorIndex", (Number)multiColor.getSelectedColorIndex());
            JsonArray colorsArray = new JsonArray();
            for (ColorSetting color : multiColor.getAllColors()) {
                colorsArray.add((Number)color.getColor());
            }
            colorObject.add("colors", (JsonElement)colorsArray);
            moduleData.add(key, (JsonElement)colorObject);
        } else if (setting instanceof GroupSetting) {
            GroupSetting group = (GroupSetting)setting;
            JsonObject groupObject = new JsonObject();
            groupObject.addProperty("state", Boolean.valueOf(group.isValue()));
            for (Setting subSetting : group.getSubSettings()) {
                this.saveSetting(subSetting, groupObject);
            }
            moduleData.add(key, (JsonElement)groupObject);
        }
    }

    public void delete(@NotNull File file) {
        file.delete();
    }

    public void delete(String name) {
        File file = new File(CONFIGS_FOLDER, name + ".soup");
        if (!file.exists()) {
            return;
        }
        this.delete(file);
    }

    public List<String> getConfigList() {
        if (!MAIN_FOLDER.exists() || MAIN_FOLDER.listFiles() == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        if (CONFIGS_FOLDER.listFiles() != null) {
            for (File file : Arrays.stream(Objects.requireNonNull(CONFIGS_FOLDER.listFiles())).filter(f -> f.getName().endsWith(".soup")).toList()) {
                list.add(file.getName().replace(".soup", ""));
            }
        }
        return list;
    }

    public void saveCurrentConfig() {
        if (this.currentConfig == null) {
            return;
        }
        if (!FILES_FOLDER.exists()) {
            FILES_FOLDER.mkdirs();
        }
        File file = new File(FILES_FOLDER, "currentCfg");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            try (FileWriter writer = new FileWriter(file);){
                writer.write(this.currentConfig.getName().replace(".soup", ""));
            }
        }
        catch (Exception e) {
            LoggerUtil.error((Object)"Failed to save current config name", e);
        }
    }

    public File loadCurrentConfig() {
        String name;
        block9: {
            if (!FILES_FOLDER.exists()) {
                FILES_FOLDER.mkdirs();
            }
            File file = new File(FILES_FOLDER, "currentCfg");
            name = "default";
            try {
                if (!file.exists()) break block9;
                try (Scanner reader = new Scanner(file);){
                    while (reader.hasNextLine()) {
                        name = reader.nextLine();
                    }
                }
            }
            catch (Exception e) {
                LoggerUtil.error((Object)"Failed to load current config name", e);
            }
        }
        this.currentConfig = new File(CONFIGS_FOLDER, name + ".soup");
        return this.currentConfig;
    }

    private void onUnload() {
        for (Module module : this.moduleRepository.modules()) {
            if (!module.isEnabled()) continue;
            module.setStateSilent(false);
        }
    }

    private void onLoad() {
        for (Module module : this.moduleRepository.modules()) {
            if (!module.isEnabled()) continue;
            module.setStateSilent(true);
        }
        KeyBind.reloadGlobalSettings();
    }

    public void createDefaultConfig() {
        File defaultConfig = new File(CONFIGS_FOLDER, "default.soup");
        if (!defaultConfig.exists()) {
            this.save(defaultConfig);
            this.currentConfig = defaultConfig;
            this.saveCurrentConfig();
            LoggerUtil.info("Created default config");
        }
    }

    public void initialize() {
        this.createDefaultConfig();
        File config = this.loadCurrentConfig();
        this.isLoadingConfig = true;
        try {
            if (config.exists()) {
                this.load(config);
            } else {
                this.createDefaultConfig();
            }
        }
        finally {
            this.isLoadingConfig = false;
        }
    }

    public void shutdown() {
        try {
            if (this.lastChangeTime > 0L) {
                this.saveCurrentActiveConfig();
                this.lastChangeTime = 0L;
            }
            this.autoSaveScheduler.shutdown();
            if (!this.autoSaveScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                this.autoSaveScheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.autoSaveScheduler.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public File getCurrentConfig() {
        return this.currentConfig;
    }

    public void setCurrentConfig(File currentConfig) {
        this.currentConfig = currentConfig;
    }

    public static boolean isFirstLaunch() {
        return firstLaunch;
    }
}

