/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.api.repository.config;

import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import padej.soup.api.repository.config.Config;
import padej.soup.api.repository.config.ConfigManager;
import padej.soup.base.util.logger.LoggerUtil;

public class ConfigUtils {
    private static final List<Config> configs = new CopyOnWriteArrayList<Config>();
    private static volatile String activeConfigName = "default";
    private static final Object LOCK = new Object();
    private static ConfigManager configManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfig(Config config) {
        Object object = LOCK;
        synchronized (object) {
            if (!configs.contains(config)) {
                configs.add(config);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConfig(Config config) {
        Object object = LOCK;
        synchronized (object) {
            configs.remove(config);
        }
    }

    public static List<Config> getConfigs() {
        return new ArrayList<Config>(configs);
    }

    public static boolean isConfig(String name) {
        return configs.stream().anyMatch(config -> config.getName().equals(name));
    }

    public static Config getConfig(String name) {
        return configs.stream().filter(config -> config.getName().equals(name)).findFirst().orElse(null);
    }

    public static List<Config> searchConfigs(String searchText) {
        if (searchText == null || searchText.trim().isEmpty()) {
            return new ArrayList<Config>(configs);
        }
        String lowerSearch = searchText.toLowerCase();
        return configs.stream().filter(config -> config.getName().toLowerCase().contains(lowerSearch) || config.getDescription() != null && config.getDescription().toLowerCase().contains(lowerSearch)).collect(Collectors.toList());
    }

    public static void clear() {
        configs.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeConfigManager(ConfigManager manager) {
        Object object = LOCK;
        synchronized (object) {
            configManager = manager;
            configManager.initialize();
            ConfigUtils.loadConfigsFromDirectory();
            LoggerUtil.info("ConfigManager initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadConfigsFromDirectory() {
        Object object = LOCK;
        synchronized (object) {
            File configDir = ConfigManager.CONFIGS_FOLDER;
            if (!configDir.exists()) {
                configDir.mkdirs();
                LoggerUtil.info("Created config directory: " + configDir.getAbsolutePath());
            }
            File[] configFiles = configDir.listFiles((dir, name) -> name.endsWith(".soup"));
            ArrayList<Config> newConfigs = new ArrayList<Config>();
            if (configFiles != null) {
                for (File file : configFiles) {
                    if (!ConfigUtils.isValidJsonFile(file)) {
                        LoggerUtil.warn("Skipping invalid JSON config file: " + file.getName());
                        continue;
                    }
                    Config config2 = ConfigUtils.getConfig(file);
                    newConfigs.add(config2);
                }
            }
            configs.removeIf(existingConfig -> newConfigs.stream().noneMatch(newConfig -> newConfig.getFileName().equals(existingConfig.getFileName())));
            for (Config newConfig : newConfigs) {
                Config existing = configs.stream().filter(c -> c.getFileName().equals(newConfig.getFileName())).findFirst().orElse(null);
                if (existing != null) {
                    existing.setName(newConfig.getName());
                    existing.setDescription(newConfig.getDescription());
                    existing.setLastModified(newConfig.getLastModified());
                    continue;
                }
                configs.add(newConfig);
            }
            if (configManager != null && configManager.getCurrentConfig() != null) {
                String configNameFromFile = configManager.getCurrentConfig().getName().replace(".soup", "");
                Config matchingConfig = configs.stream().filter(config -> config.getName().equalsIgnoreCase(configNameFromFile)).findFirst().orElse(null);
                if (matchingConfig != null) {
                    activeConfigName = matchingConfig.getName();
                } else if (!configs.isEmpty()) {
                    activeConfigName = configs.get(0).getName();
                }
            }
        }
    }

    @NotNull
    private static Config getConfig(File file) {
        String fileName = file.getName();
        Object configName = fileName.substring(0, fileName.lastIndexOf(46));
        if (!((String)configName).isEmpty()) {
            configName = ((String)configName).substring(0, 1).toUpperCase() + ((String)configName).substring(1);
        }
        String description = "Custom configuration";
        String fileNameWithoutExt = fileName.substring(0, fileName.lastIndexOf(46));
        if ("default".equals(fileNameWithoutExt) || "defaultCfg".equals(fileNameWithoutExt)) {
            description = "Default configuration";
        }
        return new Config((String)configName, description, fileName, file.lastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadCurrentConfigFromFile() {
        Object object = LOCK;
        synchronized (object) {
            String configName;
            File config;
            if (configManager != null && (config = configManager.loadCurrentConfig()) != null && config.exists() && ConfigUtils.isConfig(configName = config.getName().replace(".soup", ""))) {
                activeConfigName = configName;
                return;
            }
            ConfigUtils.setFirstConfigAsActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCurrentConfigToFile() {
        Object object = LOCK;
        synchronized (object) {
            if (configManager != null) {
                configManager.saveCurrentConfig();
            }
        }
    }

    private static void setFirstConfigAsActive() {
        if (!configs.isEmpty()) {
            activeConfigName = configs.get(0).getName();
            ConfigUtils.saveCurrentConfigToFile();
        } else {
            activeConfigName = "default";
        }
    }

    public static File getConfigDirectory() {
        return ConfigManager.CONFIGS_FOLDER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setActiveConfig(String configName) {
        Object object = LOCK;
        synchronized (object) {
            if (ConfigUtils.isConfig(configName)) {
                activeConfigName = configName;
                if (configManager != null) {
                    configManager.load(configName);
                }
                ConfigUtils.saveCurrentConfigToFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setActiveConfigName(String configName) {
        Object object = LOCK;
        synchronized (object) {
            activeConfigName = configName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveActiveConfig() {
        Object object = LOCK;
        synchronized (object) {
            if (configManager != null) {
                configManager.save(activeConfigName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteConfig(String configName) {
        Object object = LOCK;
        synchronized (object) {
            Config config;
            String nextConfig;
            if (!ConfigUtils.isConfig(configName)) {
                LoggerUtil.warn("Cannot delete non-existent config: " + configName);
                return;
            }
            if (!ConfigUtils.canDeleteConfig()) {
                LoggerUtil.warn("Cannot delete the last config");
                return;
            }
            if (ConfigUtils.isActiveConfig(configName) && (nextConfig = ConfigUtils.getNextConfigForDeletion(configName)) != null) {
                ConfigUtils.setActiveConfig(nextConfig);
            }
            if (configManager != null) {
                configManager.delete(configName);
            }
            if ((config = ConfigUtils.getConfig(configName)) != null) {
                ConfigUtils.removeConfig(config);
            }
        }
    }

    public static boolean isActiveConfig(String configName) {
        return activeConfigName.equals(configName);
    }

    public static boolean canDeleteConfig() {
        return configs.size() > 1;
    }

    public static String getNextConfigForDeletion(String configToDelete) {
        List<Config> availableConfigs = configs.stream().filter(config -> !config.getName().equals(configToDelete)).toList();
        if (!availableConfigs.isEmpty()) {
            return availableConfigs.getFirst().getName();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isValidJsonFile(File file) {
        try (FileReader reader = new FileReader(file);){
            if (file.length() == 0L) {
                boolean bl = false;
                return bl;
            }
            JsonParser.parseReader((Reader)reader);
            boolean bl = true;
            return bl;
        }
        catch (JsonSyntaxException e) {
            LoggerUtil.warn("Invalid JSON in file: " + file.getName());
            return false;
        }
        catch (Exception e) {
            LoggerUtil.warn("Error reading file: " + file.getName() + " - " + e.getMessage());
            return false;
        }
    }

    public static int getConfigCount() {
        return configs.size();
    }

    public static boolean hasConfigs() {
        return !configs.isEmpty();
    }

    @Nullable
    public static Config getConfigByIndex(int index) {
        if (index >= 0 && index < configs.size()) {
            return configs.get(index);
        }
        return null;
    }

    public static String getConfigSize(String configName) {
        Config config = ConfigUtils.getConfig(configName);
        if (config == null) {
            return "N/A";
        }
        File configFile = new File(ConfigManager.CONFIGS_FOLDER, config.getFileName());
        if (!configFile.exists()) {
            return "N/A";
        }
        long sizeInBytes = configFile.length();
        double sizeInKB = (double)sizeInBytes / 1024.0;
        if (sizeInKB < 1.0) {
            return String.format("%.2f B", sizeInBytes);
        }
        if (sizeInKB < 1024.0) {
            return String.format("%.2f KB", sizeInKB);
        }
        return String.format("%.2f MB", sizeInKB / 1024.0);
    }

    public static String getConfigLastModified(String configName) {
        Config config = ConfigUtils.getConfig(configName);
        if (config == null) {
            return "N/A";
        }
        long timestamp = config.getLastModified();
        if (timestamp <= 0L) {
            return "N/A";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("dd MMM yyyy HH:mm");
        return sdf.format(new Date(timestamp));
    }

    public static String getActiveConfigName() {
        return activeConfigName;
    }

    public static ConfigManager getConfigManager() {
        return configManager;
    }
}

