/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.api.system.font;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.awt.Color;
import java.awt.Font;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import net.minecraft.class_10142;
import net.minecraft.class_10156;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import padej.soup.api.event.EventManager;
import padej.soup.api.system.font.entry.DrawEntry;
import padej.soup.api.system.font.glyph.Glyph;
import padej.soup.api.system.font.glyph.GlyphMap;
import padej.soup.base.QuickImports;
import padej.soup.base.util.color.ColorUtil;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.other.StringUtil;
import padej.soup.implement.events.render.TextFactoryEvent;

public class FontRenderer
implements QuickImports {
    private static final int STRING_BUILDER_POOL_SIZE = 16;
    private static final Queue<StringBuilder> STRING_BUILDER_POOL = new ArrayDeque<StringBuilder>(16);
    public static double ANIMATION_TIME;
    private final Object2ObjectMap<class_2960, ObjectList<DrawEntry>> GLYPH_PAGE_CACHE = new Object2ObjectOpenHashMap();
    private final ObjectList<GlyphMap> maps = new ObjectArrayList();
    private final Map<Character, Glyph> glyphCache = new HashMap<Character, Glyph>();
    private static final Map<Long, Integer> COLOR_INTERP_CACHE;
    private Font font;

    public FontRenderer(Font font, float sizePx) {
        this.init(font, sizePx);
    }

    private void init(Font font, float sizePx) {
        this.font = font.deriveFont(sizePx * 2.0f);
    }

    private GlyphMap generateMap(char from, char to) {
        GlyphMap glyphMap = new GlyphMap(from, to, this.font, FontRenderer.randomIdentifier(), 5);
        this.maps.add((Object)glyphMap);
        return glyphMap;
    }

    private Glyph locateGlyph(char glyph) {
        Glyph cached = this.glyphCache.get(Character.valueOf(glyph));
        if (cached != null) {
            return cached;
        }
        for (GlyphMap map : this.maps) {
            if (!map.contains(glyph)) continue;
            Glyph found = map.getGlyph(glyph);
            this.glyphCache.put(Character.valueOf(glyph), found);
            return found;
        }
        char base = (char)MathUtil.floorNearestMulN(glyph, 128);
        Glyph result = this.generateMap(base, (char)(base + 128)).getGlyph(glyph);
        this.glyphCache.put(Character.valueOf(glyph), result);
        return result;
    }

    private static StringBuilder acquireStringBuilder() {
        StringBuilder sb = STRING_BUILDER_POOL.poll();
        if (sb == null) {
            sb = new StringBuilder(256);
        } else {
            sb.setLength(0);
        }
        return sb;
    }

    private static void releaseStringBuilder(StringBuilder sb) {
        if (STRING_BUILDER_POOL.size() < 16) {
            sb.setLength(0);
            STRING_BUILDER_POOL.offer(sb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawText(class_4587 matrix, class_2561 text, double x, double y) {
        StringBuilder sb = FontRenderer.acquireStringBuilder();
        try {
            this.findStyle(sb, text);
            this.drawString(matrix, sb.toString(), x, y, ColorUtil.getText());
        }
        finally {
            FontRenderer.releaseStringBuilder(sb);
        }
    }

    public void findStyle(StringBuilder sb, class_2561 component) {
        class_2583 style = component.method_10866();
        if (component.method_10855().isEmpty()) {
            if (style.method_10973() != null) {
                sb.append(ColorUtil.formatting(style.method_10973().method_27716()));
            }
            sb.append(component.getString()).append(class_124.field_1070);
        } else {
            component.method_36136(style).forEach(text -> this.findStyle(sb, (class_2561)text));
        }
    }

    public void drawStringWithScroll(class_4587 matrix, String text, double x, double y, float width, int color) {
        String separation = "  |  ";
        float textWidth = this.getStringWidth(text + separation);
        if (textWidth - width < 10.0f) {
            this.drawString(matrix, text, x, y, color);
            return;
        }
        this.drawString(matrix, text + separation + text, x - (double)MathUtil.textScrolling(textWidth), y, color);
    }

    public void drawString(class_4587 matrix, String text, double x, double y, int color) {
        TextFactoryEvent event = new TextFactoryEvent(text);
        EventManager.callEvent(event);
        text = event.getText();
        char[] chars = text.toCharArray();
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        int lineStart = 0;
        StringBuilder stringColor = new StringBuilder();
        boolean colorFormat = false;
        boolean textColor = false;
        int clr = color;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\u00a7') {
                colorFormat = true;
                continue;
            }
            if (colorFormat) {
                colorFormat = false;
                char c1 = Character.toUpperCase(c);
                if (ColorUtil.colorCodes.containsKey(c1)) {
                    clr = new Color(ColorUtil.colorCodes.get(c1)).getRGB();
                    continue;
                }
                if (c1 != 'R') continue;
                clr = color;
                continue;
            }
            if (c == '\u23cf') {
                if (textColor) {
                    try {
                        String colorString = stringColor.toString();
                        if (colorString.matches("\\d+")) {
                            clr = new Color(Integer.parseInt(colorString)).getRGB();
                        }
                    }
                    catch (IllegalArgumentException colorString) {
                        // empty catch block
                    }
                    stringColor.setLength(0);
                }
                textColor = !textColor;
                continue;
            }
            if (textColor) {
                stringColor.append(c);
                continue;
            }
            if (c == '\n') {
                yOffset += this.getStringHeight(text.substring(lineStart, i)) - 2.0f;
                xOffset = 0.0f;
                lineStart = i + 1;
                continue;
            }
            Glyph glyph = this.locateGlyph(c);
            if (glyph == null) continue;
            if (glyph.value() != ' ') {
                class_2960 i1 = glyph.owner().bindToTexture;
                DrawEntry entry = new DrawEntry(xOffset, yOffset, clr, glyph);
                ((ObjectList)this.GLYPH_PAGE_CACHE.computeIfAbsent((Object)i1, integer -> new ObjectArrayList())).add((Object)entry);
            }
            xOffset += (float)glyph.width();
        }
        if (!this.GLYPH_PAGE_CACHE.isEmpty()) {
            this.drawGlyphs(matrix, x, y);
        }
        this.clearGlyphCache();
    }

    public void drawGradientString(class_4587 matrix, String text, double x, double y, int colorStart, int colorEnd) {
        TextFactoryEvent event = new TextFactoryEvent(text);
        EventManager.callEvent(event);
        text = event.getText();
        char[] chars = text.toCharArray();
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        int lineStart = 0;
        int textLength = text.length();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\n') {
                yOffset += this.getStringHeight(text.substring(lineStart, i)) - 2.0f;
                xOffset = 0.0f;
                lineStart = i + 1;
                continue;
            }
            Glyph glyph = this.locateGlyph(c);
            if (glyph == null) continue;
            if (glyph.value() != ' ') {
                float t = (float)i / (float)(textLength - 1);
                int color = this.interpolateColor(colorStart, colorEnd, t);
                class_2960 i1 = glyph.owner().bindToTexture;
                DrawEntry entry = new DrawEntry(xOffset, yOffset, color, glyph);
                ((ObjectList)this.GLYPH_PAGE_CACHE.computeIfAbsent((Object)i1, integer -> new ObjectArrayList())).add((Object)entry);
            }
            xOffset += (float)glyph.width();
        }
        if (!this.GLYPH_PAGE_CACHE.isEmpty()) {
            this.drawGlyphs(matrix, x, y);
        }
        this.clearGlyphCache();
    }

    public void drawAnimatedGradientString(class_4587 matrix, String text, double x, double y, int colorStart, int colorEnd, double waveLength, double speed) {
        TextFactoryEvent event = new TextFactoryEvent(text);
        EventManager.callEvent(event);
        text = event.getText();
        ANIMATION_TIME = (double)System.currentTimeMillis() / 1000.0;
        char[] chars = text.toCharArray();
        float xOffset = 0.0f;
        float yOffset = 0.0f;
        int lineStart = 0;
        int textLength = text.length();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '\n') {
                yOffset += this.getStringHeight(text.substring(lineStart, i)) - 2.0f;
                xOffset = 0.0f;
                lineStart = i + 1;
                continue;
            }
            Glyph glyph = this.locateGlyph(c);
            if (glyph == null) continue;
            if (glyph.value() != ' ') {
                float t = (float)i / (float)Math.max(1, textLength - 1);
                double wave = Math.sin((double)t * waveLength - ANIMATION_TIME * speed);
                float normalizedWave = (float)((wave + 1.0) / 2.0);
                int color = this.interpolateColor(colorStart, colorEnd, normalizedWave);
                class_2960 i1 = glyph.owner().bindToTexture;
                DrawEntry entry = new DrawEntry(xOffset, yOffset, color, glyph);
                ((ObjectList)this.GLYPH_PAGE_CACHE.computeIfAbsent((Object)i1, integer -> new ObjectArrayList())).add((Object)entry);
            }
            xOffset += (float)glyph.width();
        }
        if (!this.GLYPH_PAGE_CACHE.isEmpty()) {
            this.drawGlyphs(matrix, x, y);
        }
        this.clearGlyphCache();
    }

    public void drawAnimatedGradientString(class_4587 matrix, String text, double x, double y, int colorStart, int colorEnd) {
        this.drawAnimatedGradientString(matrix, text, x, y, colorStart, colorEnd, Math.PI, 5.0);
    }

    private void clearGlyphCache() {
        for (ObjectList list : this.GLYPH_PAGE_CACHE.values()) {
            list.clear();
        }
        this.GLYPH_PAGE_CACHE.clear();
    }

    private void drawGlyphs(class_4587 matrix, double x, double y) {
        matrix.method_22903();
        matrix.method_22904(x, y - 3.0, 0.0);
        matrix.method_22905(0.5f, 0.5f, 1.0f);
        Matrix4f matrix4f = matrix.method_23760().method_23761();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader((class_10156)class_10142.field_53880);
        for (class_2960 identifier : this.GLYPH_PAGE_CACHE.keySet()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)identifier);
            class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            for (DrawEntry drawEntry : (ObjectList)this.GLYPH_PAGE_CACHE.get((Object)identifier)) {
                float x1 = drawEntry.atX();
                float y1 = drawEntry.atY();
                Glyph glyph = drawEntry.toDraw();
                GlyphMap glyphMap = glyph.owner();
                float width = glyph.width();
                float height = glyph.height();
                float u1 = (float)glyph.u() / (float)glyphMap.width;
                float v1 = (float)glyph.v() / (float)glyphMap.height;
                float u2 = (float)(glyph.u() + glyph.width()) / (float)glyphMap.width;
                float v2 = (float)(glyph.v() + glyph.height()) / (float)glyphMap.height;
                int color = drawEntry.color();
                buffer.method_22918(matrix4f, x1 + 0.0f, y1 + height, 0.0f).method_22913(u1, v2).method_39415(color);
                buffer.method_22918(matrix4f, x1 + width, y1 + height, 0.0f).method_22913(u2, v2).method_39415(color);
                buffer.method_22918(matrix4f, x1 + width, y1 + 0.0f, 0.0f).method_22913(u2, v1).method_39415(color);
                buffer.method_22918(matrix4f, x1 + 0.0f, y1 + 0.0f, 0.0f).method_22913(u1, v1).method_39415(color);
            }
            class_286.method_43433((class_9801)buffer.method_60800());
        }
        RenderSystem.disableBlend();
        matrix.method_22909();
    }

    public void drawCenteredString(class_4587 stack, String s, double x, double y, int color) {
        this.drawString(stack, s, (int)(x - (double)(this.getStringWidth(s) / 2.0f)), (float)y, color);
    }

    public float getStringWidth(class_2561 text) {
        return text != null ? this.getStringWidth(text.getString()) : 0.0f;
    }

    public float getStringWidth(String text) {
        TextFactoryEvent event = new TextFactoryEvent(text);
        EventManager.callEvent(event);
        text = event.getText();
        float currentLine = 0.0f;
        float maxPreviousLines = 0.0f;
        boolean ignore = false;
        for (char c : text.toCharArray()) {
            if (ignore) {
                ignore = false;
                continue;
            }
            if (c == '\u00a7') {
                ignore = true;
                continue;
            }
            if (c == '\n') {
                maxPreviousLines = Math.max(currentLine, maxPreviousLines);
                currentLine = 0.0f;
                continue;
            }
            Glyph glyph = this.locateGlyph(c);
            currentLine += glyph == null ? 0.0f : (float)glyph.width();
        }
        return Math.max(currentLine, maxPreviousLines) / 2.0f;
    }

    public float getStringHeight(class_2561 text) {
        return this.getStringHeight(text.getString());
    }

    public float getStringHeight(String text) {
        float currentLine = 0.0f;
        float previous = 0.0f;
        for (char c : (text.isEmpty() ? " " : text).toCharArray()) {
            if (c == '\n') {
                currentLine = currentLine == 0.0f ? (float)this.locateGlyph(' ').height() : currentLine;
                previous += currentLine;
                currentLine = 0.0f;
                continue;
            }
            Glyph glyph = this.locateGlyph(c);
            currentLine = Math.max(glyph == null ? 0.0f : (float)glyph.height(), currentLine);
        }
        return currentLine + previous;
    }

    private int interpolateColor(int colorStart, int colorEnd, float t) {
        int quantizedT = (int)(t * 100.0f);
        long key = (long)colorStart << 32 | (long)colorEnd & 0xFFFFFFFFL | (long)quantizedT << 48;
        Integer cached = COLOR_INTERP_CACHE.get(key);
        if (cached != null) {
            return cached;
        }
        float startAlpha = (float)(colorStart >> 24 & 0xFF) / 255.0f;
        float startRed = (float)(colorStart >> 16 & 0xFF) / 255.0f;
        float startGreen = (float)(colorStart >> 8 & 0xFF) / 255.0f;
        float startBlue = (float)(colorStart & 0xFF) / 255.0f;
        float endAlpha = (float)(colorEnd >> 24 & 0xFF) / 255.0f;
        float endRed = (float)(colorEnd >> 16 & 0xFF) / 255.0f;
        float endGreen = (float)(colorEnd >> 8 & 0xFF) / 255.0f;
        float endBlue = (float)(colorEnd & 0xFF) / 255.0f;
        float alpha = startAlpha + t * (endAlpha - startAlpha);
        float red = startRed + t * (endRed - startRed);
        float green = startGreen + t * (endGreen - startGreen);
        float blue = startBlue + t * (endBlue - startBlue);
        int result = (int)(alpha * 255.0f) << 24 | (int)(red * 255.0f) << 16 | (int)(green * 255.0f) << 8 | (int)(blue * 255.0f);
        if (COLOR_INTERP_CACHE.size() < 10000) {
            COLOR_INTERP_CACHE.put(key, result);
        }
        return result;
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public static class_2960 randomIdentifier() {
        return class_2960.method_60655((String)"soupapi", (String)("temp/" + StringUtil.randomString(32)));
    }

    public FontRenderer setFont(Font font) {
        this.font = font;
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    static {
        for (int i = 0; i < 16; ++i) {
            STRING_BUILDER_POOL.offer(new StringBuilder(256));
        }
        ANIMATION_TIME = 0.0;
        COLOR_INTERP_CACHE = new HashMap<Long, Integer>();
    }
}

