/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.api.system.font;

import java.awt.Font;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import padej.soup.api.system.font.FontRenderer;
import padej.soup.core.Main;

public class Fonts {
    private static final Map<FontKey, FontRenderer> fontCache = new HashMap<FontKey, FontRenderer>();

    public static FontRenderer create(float size, String name) {
        FontRenderer fontRenderer;
        block8: {
            String path = "assets/minecraft/fonts/" + name + ".otf";
            InputStream inputStream = Main.class.getClassLoader().getResourceAsStream(path);
            try {
                Font font = Font.createFont(0, Objects.requireNonNull(inputStream)).deriveFont(0, size / 2.0f);
                fontRenderer = new FontRenderer(font, size / 2.0f);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            inputStream.close();
        }
        return fontRenderer;
    }

    public static void init() {
        for (Type type : Type.values()) {
            for (int size = 4; size <= 32; ++size) {
                fontCache.put(new FontKey(size, type), Fonts.create(size, type.getType()));
            }
        }
    }

    public static FontRenderer getSize(int size) {
        return Fonts.getSize(size, Type.INTER_BOLD);
    }

    public static FontRenderer getSize(int size, Type type) {
        return fontCache.computeIfAbsent(new FontKey(size, type), k -> Fonts.create(size, type.getType()));
    }

    public static enum Type {
        SF_DEFAULT("sfpromedium"),
        SF_BOLD("sfprosemibold"),
        INTER_DEFAULT("inter"),
        INTER_BOLD("inter_bold"),
        ICO("ico"),
        JET_DEFAULT("jetbrains_mono"),
        JET_BOLD("jetbrains_mono_bold");

        private final String type;

        public String getType() {
            return this.type;
        }

        private Type(String type) {
            this.type = type;
        }
    }

    private record FontKey(int size, Type type) {
    }
}

