/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.color;

import it.unimi.dsi.fastutil.chars.Char2IntArrayMap;
import java.awt.Color;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector4i;
import padej.soup.base.util.color.ColorPalette;
import padej.soup.implement.features.modules.client.Theme;

public final class ColorUtil {
    private static final long CACHE_EXPIRATION_TIME = 60000L;
    private static final ConcurrentHashMap<ColorKey, CacheEntry> colorCache = new ConcurrentHashMap();
    private static final ScheduledExecutorService cacheCleaner = Executors.newScheduledThreadPool(1);
    private static final DelayQueue<CacheEntry> cleanupQueue = new DelayQueue();
    public static final Pattern FORMATTING_CODE_PATTERN = Pattern.compile("(?i)\u00a7[0-9a-f-or]");
    public static Char2IntArrayMap colorCodes = new Char2IntArrayMap(){
        {
            this.put('0', 0);
            this.put('1', 170);
            this.put('2', 43520);
            this.put('3', 43690);
            this.put('4', 0xAA0000);
            this.put('5', 0xAA00AA);
            this.put('6', 0xFFAA00);
            this.put('7', 0xAAAAAA);
            this.put('8', 0x555555);
            this.put('9', 0x5555FF);
            this.put('A', 0x55FF55);
            this.put('B', 0x55FFFF);
            this.put('C', 0xFF5555);
            this.put('D', 0xFF55FF);
            this.put('E', 0xFFFF55);
            this.put('F', 0xFFFFFF);
        }
    };
    public static final int RED;
    public static final int GREEN;
    public static final int BLUE;
    public static final int YELLOW;
    public static final int WHITE;
    public static final int BLACK;
    public static final int HALF_BLACK;
    public static final int LIGHT_RED;

    public static int red(int c) {
        return c >> 16 & 0xFF;
    }

    public static int green(int c) {
        return c >> 8 & 0xFF;
    }

    public static int blue(int c) {
        return c & 0xFF;
    }

    public static int alpha(int c) {
        return c >> 24 & 0xFF;
    }

    public static float redf(int c) {
        return (float)ColorUtil.red(c) / 255.0f;
    }

    public static float greenf(int c) {
        return (float)ColorUtil.green(c) / 255.0f;
    }

    public static float bluef(int c) {
        return (float)ColorUtil.blue(c) / 255.0f;
    }

    public static float alphaf(int c) {
        return (float)ColorUtil.alpha(c) / 255.0f;
    }

    public static int[] getRGBA(int c) {
        return new int[]{ColorUtil.red(c), ColorUtil.green(c), ColorUtil.blue(c), ColorUtil.alpha(c)};
    }

    public static int[] getRGB(int c) {
        return new int[]{ColorUtil.red(c), ColorUtil.green(c), ColorUtil.blue(c)};
    }

    public static float[] getRGBAf(int c) {
        return new float[]{ColorUtil.redf(c), ColorUtil.greenf(c), ColorUtil.bluef(c), ColorUtil.alphaf(c)};
    }

    public static float[] getRGBf(int c) {
        return new float[]{ColorUtil.redf(c), ColorUtil.greenf(c), ColorUtil.bluef(c)};
    }

    public static int getColor(float red, float green, float blue, float alpha) {
        return ColorUtil.getColor(Math.round(red * 255.0f), Math.round(green * 255.0f), Math.round(blue * 255.0f), Math.round(alpha * 255.0f));
    }

    public static int getColor(int red, int green, int blue, float alpha) {
        return ColorUtil.getColor(red, green, blue, Math.round(alpha * 255.0f));
    }

    public static int getColor(float red, float green, float blue) {
        return ColorUtil.getColor(red, green, blue, 1.0f);
    }

    public static int getColor(int brightness, int alpha) {
        return ColorUtil.getColor(brightness, brightness, brightness, alpha);
    }

    public static int getColor(int brightness, float alpha) {
        return ColorUtil.getColor(brightness, Math.round(alpha * 255.0f));
    }

    public static int getColor(int brightness) {
        return ColorUtil.getColor(brightness, brightness, brightness);
    }

    public static int replAlpha(int color, int alpha) {
        return ColorUtil.getColor(ColorUtil.red(color), ColorUtil.green(color), ColorUtil.blue(color), alpha);
    }

    public static int replAlpha(int color, float alpha) {
        return ColorUtil.getColor(ColorUtil.red(color), ColorUtil.green(color), ColorUtil.blue(color), alpha);
    }

    public static int multAlpha(int color, float percent01) {
        return ColorUtil.getColor(ColorUtil.red(color), ColorUtil.green(color), ColorUtil.blue(color), Math.round((float)ColorUtil.alpha(color) * percent01));
    }

    public static int multColor(int colorStart, int colorEnd, float progress) {
        return ColorUtil.getColor(Math.round((float)ColorUtil.red(colorStart) * (ColorUtil.redf(colorEnd) * progress)), Math.round((float)ColorUtil.green(colorStart) * (ColorUtil.greenf(colorEnd) * progress)), Math.round((float)ColorUtil.blue(colorStart) * (ColorUtil.bluef(colorEnd) * progress)), Math.round((float)ColorUtil.alpha(colorStart) * (ColorUtil.alphaf(colorEnd) * progress)));
    }

    public static int multRed(int colorStart, int colorEnd, float progress) {
        return ColorUtil.getColor(Math.round((float)ColorUtil.red(colorStart) * (ColorUtil.redf(colorEnd) * progress)), Math.round((float)ColorUtil.green(colorStart) * (ColorUtil.greenf(colorEnd) * progress)), Math.round((float)ColorUtil.blue(colorStart) * (ColorUtil.bluef(colorEnd) * progress)), Math.round((float)ColorUtil.alpha(colorStart) * (ColorUtil.alphaf(colorEnd) * progress)));
    }

    public static int multDark(int color, float percent01) {
        return ColorUtil.getColor(Math.round((float)ColorUtil.red(color) * percent01), Math.round((float)ColorUtil.green(color) * percent01), Math.round((float)ColorUtil.blue(color) * percent01), ColorUtil.alpha(color));
    }

    public static int multBright(int color, float percent01) {
        return ColorUtil.getColor(Math.min(255, Math.round((float)ColorUtil.red(color) / percent01)), Math.min(255, Math.round((float)ColorUtil.green(color) / percent01)), Math.min(255, Math.round((float)ColorUtil.blue(color) / percent01)), ColorUtil.alpha(color));
    }

    public static int overCol(int color1, int color2, float percent01) {
        float percent = class_3532.method_15363((float)percent01, (float)0.0f, (float)1.0f);
        return ColorUtil.getColor(class_3532.method_48781((float)percent, (int)ColorUtil.red(color1), (int)ColorUtil.red(color2)), class_3532.method_48781((float)percent, (int)ColorUtil.green(color1), (int)ColorUtil.green(color2)), class_3532.method_48781((float)percent, (int)ColorUtil.blue(color1), (int)ColorUtil.blue(color2)), class_3532.method_48781((float)percent, (int)ColorUtil.alpha(color1), (int)ColorUtil.alpha(color2)));
    }

    public static Vector4i multRedAndAlpha(Vector4i color, float red, float alpha) {
        return new Vector4i(ColorUtil.multRedAndAlpha(color.x, red, alpha), ColorUtil.multRedAndAlpha(color.y, red, alpha), ColorUtil.multRedAndAlpha(color.w, red, alpha), ColorUtil.multRedAndAlpha(color.z, red, alpha));
    }

    public static int multRedAndAlpha(int color, float red, float alpha) {
        return ColorUtil.getColor(ColorUtil.red(color), Math.min(255, Math.round((float)ColorUtil.green(color) / red)), Math.min(255, Math.round((float)ColorUtil.blue(color) / red)), Math.round((float)ColorUtil.alpha(color) * alpha));
    }

    public static int multRed(int color, float percent01) {
        return ColorUtil.getColor(ColorUtil.red(color), Math.min(255, Math.round((float)ColorUtil.green(color) / percent01)), Math.min(255, Math.round((float)ColorUtil.blue(color) / percent01)), ColorUtil.alpha(color));
    }

    public static int multGreen(int color, float percent01) {
        return ColorUtil.getColor(Math.min(255, Math.round((float)ColorUtil.green(color) / percent01)), ColorUtil.green(color), Math.min(255, Math.round((float)ColorUtil.blue(color) / percent01)), ColorUtil.alpha(color));
    }

    public static int gradientToRed(int originalColor, float damageIntensity) {
        damageIntensity = class_3532.method_15363((float)damageIntensity, (float)0.0f, (float)1.0f);
        int originalRed = ColorUtil.red(originalColor);
        int originalGreen = ColorUtil.green(originalColor);
        int originalBlue = ColorUtil.blue(originalColor);
        int originalAlpha = ColorUtil.alpha(originalColor);
        int targetRed = 255;
        int targetGreen = 0;
        int targetBlue = 0;
        int newRed = Math.round(class_3532.method_48781((float)damageIntensity, (int)originalRed, (int)targetRed));
        int newGreen = Math.round(class_3532.method_48781((float)damageIntensity, (int)originalGreen, (int)targetGreen));
        int newBlue = Math.round(class_3532.method_48781((float)damageIntensity, (int)originalBlue, (int)targetBlue));
        return ColorUtil.getColor(newRed, newGreen, newBlue, originalAlpha);
    }

    public static int[] genGradientForText(int color1, int color2, int length) {
        int[] gradient = new int[length];
        for (int i = 0; i < length; ++i) {
            float pc = (float)i / (float)(length - 1);
            gradient[i] = ColorUtil.overCol(color1, color2, pc);
        }
        return gradient;
    }

    public static int rainbow(int speed, int index, float saturation, float brightness, float opacity) {
        int angle = (int)((System.currentTimeMillis() / (long)speed + (long)index) % 360L);
        float hue = (float)angle / 360.0f;
        int color = Color.HSBtoRGB(hue, saturation, brightness);
        return ColorUtil.getColor(ColorUtil.red(color), ColorUtil.green(color), ColorUtil.blue(color), Math.round(opacity * 255.0f));
    }

    public static int fade(int speed, int index, int first, int second) {
        int angle = (int)((System.currentTimeMillis() / (long)speed + (long)index) % 360L);
        angle = angle >= 180 ? 360 - angle : angle;
        return ColorUtil.overCol(first, second, (float)angle / 180.0f);
    }

    public static int fade(int index) {
        Color clientColor = new Color(ColorUtil.getClientColor());
        return ColorUtil.fade(8, index, clientColor.brighter().getRGB(), clientColor.darker().getRGB());
    }

    public static int fade(int index, int indexMultiplier) {
        Color clientColor = new Color(ColorUtil.getClientColor());
        return ColorUtil.fade(8, index * indexMultiplier, clientColor.brighter().getRGB(), clientColor.darker().getRGB());
    }

    public static int invertFade(int index) {
        Color clientColor = new Color(ColorUtil.getClientColor());
        return ColorUtil.fade(8, index, clientColor.darker().getRGB(), clientColor.brighter().getRGB());
    }

    public static int multiColorFade(int index) {
        int[] colors = ColorUtil.getClientColors();
        if (colors.length == 0) {
            return ColorUtil.getColor(255, 255, 255);
        }
        if (colors.length == 1) {
            return colors[0];
        }
        float speedMultiplier = Theme.getInstance().getFadeSpeed();
        long currentTime = System.currentTimeMillis();
        if (colors.length == 2) {
            double adjustedSpeed = 8.0 / (double)speedMultiplier;
            int angle = (int)(((double)currentTime / adjustedSpeed + (double)index) % 360.0);
            angle = angle >= 180 ? 360 - angle : angle;
            return ColorUtil.overCol(colors[0], colors[1], (float)angle / 180.0f);
        }
        double adjustedSpeed = 10.0 / (double)speedMultiplier;
        float timeProgress = (float)(((double)currentTime / adjustedSpeed + (double)(index * 100)) % (double)((long)colors.length * 360L)) / 360.0f;
        int index1 = (int)Math.floor(timeProgress) % colors.length;
        int index2 = (index1 + 1) % colors.length;
        float lerp = timeProgress - (float)((int)Math.floor(timeProgress));
        return ColorUtil.overCol(colors[index1], colors[index2], lerp);
    }

    public static Vector4i roundClientColor(float alpha) {
        return new Vector4i(ColorUtil.multAlpha(ColorUtil.multiColorFade(270), alpha), ColorUtil.multAlpha(ColorUtil.multiColorFade(0), alpha), ColorUtil.multAlpha(ColorUtil.multiColorFade(180), alpha), ColorUtil.multAlpha(ColorUtil.multiColorFade(90), alpha));
    }

    public static int getColor(int red, int green, int blue, int alpha) {
        ColorKey key = new ColorKey(red, green, blue, alpha);
        CacheEntry cacheEntry = colorCache.computeIfAbsent(key, k -> {
            CacheEntry newEntry = new CacheEntry((ColorKey)k, ColorUtil.computeColor(red, green, blue, alpha), 60000L);
            cleanupQueue.offer(newEntry);
            return newEntry;
        });
        return cacheEntry.color();
    }

    public static int getColor(int red, int green, int blue) {
        return ColorUtil.getColor(red, green, blue, 255);
    }

    private static int computeColor(int red, int green, int blue, int alpha) {
        return class_3532.method_15340((int)alpha, (int)0, (int)255) << 24 | class_3532.method_15340((int)red, (int)0, (int)255) << 16 | class_3532.method_15340((int)green, (int)0, (int)255) << 8 | class_3532.method_15340((int)blue, (int)0, (int)255);
    }

    private static String generateKey(int red, int green, int blue, int alpha) {
        return red + "," + green + "," + blue + "," + alpha;
    }

    public static String formatting(int color) {
        return "\u23cf" + color + "\u23cf";
    }

    public static int lighter(int hex) {
        return ColorUtil.lighter(hex, 1);
    }

    public static int lighter(int hex, int steps) {
        int a = hex >> 24 & 0xFF;
        int r = hex >> 16 & 0xFF;
        int g = hex >> 8 & 0xFF;
        int b = hex & 0xFF;
        for (int i = 0; i < steps; ++i) {
            r += (255 - r) / 10;
            g += (255 - g) / 10;
            b += (255 - b) / 10;
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int darker(int hex) {
        return ColorUtil.darker(hex, 1);
    }

    public static int darker(int hex, int steps) {
        int a = hex >> 24 & 0xFF;
        int r = hex >> 16 & 0xFF;
        int g = hex >> 8 & 0xFF;
        int b = hex & 0xFF;
        for (int i = 0; i < steps; ++i) {
            r -= r / 10;
            g -= g / 10;
            b -= b / 10;
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static String removeFormatting(String text) {
        return text == null || text.isEmpty() ? null : FORMATTING_CODE_PATTERN.matcher(text).replaceAll("");
    }

    private static ColorPalette getPalette() {
        final Theme theme = Theme.getInstance();
        if (theme.themeMode.isSelected("Custom")) {
            return new ColorPalette(){

                @Override
                public int mainGuiColor() {
                    return theme.mainGuiColor.getColor();
                }

                @Override
                public int guiRectColor() {
                    return theme.guiRectColor.getColor();
                }

                @Override
                public int guiRectColor2() {
                    return theme.guiRectColor2.getColor();
                }

                @Override
                public int rectColor() {
                    return theme.rectColor.getColor();
                }

                @Override
                public int rectDarkerColor() {
                    return theme.rectDarkerColor.getColor();
                }

                @Override
                public int textColor() {
                    return theme.textColor.getColor();
                }

                @Override
                public int descriptionColor() {
                    return theme.descriptionColor.getColor();
                }

                @Override
                public int outlineColor() {
                    return new Color(3816002).getRGB();
                }

                @Override
                public int friendColor() {
                    return new Color(4906624).getRGB();
                }

                @Override
                public String getName() {
                    return "Custom";
                }

                @Override
                public boolean isDark() {
                    int color = this.mainGuiColor();
                    int brightness = (ColorUtil.red(color) + ColorUtil.green(color) + ColorUtil.blue(color)) / 3;
                    return brightness < 128;
                }
            };
        }
        return theme.getCurrentPalette();
    }

    public static int getMainGuiColor() {
        return ColorUtil.getPalette().mainGuiColor();
    }

    public static int getGuiRectColor(float alpha) {
        return ColorUtil.multAlpha(ColorUtil.getPalette().guiRectColor(), alpha);
    }

    public static int getGuiRectColor2(float alpha) {
        return ColorUtil.multAlpha(ColorUtil.getPalette().guiRectColor2(), alpha);
    }

    public static int getRect(float alpha) {
        return ColorUtil.multAlpha(ColorUtil.getPalette().rectColor(), alpha);
    }

    public static int getRectDarker(float alpha) {
        return ColorUtil.multAlpha(ColorUtil.getPalette().rectDarkerColor(), alpha);
    }

    public static int getText(float alpha) {
        return ColorUtil.multAlpha(ColorUtil.getText(), alpha);
    }

    public static int getText() {
        return ColorUtil.getPalette().textColor();
    }

    public static int getDescription() {
        return ColorUtil.getPalette().descriptionColor();
    }

    public static int getDescription(float alpha) {
        return ColorUtil.multAlpha(ColorUtil.getDescription(), alpha);
    }

    public static int getClientColorByIndex(int index) {
        return Theme.getInstance().colorSetting.getColor(index).getColor();
    }

    public static int getClientColor() {
        int[] colors = ColorUtil.getClientColors();
        if (colors.length == 0) {
            return ColorUtil.getColor(255, 255, 255);
        }
        if (colors.length == 1) {
            return colors[0];
        }
        return ColorUtil.multiColorFade(0);
    }

    public static int getClientColorFade(int offset) {
        int[] colors = ColorUtil.getClientColors();
        if (colors.length == 0) {
            return ColorUtil.getColor(255, 255, 255);
        }
        if (colors.length == 1) {
            return colors[0];
        }
        return ColorUtil.multiColorFade(offset);
    }

    public static int getClientColor(float alpha) {
        return ColorUtil.multAlpha(ColorUtil.getClientColor(), alpha);
    }

    public static int getClientColorFade(int offset, float alpha) {
        return ColorUtil.multAlpha(ColorUtil.getClientColorFade(offset), alpha);
    }

    public static int[] getClientColors() {
        return Theme.getInstance().getClientColors();
    }

    public static int getFriendColor() {
        return ColorUtil.getPalette().friendColor();
    }

    public static int getOutline(float alpha, float bright) {
        return ColorUtil.multBright(ColorUtil.multAlpha(ColorUtil.getOutline(), alpha), bright);
    }

    public static int getOutline(float alpha) {
        return ColorUtil.multAlpha(ColorUtil.getOutline(), alpha);
    }

    public static int getOutline() {
        return ColorUtil.getPalette().outlineColor();
    }

    public static boolean isDarkBackground() {
        int b;
        int g;
        int backgroundColor = ColorUtil.getRect(1.0f);
        int r = ColorUtil.red(backgroundColor);
        double luminance = (0.2126 * (double)r + 0.7152 * (double)(g = ColorUtil.green(backgroundColor)) + 0.0722 * (double)(b = ColorUtil.blue(backgroundColor))) / 255.0;
        return luminance < 0.5;
    }

    public static int[] getBadgeColors(String role) {
        int[] nArray;
        switch (role.toUpperCase()) {
            case "YOUTUBE": {
                int[] nArray2 = new int[2];
                nArray2[0] = ColorUtil.parseColor("#de0000");
                nArray = nArray2;
                nArray2[1] = ColorUtil.parseColor("#ffffff");
                break;
            }
            case "DEVELOPER": {
                int[] nArray3 = new int[2];
                nArray3[0] = ColorUtil.parseColor("#ff0000");
                nArray = nArray3;
                nArray3[1] = ColorUtil.parseColor("#7a0000");
                break;
            }
            case "TESTER": {
                int[] nArray4 = new int[2];
                nArray4[0] = ColorUtil.parseColor("#2ecc71");
                nArray = nArray4;
                nArray4[1] = ColorUtil.parseColor("#1abc9c");
                break;
            }
            case "PASTER": {
                int[] nArray5 = new int[2];
                nArray5[0] = ColorUtil.parseColor("#fcff5e");
                nArray = nArray5;
                nArray5[1] = ColorUtil.parseColor("#fbff00");
                break;
            }
            case "CROW": {
                int[] nArray6 = new int[2];
                nArray6[0] = ColorUtil.parseColor("#72eeff");
                nArray = nArray6;
                nArray6[1] = ColorUtil.parseColor("#27b3ff");
                break;
            }
            default: {
                int[] nArray7 = new int[2];
                nArray7[0] = ColorUtil.parseColor("#525050");
                nArray = nArray7;
                nArray7[1] = ColorUtil.parseColor("#a39e9e");
            }
        }
        return nArray;
    }

    private static int parseColor(String hex) {
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        return ColorUtil.getColor(Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16), Integer.parseInt(hex.substring(4, 6), 16), 255);
    }

    private ColorUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        cacheCleaner.scheduleWithFixedDelay(() -> {
            CacheEntry entry = (CacheEntry)cleanupQueue.poll();
            while (entry != null) {
                if (entry.isExpired()) {
                    colorCache.remove(entry.key());
                }
                entry = (CacheEntry)cleanupQueue.poll();
            }
        }, 0L, 1L, TimeUnit.SECONDS);
        RED = ColorUtil.getColor(255, 0, 0);
        GREEN = ColorUtil.getColor(0, 255, 0);
        BLUE = ColorUtil.getColor(0, 0, 255);
        YELLOW = ColorUtil.getColor(255, 255, 0);
        WHITE = ColorUtil.getColor(255);
        BLACK = ColorUtil.getColor(0);
        HALF_BLACK = ColorUtil.getColor(0, 0.5f);
        LIGHT_RED = ColorUtil.getColor(255, 85, 85);
    }

    private record ColorKey(int red, int green, int blue, int alpha) {
    }

    private record CacheEntry(ColorKey key, int color, long expirationTime) implements Delayed
    {
        private CacheEntry(ColorKey key, int color, long expirationTime) {
            this.key = key;
            this.color = color;
            this.expirationTime = System.currentTimeMillis() + expirationTime;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long delay = this.expirationTime - System.currentTimeMillis();
            return unit.convert(delay, TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(@NotNull Delayed other) {
            if (other instanceof CacheEntry) {
                return Long.compare(this.expirationTime, ((CacheEntry)other).expirationTime);
            }
            return 0;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() > this.expirationTime;
        }
    }
}

