/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.entity;

import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import padej.soup.core.server.ServerConfigManager;

public final class VisibleUtils {
    public static VisibilityLevel getVisibilityLevel(class_1309 entity) {
        if (!entity.method_5767()) {
            return VisibilityLevel.FULLY_VISIBLE;
        }
        if (entity.method_6059(class_1294.field_5912) || entity.method_5851()) {
            return VisibilityLevel.PARTIALLY_VISIBLE;
        }
        boolean hasArmor = VisibleUtils.hasEquippedItems(entity);
        if (hasArmor) {
            return VisibilityLevel.PARTIALLY_VISIBLE;
        }
        return VisibilityLevel.FULLY_INVISIBLE;
    }

    public static boolean isFullyVisible(class_1309 entity) {
        return VisibleUtils.getVisibilityLevel(entity) == VisibilityLevel.FULLY_VISIBLE;
    }

    public static boolean isPartiallyVisible(class_1309 entity) {
        return VisibleUtils.getVisibilityLevel(entity) == VisibilityLevel.PARTIALLY_VISIBLE;
    }

    public static boolean isFullyInvisible(class_1309 entity) {
        return VisibleUtils.getVisibilityLevel(entity) == VisibilityLevel.FULLY_INVISIBLE;
    }

    public static boolean canBeTargeted(class_1309 entity) {
        VisibilityLevel level = VisibleUtils.getVisibilityLevel(entity);
        String levelName = level.name();
        return ServerConfigManager.canBeTargeted(levelName);
    }

    public static boolean shouldShowSkin(class_1309 entity) {
        VisibilityLevel level = VisibleUtils.getVisibilityLevel(entity);
        String levelName = level.name();
        return ServerConfigManager.showSkin(levelName);
    }

    public static boolean shouldShowName(class_1309 entity) {
        VisibilityLevel level = VisibleUtils.getVisibilityLevel(entity);
        String levelName = level.name();
        return ServerConfigManager.showName(levelName);
    }

    public static boolean shouldShowHp(class_1309 entity) {
        VisibilityLevel level = VisibleUtils.getVisibilityLevel(entity);
        String levelName = level.name();
        return ServerConfigManager.showHp(levelName);
    }

    private static boolean hasEquippedItems(class_1309 entity) {
        for (class_1799 stack : entity.method_5661()) {
            if (stack.method_7960()) continue;
            return true;
        }
        return false;
    }

    public static String getDisplayName(class_1309 entity) {
        if (!VisibleUtils.shouldShowName(entity)) {
            return "???";
        }
        return entity.method_5477().getString();
    }

    private VisibleUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static enum VisibilityLevel {
        FULLY_VISIBLE,
        PARTIALLY_VISIBLE,
        FULLY_INVISIBLE;

    }
}

