/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.math;

import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_4604;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4d;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.lwjgl.opengl.GL11;
import padej.soup.base.QuickImports;
import padej.soup.base.util.entity.VisibleUtils;
import padej.soup.base.util.math.MathUtil;
import padej.soup.base.util.render.Render3DUtil;

public final class ProjectionUtil
implements QuickImports {
    public static Vector4d getVector4D(class_1297 ent) {
        Vector4d position = null;
        if (ent != null) {
            for (class_243 vector : ProjectionUtil.getVec3ds(ent, MathUtil.interpolate(ent))) {
                vector = ProjectionUtil.worldSpaceToScreenSpace(new class_243(vector.field_1352, vector.field_1351, vector.field_1350));
                if (!(vector.field_1350 > 0.0)) continue;
                if (position == null) {
                    position = new Vector4d(vector.field_1352, vector.field_1351, vector.field_1350, 0.0);
                }
                position.x = Math.min(vector.field_1352, position.x);
                position.y = Math.min(vector.field_1351, position.y);
                position.z = Math.max(vector.field_1352, position.z);
                position.w = Math.max(vector.field_1351, position.w);
            }
        }
        return position;
    }

    @NotNull
    public static class_243 worldSpaceToScreenSpace(class_243 pos) {
        int[] viewport = new int[4];
        GL11.glGetIntegerv((int)2978, (int[])viewport);
        Matrix4f worldMatrix = new Matrix4f((Matrix4fc)Render3DUtil.lastWorldSpaceMatrix.method_23761());
        Matrix4f projMatrix = new Matrix4f((Matrix4fc)Render3DUtil.lastProjMat);
        Vector4f worldPos = new Vector4f((float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350, 1.0f);
        worldPos.mul((Matrix4fc)worldMatrix);
        Vector4f clipPos = new Vector4f();
        projMatrix.transform((Vector4fc)worldPos, clipPos);
        if (clipPos.w() <= 0.0f) {
            return new class_243(0.0, 0.0, -1.0);
        }
        float ndcX = clipPos.x() / clipPos.w();
        float ndcY = clipPos.y() / clipPos.w();
        float ndcZ = clipPos.z() / clipPos.w();
        float screenX = (ndcX * 0.5f + 0.5f) * (float)viewport[2];
        float screenY = (1.0f - (ndcY * 0.5f + 0.5f)) * (float)viewport[3];
        double depth = (double)ndcZ * 0.5 + 0.5;
        return new class_243((double)screenX / mc.method_22683().method_4495(), (double)screenY / mc.method_22683().method_4495(), Math.max(0.0, Math.min(1.0, depth)));
    }

    @NotNull
    public static class_243[] getVec3ds(class_1297 ent, class_243 pos) {
        class_238 axisAlignedBB2 = ent.method_5829();
        class_238 axisAlignedBB = new class_238(axisAlignedBB2.field_1323 - ent.method_23317() + pos.field_1352 - (double)0.1f, axisAlignedBB2.field_1322 - ent.method_23318() + pos.field_1351 - (double)0.1f, axisAlignedBB2.field_1321 - ent.method_23321() + pos.field_1350 - (double)0.1f, axisAlignedBB2.field_1320 - ent.method_23317() + pos.field_1352 + (double)0.1f, axisAlignedBB2.field_1325 - ent.method_23318() + pos.field_1351 + (double)0.1f, axisAlignedBB2.field_1324 - ent.method_23321() + pos.field_1350 + (double)0.1f);
        return new class_243[]{new class_243(axisAlignedBB.field_1323, axisAlignedBB.field_1322, axisAlignedBB.field_1321), new class_243(axisAlignedBB.field_1323, axisAlignedBB.field_1325, axisAlignedBB.field_1321), new class_243(axisAlignedBB.field_1320, axisAlignedBB.field_1322, axisAlignedBB.field_1321), new class_243(axisAlignedBB.field_1320, axisAlignedBB.field_1325, axisAlignedBB.field_1321), new class_243(axisAlignedBB.field_1323, axisAlignedBB.field_1322, axisAlignedBB.field_1324), new class_243(axisAlignedBB.field_1323, axisAlignedBB.field_1325, axisAlignedBB.field_1324), new class_243(axisAlignedBB.field_1320, axisAlignedBB.field_1322, axisAlignedBB.field_1324), new class_243(axisAlignedBB.field_1320, axisAlignedBB.field_1325, axisAlignedBB.field_1324)};
    }

    public static boolean canSee(class_238 box) {
        class_4604 frustum = ProjectionUtil.mc.field_1769.field_27740;
        return box != null && frustum != null && frustum.method_23093(box);
    }

    public static boolean cantSee(Vector4d vec) {
        return vec == null || vec.x < 0.0 && vec.z < 1.0 || vec.y < 0.0 && vec.w < 1.0;
    }

    public static boolean canSeeEntity(class_1297 entity) {
        if (entity == null || ProjectionUtil.mc.field_1724 == null) {
            return false;
        }
        double distance = ProjectionUtil.mc.field_1724.method_19538().method_1022(entity.method_19538());
        if (distance > 16.0) {
            return false;
        }
        if (Objects.requireNonNull(ProjectionUtil.mc.field_1724).method_6057(entity)) {
            if (entity instanceof class_1309) {
                class_1309 living = (class_1309)entity;
                return VisibleUtils.canBeTargeted(living);
            }
            return !entity.method_5767() || entity.method_5851();
        }
        return false;
    }

    public static double centerX(Vector4d vec) {
        return vec.x + (vec.z - vec.x) / 2.0;
    }

    public static Vector4d getVector4DForAnchor(class_1297 ent, String anchor) {
        if (ent == null) {
            return null;
        }
        Vector4d fullProjection = ProjectionUtil.getVector4D(ent);
        if (fullProjection == null) {
            return null;
        }
        class_243 entityPos = MathUtil.interpolate(ent);
        class_243 anchorPos = ProjectionUtil.getAnchorPos(ent, anchor, entityPos);
        class_243 screenPos = ProjectionUtil.worldSpaceToScreenSpace(anchorPos);
        if (screenPos.field_1350 > 0.0) {
            return new Vector4d(fullProjection.x, screenPos.field_1351, fullProjection.z, fullProjection.w);
        }
        return null;
    }

    @NotNull
    private static class_243 getAnchorPos(class_1297 ent, String anchor, class_243 entityPos) {
        class_238 boundingBox = ent.method_5829();
        double height = boundingBox.field_1325 - boundingBox.field_1322;
        double yOffset = 0.0;
        switch (anchor) {
            case "HEAD": {
                yOffset = height * 0.85;
                break;
            }
            case "BODY": {
                yOffset = height * 0.5;
                break;
            }
            case "FEET": {
                yOffset = 0.1;
            }
        }
        return new class_243(entityPos.field_1352, entityPos.field_1351 + yOffset, entityPos.field_1350);
    }

    private ProjectionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

