/*
 * Decompiled with CFR 0.152.
 */
package padej.soup.base.util.other;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class RoleCache {
    private static final String API_URL = "https://77.110.111.251/api";
    private static final long CACHE_DURATION = 60000L;
    private static final boolean SERVER_ENABLED = true;
    private static final Map<String, String> roleCache = new ConcurrentHashMap<String, String>();
    private static final Map<String, Long> cacheTimestamps = new ConcurrentHashMap<String, Long>();
    private static final Map<String, String> persistentRoleCache = new ConcurrentHashMap<String, String>();
    private static Set<String> developers = new HashSet<String>();
    private static Set<String> youtubers = new HashSet<String>();
    private static Set<String> testers = new HashSet<String>();
    private static Set<String> pasters = new HashSet<String>();
    private static Set<String> crow = new HashSet<String>();
    private static long lastFullRefresh = 0L;
    private static final long FULL_REFRESH_INTERVAL = 300000L;
    private static final long RECONNECT_INTERVAL_MS = 30000L;
    private static final long RECONNECT_BACKOFF_MAX_MS = 300000L;
    private static final AtomicBoolean serverAvailable = new AtomicBoolean(true);
    private static final AtomicBoolean reconnectionActive = new AtomicBoolean(false);
    private static final ScheduledExecutorService reconnectionScheduler;
    private static long currentReconnectDelay;
    private static final Set<String> FALLBACK_DEVS;
    private static final Set<String> FALLBACK_YTS;
    private static final Set<String> FALLBACK_TESTERS;
    private static final Set<String> FALLBACK_PASTERS;
    private static final Set<String> FALLBACK_CROW;

    public static String getUserRole(String username) {
        if (System.currentTimeMillis() - lastFullRefresh > 300000L) {
            RoleCache.refreshAllRolesAsync();
        }
        String cachedRole = roleCache.get(username);
        Long cacheTime = cacheTimestamps.get(username);
        if (cachedRole != null && cacheTime != null && System.currentTimeMillis() - cacheTime < 60000L) {
            return cachedRole;
        }
        String role = RoleCache.determineRoleFromSets(username);
        if (!role.equals("USER")) {
            persistentRoleCache.put(username, role);
        }
        if (role.equals("USER") && persistentRoleCache.containsKey(username)) {
            role = persistentRoleCache.get(username);
        }
        roleCache.put(username, role);
        cacheTimestamps.put(username, System.currentTimeMillis());
        return role;
    }

    public static CompletableFuture<String> fetchUserRoleFromServer(String username) {
        return CompletableFuture.supplyAsync(() -> {
            String role;
            block19: {
                String string;
                URL url = new URL("https://77.110.111.251/api/roles/user");
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setDoOutput(true);
                conn.setConnectTimeout(3000);
                conn.setReadTimeout(3000);
                JsonObject json = new JsonObject();
                json.addProperty("username", username);
                try (OutputStream os = conn.getOutputStream();){
                    byte[] input = json.toString().getBytes(StandardCharsets.UTF_8);
                    os.write(input, 0, input.length);
                }
                int responseCode = conn.getResponseCode();
                if (responseCode != 200) break block19;
                BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));
                try {
                    String responseLine;
                    StringBuilder response = new StringBuilder();
                    while ((responseLine = br.readLine()) != null) {
                        response.append(responseLine.trim());
                    }
                    JsonObject jsonResponse = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                    String role2 = jsonResponse.get("role").getAsString();
                    roleCache.put(username, role2);
                    cacheTimestamps.put(username, System.currentTimeMillis());
                    if (!role2.equals("USER")) {
                        persistentRoleCache.put(username, role2);
                    }
                    if (!serverAvailable.get()) {
                        RoleCache.onServerConnectionSuccess();
                    }
                    string = role2;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            br.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        if (serverAvailable.get()) {
                            RoleCache.onServerConnectionFailure();
                        }
                        if (!persistentRoleCache.containsKey(username)) break block19;
                        return persistentRoleCache.get(username);
                    }
                }
                br.close();
                return string;
            }
            if ((role = RoleCache.determineRoleFromSets(username)).equals("USER") && persistentRoleCache.containsKey(username)) {
                role = persistentRoleCache.get(username);
            }
            return role;
        });
    }

    private static void refreshAllRolesSync() throws Exception {
        URL url = new URL("https://77.110.111.251/api/roles");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(5000);
        conn.setReadTimeout(5000);
        int responseCode = conn.getResponseCode();
        if (responseCode == 200) {
            try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), StandardCharsets.UTF_8));){
                String responseLine;
                StringBuilder response = new StringBuilder();
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine.trim());
                }
                JsonObject jsonResponse = JsonParser.parseString((String)response.toString()).getAsJsonObject();
                developers = RoleCache.jsonArrayToSet(jsonResponse.getAsJsonArray("developers"));
                youtubers = RoleCache.jsonArrayToSet(jsonResponse.getAsJsonArray("youtubers"));
                testers = RoleCache.jsonArrayToSet(jsonResponse.getAsJsonArray("testers"));
                pasters = RoleCache.jsonArrayToSet(jsonResponse.getAsJsonArray("pasters"));
                crow = RoleCache.jsonArrayToSet(jsonResponse.getAsJsonArray("crow"));
                RoleCache.updatePersistentCacheFromSets();
                lastFullRefresh = System.currentTimeMillis();
                roleCache.clear();
                cacheTimestamps.clear();
            }
        } else {
            throw new Exception("HTTP error code: " + responseCode);
        }
    }

    public static CompletableFuture<Void> refreshAllRolesAsync() {
        return CompletableFuture.runAsync(() -> {
            try {
                RoleCache.refreshAllRolesSync();
                RoleCache.onServerConnectionSuccess();
            }
            catch (Exception e) {
                RoleCache.onServerConnectionFailure();
            }
        });
    }

    private static void startReconnectionTask() {
        if (reconnectionScheduler == null) {
            return;
        }
        if (!reconnectionActive.compareAndSet(false, true)) {
            return;
        }
        reconnectionScheduler.schedule(() -> {
            try {
                RoleCache.refreshAllRolesSync();
                RoleCache.onServerConnectionSuccess();
            }
            catch (Exception e) {
                RoleCache.onServerConnectionFailure();
            }
        }, currentReconnectDelay, TimeUnit.MILLISECONDS);
    }

    private static void onServerConnectionSuccess() {
        boolean wasUnavailable;
        boolean bl = wasUnavailable = !serverAvailable.getAndSet(true);
        if (wasUnavailable) {
            currentReconnectDelay = 30000L;
            reconnectionActive.set(false);
        }
    }

    private static void onServerConnectionFailure() {
        serverAvailable.set(false);
        currentReconnectDelay = Math.min(currentReconnectDelay * 2L, 300000L);
        reconnectionActive.set(false);
        RoleCache.startReconnectionTask();
    }

    public static boolean isServerAvailable() {
        return serverAvailable.get();
    }

    public static void shutdown() {
        if (reconnectionScheduler != null && !reconnectionScheduler.isShutdown()) {
            reconnectionScheduler.shutdown();
            try {
                if (!reconnectionScheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    reconnectionScheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                reconnectionScheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    private static String determineRoleFromSets(String username) {
        if (RoleCache.containsIgnoreCase(developers, username)) {
            return "DEVELOPER";
        }
        if (RoleCache.containsIgnoreCase(youtubers, username)) {
            return "YOUTUBE";
        }
        if (RoleCache.containsIgnoreCase(testers, username)) {
            return "TESTER";
        }
        if (RoleCache.containsIgnoreCase(pasters, username)) {
            return "PASTER";
        }
        if (RoleCache.containsIgnoreCase(crow, username)) {
            return "CROW";
        }
        return "USER";
    }

    private static boolean containsIgnoreCase(Set<String> set, String username) {
        return set.stream().anyMatch(s -> s.equalsIgnoreCase(username));
    }

    private static void updatePersistentCacheFromSets() {
        for (String username : developers) {
            persistentRoleCache.put(username, "DEVELOPER");
        }
        for (String username : youtubers) {
            persistentRoleCache.put(username, "YOUTUBE");
        }
        for (String username : testers) {
            persistentRoleCache.put(username, "TESTER");
        }
        for (String username : pasters) {
            persistentRoleCache.put(username, "PASTER");
        }
        for (String username : crow) {
            persistentRoleCache.put(username, "CROW");
        }
    }

    private static Set<String> jsonArrayToSet(JsonArray jsonArray) {
        HashSet<String> set = new HashSet<String>();
        if (jsonArray != null) {
            jsonArray.forEach(element -> set.add(element.getAsString()));
        }
        return set;
    }

    public static void clearCache() {
        roleCache.clear();
        cacheTimestamps.clear();
    }

    public static void forceRefresh() {
        lastFullRefresh = 0L;
        RoleCache.clearCache();
        RoleCache.refreshAllRolesAsync();
    }

    public static Map<String, String> getRoleCache() {
        return roleCache;
    }

    public static Set<String> getDevelopers() {
        return developers;
    }

    public static Set<String> getYoutubers() {
        return youtubers;
    }

    public static Set<String> getTesters() {
        return testers;
    }

    public static Set<String> getPasters() {
        return pasters;
    }

    public static Set<String> getCrow() {
        return crow;
    }

    static {
        currentReconnectDelay = 30000L;
        FALLBACK_DEVS = Set.of("Winvi_", "winvi", "Padej_");
        FALLBACK_YTS = Set.of("TheTrix", "felonn", "NazarioQp");
        FALLBACK_TESTERS = Set.of("nomadvorga", "Nomadvorga", "NomadvorgaYT", "Fix88");
        FALLBACK_PASTERS = Set.of("NightlyFever", "Nightly", "Anim4ik", "Flerni", "FlerniV1", "FlerniV2");
        FALLBACK_CROW = Set.of("IcyCrow");
        developers.addAll(FALLBACK_DEVS);
        youtubers.addAll(FALLBACK_YTS);
        testers.addAll(FALLBACK_TESTERS);
        pasters.addAll(FALLBACK_PASTERS);
        crow.addAll(FALLBACK_CROW);
        RoleCache.updatePersistentCacheFromSets();
        RoleCache.clearCache();
        reconnectionScheduler = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread t = new Thread(r, "RoleCache-Reconnection");
            t.setDaemon(true);
            return t;
        });
        try {
            RoleCache.refreshAllRolesSync();
            serverAvailable.set(true);
        }
        catch (Exception e) {
            serverAvailable.set(false);
            RoleCache.startReconnectionTask();
        }
    }
}

